/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.util.Locale;
import org.apache.lucene.document.Document;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.A_CmsSearchIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;
import org.opencms.search.galleries.CmsGallerySearchIndex;
import org.opencms.search.galleries.CmsGallerySearchParameters;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.search.galleries.CmsGallerySearchResultList;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsGallerySearch {
    protected transient CmsObject m_cms;
    CmsGallerySearchIndex m_index;

    public static CmsGallerySearchResult searchById(CmsObject cms, CmsUUID structureId, Locale locale) throws CmsException {
        CmsGallerySearch gallerySearch = new CmsGallerySearch();
        gallerySearch.init(cms);
        gallerySearch.setIndex("Gallery Index");
        return gallerySearch.searchById(structureId, locale);
    }

    public String getIndex() {
        return this.getSearchIndex().getName();
    }

    public CmsGallerySearchResultList getResult(CmsGallerySearchParameters params) throws CmsException {
        CmsGallerySearchResultList result = null;
        if (this.m_cms == null && this.m_index == null) {
            throw new CmsException(Messages.get().container("ERR_SEARCH_NOT_INITIALIZED_0"));
        }
        result = this.m_index.searchGallery(this.m_cms, params);
        if (result.size() > 0) {
            result.calculatePages(params.getResultPage(), params.getMatchesPerPage());
        } else {
            result = new CmsGallerySearchResultList();
        }
        return result;
    }

    public CmsGallerySearchIndex getSearchIndex() {
        return this.m_index;
    }

    public void init(CmsObject cms) {
        this.m_cms = cms;
    }

    public CmsGallerySearchResult searchById(CmsUUID id, Locale locale) throws CmsException {
        I_CmsSearchDocument sDoc = this.m_index.getDocument("res_structureId", id.toString());
        CmsGallerySearchResult result = null;
        if (sDoc != null && sDoc.getDocument() != null) {
            Document doc = (Document)sDoc.getDocument();
            result = new CmsGallerySearchResult(this.m_cms, 100, doc, null, locale);
        } else {
            CmsResource res = this.m_cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
            result = new CmsGallerySearchResult(this.m_cms, res);
        }
        return result;
    }

    public void setIndex(String indexName) throws CmsException {
        if (CmsStringUtil.isEmpty(indexName)) {
            throw new CmsException(Messages.get().container("ERR_INDEXSOURCE_CREATE_MISSING_NAME_0"));
        }
        A_CmsSearchIndex index = OpenCms.getSearchManager().getIndex(indexName);
        if (index == null) {
            throw new CmsException(Messages.get().container("ERR_INDEX_NOT_FOUND_1", indexName));
        }
        if (!(index instanceof CmsGallerySearchIndex)) {
            throw new CmsException(Messages.get().container("ERR_INDEX_WRONG_CLASS_2", indexName, CmsGallerySearchIndex.class.getName()));
        }
        this.m_index = (CmsGallerySearchIndex)index;
    }
}

