/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;
import org.opencms.search.CmsLuceneIndex;

public class CmsGallerySearchAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;

    public CmsGallerySearchAnalyzer(Version version) throws IOException {
        super(version, (Set)WordlistLoader.getWordSet((Reader)new BufferedReader(new InputStreamReader(CmsGallerySearchAnalyzer.class.getResourceAsStream("stopwords_multilanguage.txt"))), (String)"#", (Version)CmsLuceneIndex.LUCENE_VERSION));
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        final StandardTokenizer src = new StandardTokenizer(this.matchVersion, reader);
        src.setMaxTokenLength(255);
        StandardFilter tok = new StandardFilter(this.matchVersion, (TokenStream)src);
        tok = new LowerCaseFilter(this.matchVersion, (TokenStream)tok);
        tok = new StopFilter(this.matchVersion, (TokenStream)tok, (Set)this.stopwords);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)src, (TokenStream)tok){

            protected boolean reset(Reader r) throws IOException {
                src.setMaxTokenLength(255);
                return super.reset(r);
            }
        };
    }
}

