/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.main.OpenCms;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.galleries.CmsGallerySearchInfoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsGallerySearchFieldMapping
extends CmsSearchFieldMapping {
    public static final String FIELD_ADDITIONAL_INFO = "additional_info";
    public static final String FIELD_CONTAINER_TYPES = "container_types";
    public static final String FIELD_RESOURCE_DATE_EXPIRED = "res_dateExpired";
    public static final String FIELD_RESOURCE_DATE_RELEASED = "res_dateReleased";
    public static final String FIELD_RESOURCE_LENGTH = "res_length";
    public static final String FIELD_RESOURCE_STATE = "res_state";
    public static final String FIELD_RESOURCE_STRUCTURE_ID = "res_structureId";
    public static final String FIELD_RESOURCE_USER_CREATED = "res_userCreated";
    public static final String FIELD_RESOURCE_USER_LASTMODIFIED = "res_userLastModified";
    private static final long serialVersionUID = -9040025344745155491L;

    public CmsGallerySearchFieldMapping() {
    }

    public CmsGallerySearchFieldMapping(CmsSearchFieldMappingType type, String param) {
        super(type, param);
    }

    @Override
    public String getStringValue(CmsObject cms, CmsResource res, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        String result = null;
        if (this.getType().getMode() == CmsSearchFieldMappingType.DYNAMIC.getMode()) {
            if (FIELD_ADDITIONAL_INFO.equals(this.getParam())) {
                result = CmsGallerySearchInfoProvider.getAdditionalInfo(cms, res, extractionResult, properties, propertiesSearched);
            } else if (FIELD_CONTAINER_TYPES.equals(this.getParam())) {
                result = CmsGallerySearchInfoProvider.getContainerTypes(cms, res, extractionResult, properties, propertiesSearched);
            } else if ("res_locales".equals(this.getParam())) {
                List<Locale> locales = null;
                if (CmsResourceTypeXmlContent.isXmlContent(res)) {
                    result = extractionResult.getContentItems().get("res_locales");
                } else {
                    locales = OpenCms.getLocaleManager().getAvailableLocales(cms, res);
                    StringBuffer buf = new StringBuffer();
                    for (Locale locale : locales) {
                        buf.append(locale.toString());
                        buf.append(' ');
                    }
                    result = buf.toString();
                }
            }
        } else {
            result = super.getStringValue(cms, res, extractionResult, properties, propertiesSearched);
        }
        return result;
    }
}

