/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.CmsDocumentDependency;
import org.opencms.search.fields.I_CmsSearchField;
import org.opencms.search.solr.CmsSolrField;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSolrDocument
implements I_CmsSearchDocument {
    private static final Log LOG = CmsLog.getLog(CmsSolrDocument.class);
    private SolrInputDocument m_doc;
    private float m_score;

    public CmsSolrDocument(SolrDocument doc) {
        this.m_doc = ClientUtils.toSolrInputDocument((SolrDocument)doc);
    }

    public CmsSolrDocument(SolrInputDocument doc) {
        this.m_doc = doc;
    }

    @Override
    public void addCategoryField(List<CmsCategory> categories) {
        if (categories != null && categories.size() > 0) {
            for (CmsCategory category : categories) {
                this.m_doc.addField("category", (Object)category.getPath());
            }
        }
    }

    @Override
    public void addContentField(byte[] data) {
        this.m_doc.setField("contentblob", (Object)ByteBuffer.wrap(data));
    }

    @Override
    public void addContentLocales(List<Locale> locales) {
        if (locales != null && !locales.isEmpty()) {
            for (Locale locale : locales) {
                this.m_doc.addField("con_locales", (Object)locale.toString());
            }
        }
    }

    @Override
    public void addDateField(String name, long time, boolean analyzed) {
        String dateValue = DateField.formatExternal((Date)new Date(time));
        this.m_doc.addField(name, (Object)dateValue);
        if (analyzed) {
            this.m_doc.addField(name + "_lookup", (Object)dateValue);
        }
    }

    public void addDocumentDependency(CmsObject cms, CmsDocumentDependency resDeps) {
        this.m_doc.addField("dependencyType", (Object)resDeps.getType());
        for (CmsDocumentDependency dep : resDeps.getDependencies()) {
            this.m_doc.addField("dep_" + dep.getType().toString(), (Object)dep.toJSON(cms, true).toString());
        }
    }

    @Override
    public void addPathField(String rootPath) {
        String folderName = CmsResource.getFolderPath(rootPath);
        for (int i = 0; i < folderName.length(); ++i) {
            char c = folderName.charAt(i);
            if (c != '/') continue;
            this.m_doc.addField("parent-folders", (Object)folderName.substring(0, i + 1));
        }
    }

    @Override
    public void addResourceLocales(List<Locale> locales) {
        if (locales != null && !locales.isEmpty()) {
            for (Locale locale : locales) {
                this.m_doc.addField("res_locales", (Object)locale.toString());
            }
        }
    }

    @Override
    public void addRootPathField(String rootPath) {
        this.m_doc.addField("path", (Object)rootPath);
    }

    @Override
    public void addSearchField(I_CmsSearchField sfield, String value) {
        CmsSolrField field = (CmsSolrField)sfield;
        ArrayList<String> fieldsToAdd = new ArrayList<String>(Collections.singletonList(field.getName()));
        if (field.getCopyFields() != null && !field.getCopyFields().isEmpty()) {
            fieldsToAdd.addAll(field.getCopyFields());
        }
        for (String fieldName : fieldsToAdd) {
            IndexSchema schema = OpenCms.getSearchManager().getSolrServerConfiguration().getSolrSchema();
            try {
                SolrInputField exfield;
                FieldType type = schema.getFieldType(fieldName);
                if (type instanceof DateField) {
                    value = DateField.formatExternal((Date)new Date(new Long(value)));
                }
                if ((exfield = this.m_doc.getField(fieldName)) == null) {
                    if (schema.hasExplicitField(fieldName)) {
                        this.m_doc.addField(fieldName, (Object)value);
                        continue;
                    }
                    this.m_doc.addField(fieldName, (Object)value, field.getBoost());
                    continue;
                }
                if (schema.hasExplicitField(fieldName)) {
                    this.m_doc.setField(fieldName, (Object)value);
                    continue;
                }
                this.m_doc.setField(fieldName, (Object)value, field.getBoost());
            }
            catch (SolrException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void addSuffixField(String suffix) {
        this.m_doc.addField("suffix", (Object)suffix);
    }

    @Override
    public void addTypeField(String type) {
        this.m_doc.addField("type", (Object)type);
    }

    @Override
    public byte[] getContentBlob() {
        Object o = this.m_doc.getFieldValue("contentblob");
        if (o != null) {
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            return o.toString().getBytes();
        }
        return null;
    }

    @Override
    public Object getDocument() {
        return this.m_doc;
    }

    @Override
    public List<String> getFieldNames() {
        return new ArrayList<String>(this.m_doc.getFieldNames());
    }

    @Override
    public Date getFieldValueAsDate(String fieldName) {
        Object o = this.m_doc.getFieldValue(fieldName);
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o != null) {
            try {
                return DateField.parseDate((String)o.toString());
            }
            catch (ParseException e) {
                LOG.debug((Object)e);
            }
        }
        return null;
    }

    @Override
    public String getFieldValueAsString(String fieldName) {
        Object o = this.m_doc.getFieldValue(fieldName);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    @Override
    public List<String> getMultivaluedFieldAsStringList(String fieldName) {
        ArrayList<String> result = new ArrayList<String>();
        Collection coll = this.m_doc.getFieldValues(fieldName);
        if (coll != null) {
            for (Object o : coll) {
                if (o == null) continue;
                result.add(o.toString());
            }
            return result;
        }
        return null;
    }

    @Override
    public String getPath() {
        return this.getFieldValueAsString("path");
    }

    @Override
    public float getScore() {
        Float score = (Float)this.getSolrDocument().getFirstValue("score");
        if (score != null) {
            this.m_score = score.floatValue();
            return this.m_score;
        }
        return 0.0f;
    }

    public SolrDocument getSolrDocument() {
        return ClientUtils.toSolrDocument((SolrInputDocument)this.m_doc);
    }

    @Override
    public String getType() {
        return this.getFieldValueAsString("type");
    }

    @Override
    public void setBoost(float boost) {
        this.m_doc.setDocumentBoost(boost);
    }

    public void setId(CmsUUID structureId) {
        this.m_doc.addField("id", (Object)structureId);
    }

    @Override
    public void setScore(float score) {
        this.m_score = score;
    }

    public String toString() {
        return this.getFieldValueAsString("path");
    }
}

