/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.A_CmsSearchIndex;
import org.opencms.search.CmsIndexException;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.I_CmsSearchField;
import org.opencms.search.solr.CmsSolrDocumentXmlContent;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSolrDocumentContainerPage
extends CmsSolrDocumentXmlContent {
    public static final String TYPE_CONTAINERPAGE_SOLR = "containerpage-solr";
    private static final Log LOG = CmsLog.getLog(CmsSolrDocumentContainerPage.class);

    public CmsSolrDocumentContainerPage(String name) {
        super(name);
    }

    @Override
    public I_CmsSearchDocument createDocument(CmsObject cms, CmsResource resource, A_CmsSearchIndex index) throws CmsException {
        I_CmsExtractionResult content = null;
        if (index.isExtractingContent()) {
            try {
                content = this.extractContent(cms, resource, index);
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
            }
        }
        return index.getFieldConfiguration().createDocument(cms, resource, index, content);
    }

    @Override
    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, A_CmsSearchIndex index) throws CmsException {
        this.logContentExtraction(resource, index);
        try {
            CmsFile file = this.readFile(cms, resource);
            CmsXmlContainerPage containerPage = CmsXmlContainerPageFactory.unmarshal(cms, file);
            Locale locale = index.getLocaleForResource(cms, resource, containerPage.getLocales());
            ArrayList<I_CmsExtractionResult> all = new ArrayList<I_CmsExtractionResult>();
            CmsContainerPageBean containerBean = containerPage.getContainerPage(cms, locale);
            for (CmsContainerElementBean element : containerBean.getElements()) {
                element.initResource(cms);
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(element.getResource());
                CmsFormatterConfiguration formatters = type.getFormattersForResource(cms, element.getResource());
                if (!formatters.isSearchContent(element.getFormatterId())) continue;
                element.initResource(cms);
                all.add(super.extractContent(cms, element.getResource(), index));
            }
            return this.merge(all);
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    @Override
    public boolean isLocaleDependend() {
        return true;
    }

    @Override
    public boolean isUsingCache() {
        return true;
    }

    private I_CmsExtractionResult merge(List<I_CmsExtractionResult> all) {
        StringBuffer content = new StringBuffer();
        HashMap<String, String> items = new HashMap<String, String>();
        HashSet<I_CmsSearchField> fields = new HashSet<I_CmsSearchField>();
        for (I_CmsExtractionResult ex : all) {
            if (ex.getContent() != null) {
                content.append(ex.getContent());
            }
            if (ex.getContentItems() != null) {
                items.putAll(ex.getContentItems());
            }
            if (ex.getMappingFields() == null) continue;
            fields.addAll(ex.getMappingFields());
        }
        return new CmsExtractionResult(content.toString(), items, fields);
    }
}

