/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.search.A_CmsSearchIndex;
import org.opencms.search.CmsIndexException;
import org.opencms.search.documents.CmsDocumentXmlContent;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.A_CmsSearchFieldConfiguration;
import org.opencms.search.fields.I_CmsSearchField;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsSolrDocumentXmlContent
extends CmsDocumentXmlContent {
    public static final String TYPE_XMLCONTENT_SOLR = "xmlcontent-solr";

    public CmsSolrDocumentXmlContent(String name) {
        super(name);
    }

    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, A_CmsSearchIndex index) throws CmsException {
        this.logContentExtraction(resource, index);
        try {
            CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, this.readFile(cms, resource));
            HashMap<String, String> items = new HashMap<String, String>();
            StringBuffer locales = new StringBuffer();
            Locale resLocale = index.getLocaleForResource(cms, resource, xmlContent.getLocales());
            String defaultContent = null;
            for (Locale locale : xmlContent.getLocales()) {
                locales.append(locale.toString());
                locales.append(' ');
                StringBuffer content = new StringBuffer();
                for (String xpath : xmlContent.getNames(locale)) {
                    I_CmsXmlContentValue value = xmlContent.getValue(xpath, locale);
                    String extracted = value.getPlainText(cms);
                    if (!value.isSimpleType()) continue;
                    if (value.getContentDefinition().getContentHandler().isSearchable(value) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) {
                        content.append(extracted);
                        content.append('\n');
                        items.put(xpath, extracted);
                    }
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(extracted) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(value.getStringValue(cms))) {
                        try {
                            extracted = value.getStringValue(cms);
                            items.put(xpath, extracted);
                        }
                        catch (CmsRuntimeException re) {
                            // empty catch block
                        }
                    }
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) continue;
                    items.put(A_CmsSearchFieldConfiguration.getLocaleExtendedName(CmsXmlUtils.removeXpath(xpath), locale), extracted);
                }
                if (content.length() > 0) {
                    String contentKey = A_CmsSearchFieldConfiguration.getLocaleExtendedName("content", locale);
                    items.put(contentKey, content.toString());
                    if (resLocale.equals(locale)) {
                        defaultContent = content.toString();
                    }
                }
                items.put("res_locales", locales.toString());
            }
            HashSet<I_CmsSearchField> fields = new HashSet<I_CmsSearchField>(xmlContent.getHandler().getSearchFields());
            return new CmsExtractionResult(defaultContent, items, fields);
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }
}

