/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.solr.common.SolrInputDocument;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.CmsDocumentDependency;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.A_CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.fields.I_CmsSearchField;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.search.solr.CmsSolrDocument;
import org.opencms.search.solr.CmsSolrField;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSolrFieldConfiguration
extends A_CmsSearchFieldConfiguration {
    private static final Pattern LOCALE_SUFFIX_PATTERN = Pattern.compile("_([a-z]{2}(?:_[A-Z]{2})?)(?:\\.[^\\.]*)?$");
    private static final Log LOG = CmsLog.getLog(CmsSolrFieldConfiguration.class);
    private List<I_CmsSearchField> m_additionalFields;
    private boolean m_initialized;

    public static Locale getLocaleFromFileName(String rootPath) {
        String suffix = CmsSolrFieldConfiguration.getLocaleSuffix(CmsResource.getName(rootPath));
        if (suffix != null) {
            String laguageString = suffix.substring(0, 2);
            return suffix.length() == 5 ? new Locale(laguageString, suffix.substring(3, 5)) : new Locale(laguageString);
        }
        return null;
    }

    public static String getLocaleSuffix(String resourcename) {
        Matcher matcher = LOCALE_SUFFIX_PATTERN.matcher(resourcename);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public I_CmsSearchDocument createEmptyDocument(CmsResource resource) {
        CmsSolrDocument doc = new CmsSolrDocument(new SolrInputDocument());
        doc.setId(resource.getStructureId());
        return doc;
    }

    @Override
    protected I_CmsSearchDocument appendDates(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        document.addDateField("created", resource.getDateCreated(), false);
        document.addDateField("lastmodified", resource.getDateLastModified(), false);
        document.addDateField("contentdate", resource.getDateContent(), false);
        document.addDateField("relased", resource.getDateReleased(), false);
        document.addDateField("expired", resource.getDateExpired(), false);
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendFieldMapping(I_CmsSearchDocument document, I_CmsSearchField sfield, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        CmsSolrField field = (CmsSolrField)sfield;
        try {
            StringBuffer text = new StringBuffer();
            for (I_CmsSearchFieldMapping mapping : field.getMappings()) {
                if (extractionResult == null) continue;
                String mapResult = null;
                if (field.getLocale() != null && mapping.getType().equals(CmsSearchFieldMappingType.CONTENT)) {
                    String key = A_CmsSearchFieldConfiguration.getLocaleExtendedName("content", field.getLocale());
                    mapResult = extractionResult.getContentItems().get(key);
                    if (mapResult == null && !CmsResourceTypeXmlContent.isXmlContent(resource) && !CmsResourceTypeXmlPage.isXmlPage(resource) && this.getContentLocales(cms, resource).contains(field.getLocale())) {
                        mapResult = extractionResult.getContent();
                    }
                } else {
                    mapResult = mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched);
                }
                if (mapResult != null) {
                    if (text.length() > 0) {
                        text.append('\n');
                    }
                    text.append(mapResult);
                    continue;
                }
                if (mapping.getDefaultValue() == null) continue;
                text.append("\n" + mapping.getDefaultValue());
            }
            if (text.length() <= 0 && field.getDefaultValue() != null) {
                text.append(field.getDefaultValue());
            }
            if (text.length() > 0) {
                document.addSearchField(field, text.toString());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendFieldMappings(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        if (!this.m_initialized) {
            this.init();
        }
        if (extractionResult != null && extractionResult.getMappingFields() != null) {
            for (I_CmsSearchField field : extractionResult.getMappingFields()) {
                document = this.appendFieldMapping(document, field, cms, resource, extractionResult, properties, propertiesSearched);
            }
        }
        return super.appendFieldMappings(document, cms, resource, extractionResult, properties, propertiesSearched);
    }

    @Override
    protected I_CmsSearchDocument appendLocales(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        List<String> itemLocales = null;
        ArrayList<Locale> resourceLocales = new ArrayList();
        if (extraction != null && extraction.getContentItems() != null && extraction.getContentItems().get("res_locales") != null) {
            String localesAsString = extraction.getContentItems().get("res_locales");
            itemLocales = CmsStringUtil.splitAsList(localesAsString, ' ');
            for (String locale : itemLocales) {
                resourceLocales.add(new Locale(locale));
            }
        } else {
            resourceLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        }
        document.addResourceLocales(resourceLocales);
        List<Object> contentLocales = new ArrayList();
        contentLocales = itemLocales != null ? resourceLocales : this.getContentLocales(cms, resource);
        document.addContentLocales(contentLocales);
        if (this.hasLocaleDependencies()) {
            CmsDocumentDependency dep = CmsDocumentDependency.load(cms, resource);
            ((CmsSolrDocument)document).addDocumentDependency(cms, dep);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendProperties(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        for (CmsProperty prop : propertiesSearched) {
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(prop.getValue())) continue;
            document.addSearchField(new CmsSolrField(prop.getName() + "_prop", null, null, null, 1.0f), prop.getValue());
        }
        return document;
    }

    protected void setAdditionalFields(List<I_CmsSearchField> additionalFields) {
        this.m_additionalFields = additionalFields;
    }

    private void addAdditionalFields() {
        if (this.m_additionalFields != null) {
            this.addFields(this.m_additionalFields);
        }
    }

    private void addContentFields() {
        CmsSolrField solrField = new CmsSolrField("content", null, null, null, 1.0f);
        solrField.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, "content"));
        this.addField(solrField);
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            solrField = new CmsSolrField(A_CmsSearchFieldConfiguration.getLocaleExtendedName("content", locale), Collections.singletonList(locale.toString() + "_excerpt"), locale, null, 1.0f);
            solrField.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, "content"));
            this.addField(solrField);
        }
    }

    private void addLuceneFields() {
        ArrayList<I_CmsSearchField> fieldsToAdd = new ArrayList<I_CmsSearchField>();
        for (I_CmsSearchField field : this.getFields()) {
            if (!(field instanceof CmsSearchField)) continue;
            fieldsToAdd.add(new CmsSolrField((CmsSearchField)field));
        }
        this.addFields(fieldsToAdd);
    }

    private List<Locale> getContentLocales(CmsObject cms, CmsResource resource) {
        List<Locale> contentLocales = new ArrayList<Locale>();
        Locale fileNameLocale = CmsSolrFieldConfiguration.getLocaleFromFileName(resource.getRootPath());
        contentLocales.add(fileNameLocale);
        if (fileNameLocale == null) {
            contentLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        }
        return contentLocales;
    }

    private boolean hasLocaleDependencies() {
        for (CmsSearchIndexSource source : this.getIndex().getSources()) {
            if (!source.getIndexer().isLocaleDependenciesEnable()) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.addContentFields();
        this.addAdditionalFields();
        this.addLuceneFields();
        this.m_initialized = true;
    }
}

