/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.FastWriter;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.search.A_CmsSearchIndex;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.CmsSearchResource;
import org.opencms.search.CmsSearchResultList;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.solr.CmsSolrDocument;
import org.opencms.search.solr.CmsSolrIndexWriter;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.search.solr.I_CmsSolrPostSearchProcessor;
import org.opencms.search.solr.Messages;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSolrIndex
extends A_CmsSearchIndex {
    public static final String DEFAULT_INDEX_NAME_OFFLINE = "Solr Offline";
    public static final String DEFAULT_INDEX_NAME_ONLINE = "Solr Online";
    public static final String POST_PROCESSOR = "search.solr.postProcessor";
    public static final String PROPERTY_SEARCH_EXCLUDE_VALUE_SOLR = "solr";
    protected static final int DEBUG_PADDING_RIGHT = 50;
    private static final Log LOG = CmsLog.getLog(CmsSolrIndex.class);
    private static final int ROWS_MAX = 50;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    SolrServer m_solr;
    private I_CmsSolrPostSearchProcessor m_postProcessor;

    public CmsSolrIndex() {
    }

    public CmsSolrIndex(String name) throws CmsIllegalArgumentException {
        super(name);
    }

    public static final String getType(CmsObject cms, String rootPath) {
        I_CmsSearchDocument doc;
        String type = null;
        CmsSolrIndex index = CmsSearchManager.getIndexSolr(cms, null);
        if (index != null && (doc = index.getDocument("path", rootPath)) != null) {
            type = doc.getFieldValueAsString("type");
        }
        return type;
    }

    @Override
    public void addConfigurationParameter(String key, String value) {
        if (POST_PROCESSOR.equals(key) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) {
            try {
                this.setPostProcessor((I_CmsSolrPostSearchProcessor)Class.forName(value).newInstance());
            }
            catch (Exception e) {
                CmsException ex = new CmsException(Messages.get().container("LOG_SOLR_ERR_POST_PROCESSOR_NOT_EXIST_1", value), (Throwable)e);
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        super.addConfigurationParameter(key, value);
    }

    @Override
    public I_CmsIndexWriter createIndexWriter(boolean create, I_CmsReport report) {
        return new CmsSolrIndexWriter(this.m_solr, this);
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = super.getConfiguration();
        if (this.getPostProcessor() != null) {
            result.put(POST_PROCESSOR, this.getPostProcessor().getClass().getName());
        }
        return result;
    }

    @Override
    public I_CmsSearchDocument getDocument(String fieldname, String term) {
        try {
            SolrDocumentList sdl;
            SolrQuery query = new SolrQuery();
            query.setQuery(fieldname + ":" + term);
            QueryResponse res = this.m_solr.query((SolrParams)query);
            if (res != null && (sdl = this.m_solr.query((SolrParams)query).getResults()).getNumFound() == 1L && sdl.get(0) != null) {
                return new CmsSolrDocument(ClientUtils.toSolrInputDocument((SolrDocument)((SolrDocument)sdl.get(0))));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public I_CmsDocumentFactory getDocumentFactory(CmsResource res) {
        if (res != null && this.getSources() != null) {
            if (CmsResourceTypeXmlContainerPage.isContainerPage(res)) {
                return OpenCms.getSearchManager().getDocumentFactory("containerpage-solr", "text/html");
            }
            if (CmsResourceTypeXmlContent.isXmlContent(res)) {
                return OpenCms.getSearchManager().getDocumentFactory("xmlcontent-solr", "text/html");
            }
            return super.getDocumentFactory(res);
        }
        return null;
    }

    @Override
    public Locale getLocaleForResource(CmsObject cms, CmsResource resource, List<Locale> availableLocales) {
        Locale result = null;
        List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        if (availableLocales != null && availableLocales.size() > 0) {
            result = OpenCms.getLocaleManager().getBestMatchingLocale(defaultLocales.get(0), defaultLocales, availableLocales);
        }
        if (result == null) {
            result = availableLocales != null && availableLocales.isEmpty() ? availableLocales.get(0) : defaultLocales.get(0);
        }
        return result;
    }

    public I_CmsSolrPostSearchProcessor getPostProcessor() {
        return this.m_postProcessor;
    }

    @Override
    public void initialize() throws CmsSearchException {
        super.initialize();
        try {
            this.m_solr = OpenCms.getSearchManager().registerSolrIndex(this);
        }
        catch (CmsConfigurationException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            this.setEnabled(false);
        }
    }

    @Override
    @Deprecated
    public CmsSearchResultList search(CmsObject cms, CmsSearchParameters params) {
        throw new UnsupportedOperationException();
    }

    public CmsSolrResultList search(CmsObject cms, CmsSolrQuery query) throws CmsSearchException {
        return this.search(cms, query, false);
    }

    public synchronized CmsSolrResultList search(CmsObject cms, CmsSolrQuery query, boolean ignoreMaxRows) throws CmsSearchException {
        int previousPriority = Thread.currentThread().getPriority();
        long startTime = System.currentTimeMillis();
        CmsSolrQuery initQuery = query.clone();
        query.setHighlight(false);
        try {
            int rows;
            CmsObject searchCms = OpenCms.initCmsObject(cms);
            if (this.getPriority() > 0) {
                Thread.currentThread().setPriority(this.getPriority());
            }
            List<CmsSearchResource> resourceDocumentList = new ArrayList<CmsSearchResource>();
            SolrDocumentList solrDocumentList = new SolrDocumentList();
            int n = rows = query.getRows() != null ? query.getRows().intValue() : CmsSolrQuery.DEFAULT_ROWS.intValue();
            if (!ignoreMaxRows && rows > 50) {
                rows = 50;
            }
            int start = query.getStart() != null ? query.getStart() : 0;
            int end = start + rows;
            int page = 0;
            if (rows > 0) {
                page = Math.round(start / rows) + 1;
            }
            query.setStart(new Integer(0));
            query.setRows(new Integer(5 * rows * page + start));
            QueryResponse queryResponse = this.m_solr.query((SolrParams)query);
            long solrTime = System.currentTimeMillis() - startTime;
            long hitCount = queryResponse.getResults().getNumFound();
            start = -1;
            end = -1;
            if (rows > 0 && page > 0 && hitCount > 0L) {
                start = rows * (page - 1);
                end = start + rows;
                start = new Long((long)start > hitCount ? hitCount : (long)start).intValue();
                end = new Long((long)end > hitCount ? hitCount : (long)end).intValue();
            } else {
                start = 0;
                end = new Long(hitCount).intValue();
            }
            long visibleHitCount = hitCount;
            float maxScore = 0.0f;
            ArrayList<CmsSearchResource> allDocs = new ArrayList<CmsSearchResource>();
            int cnt = 0;
            for (int i = 0; i < queryResponse.getResults().size() && cnt < end; ++i) {
                try {
                    SolrDocument doc = (SolrDocument)queryResponse.getResults().get(i);
                    CmsSolrDocument searchDoc = new CmsSolrDocument(doc);
                    if (!this.needsPermissionCheck(searchDoc)) continue;
                    CmsResource resource = this.getResource(searchCms, searchDoc);
                    if (resource != null) {
                        if (cnt >= start) {
                            if (this.m_postProcessor != null) {
                                doc = this.m_postProcessor.process(searchCms, resource, (SolrInputDocument)searchDoc.getDocument());
                            }
                            resourceDocumentList.add(new CmsSearchResource(resource, searchDoc));
                            solrDocumentList.add((Object)doc);
                            maxScore = maxScore < searchDoc.getScore() ? searchDoc.getScore() : maxScore;
                        }
                        allDocs.add(new CmsSearchResource(resource, searchDoc));
                        ++cnt;
                        continue;
                    }
                    --visibleHitCount;
                    continue;
                }
                catch (Exception e) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_SOLR_ERR_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                }
            }
            if (resourceDocumentList.isEmpty() && allDocs.size() > 0) {
                page = Math.round(allDocs.size() / rows) + 1;
                int showCount = allDocs.size() % rows;
                showCount = showCount == 0 ? rows : showCount;
                start = allDocs.size() - new Long(showCount).intValue();
                end = allDocs.size();
                if (allDocs.size() > start) {
                    resourceDocumentList = allDocs.subList(start, end);
                    for (CmsSearchResource r : resourceDocumentList) {
                        maxScore = maxScore < r.getDocument().getScore() ? r.getDocument().getScore() : maxScore;
                        solrDocumentList.add((Object)((CmsSolrDocument)r.getDocument()).getSolrDocument());
                    }
                }
            }
            long processTime = System.currentTimeMillis() - startTime - solrTime;
            SolrCore core = this.m_solr instanceof EmbeddedSolrServer ? ((EmbeddedSolrServer)this.m_solr).getCoreContainer().getCore(this.getName()) : null;
            CmsSolrResultList result = new CmsSolrResultList(core, initQuery, queryResponse, solrDocumentList, resourceDocumentList, start, new Integer(rows), end, page, visibleHitCount, new Float(maxScore), startTime);
            if (LOG.isDebugEnabled()) {
                Object[] logParams = new Object[]{new Long(System.currentTimeMillis() - startTime), new Long(result.getNumFound()), new Long(solrTime), new Long(processTime), new Long(result.getHighlightEndTime() != 0L ? result.getHighlightEndTime() - startTime : 0L)};
                LOG.debug((Object)(query.toString() + "\n" + Messages.get().getBundle().key("LOG_SOLR_SEARCH_EXECUTED_5", logParams)));
            }
            CmsSolrResultList cmsSolrResultList = result;
            return cmsSolrResultList;
        }
        catch (Exception e) {
            throw new CmsSearchException(Messages.get().container("LOG_SOLR_ERR_SEARCH_EXECUTION_FAILD_1", CmsEncoder.decode(query.toString())), (Throwable)e);
        }
        finally {
            Thread.currentThread().setPriority(previousPriority);
        }
    }

    public CmsSolrResultList search(CmsObject cms, SolrQuery query) throws CmsSearchException {
        return this.search(cms, CmsEncoder.decode(query.toString()));
    }

    public CmsSolrResultList search(CmsObject cms, String solrQuery) throws CmsSearchException {
        return this.search(cms, new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(solrQuery)), false);
    }

    public void setPostProcessor(I_CmsSolrPostSearchProcessor postProcessor) {
        this.m_postProcessor = postProcessor;
    }

    @Override
    public void shutDown() {
    }

    public void writeResponse(ServletResponse response, CmsSolrResultList result) throws Exception {
        if (this.m_solr instanceof EmbeddedSolrServer) {
            SolrCore core = ((EmbeddedSolrServer)this.m_solr).getCoreContainer().getCore(this.getName());
            SolrQueryRequest queryRequest = result.getSolrQueryRequest();
            SolrQueryResponse queryResponse = result.getSolrQueryResponse();
            QueryResponseWriter responseWriter = core.getQueryResponseWriter(queryRequest);
            String ct = responseWriter.getContentType(queryRequest, queryResponse);
            if (null != ct) {
                response.setContentType(ct);
            }
            if (responseWriter instanceof BinaryQueryResponseWriter) {
                BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
                binWriter.write((OutputStream)response.getOutputStream(), queryRequest, queryResponse);
            } else {
                String charset = ContentStreamBase.getCharsetFromContentType((String)ct);
                OutputStreamWriter out = charset == null || charset.equalsIgnoreCase(UTF8.toString()) ? new OutputStreamWriter((OutputStream)response.getOutputStream(), UTF8) : new OutputStreamWriter((OutputStream)response.getOutputStream(), charset);
                out = new FastWriter((Writer)out);
                responseWriter.write((Writer)out, queryRequest, queryResponse);
                ((Writer)out).flush();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected String createIndexBackup() {
        SolrRequestHandler h;
        EmbeddedSolrServer ser;
        CoreContainer con;
        SolrCore core;
        if (!this.isBackupReindexing()) {
            return null;
        }
        if (this.m_solr instanceof EmbeddedSolrServer && (core = (con = (ser = (EmbeddedSolrServer)this.m_solr).getCoreContainer()).getCore(this.getName())) != null && (h = core.getRequestHandler("/replication")) instanceof ReplicationHandler) {
            h.handleRequest((SolrQueryRequest)new LocalSolrQueryRequest(core, CmsRequestUtil.createParameterMap("?command=backup")), new SolrQueryResponse());
        }
        return null;
    }

    @Override
    protected boolean excludeFromIndex(CmsObject cms, CmsResource resource) {
        if (resource.isFolder() || resource.isTemporaryFile()) {
            return true;
        }
        boolean excludeFromIndex = false;
        try {
            String propValue = cms.readPropertyObject(resource, "search.exclude", true).getValue();
            excludeFromIndex = Boolean.valueOf(propValue);
            if (!excludeFromIndex && propValue != null) {
                excludeFromIndex = "all".equalsIgnoreCase(propValue.trim()) || PROPERTY_SEARCH_EXCLUDE_VALUE_SOLR.equalsIgnoreCase(propValue.trim());
            }
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        return excludeFromIndex;
    }

    @Override
    protected void indexSearcherClose() {
    }

    @Override
    protected void indexSearcherOpen(String path) {
    }

    @Override
    protected void indexSearcherUpdate() {
    }
}

