/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.Messages;

public class CmsSolrIndexWriter
implements I_CmsIndexWriter {
    protected static final Log LOG = CmsLog.getLog(CmsSolrIndexWriter.class);
    private CmsSolrIndex m_index;
    private SolrServer m_server;

    public CmsSolrIndexWriter(SolrServer server) {
        this(server, null);
    }

    public CmsSolrIndexWriter(SolrServer server, CmsSolrIndex index) {
        this.m_index = index;
        this.m_server = server;
        if (this.m_index != null) {
            this.m_index.createIndexBackup();
            LOG.info((Object)Messages.get().getBundle().key("LOG_SOLR_WRITER_CREATE_2", this.m_index.getName(), this.m_index.getPath()));
        }
    }

    public void close() {
    }

    public void commit() throws IOException {
        if (this.m_server != null && this.m_index != null) {
            try {
                LOG.info((Object)Messages.get().getBundle().key("LOG_SOLR_WRITER_COMMIT_2", this.m_index.getName(), this.m_index.getPath()));
                this.m_server.commit();
            }
            catch (SolrServerException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
    }

    public void deleteAllDocuments() throws IOException {
        if (this.m_server != null && this.m_index != null) {
            try {
                LOG.info((Object)Messages.get().getBundle().key("LOG_SOLR_WRITER_DELETE_ALL_2", this.m_index.getName(), this.m_index.getPath()));
                this.m_server.deleteByQuery("*:*");
            }
            catch (SolrServerException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
    }

    public void deleteDocuments(String rootPath) throws IOException {
        if (this.m_server != null && this.m_index != null) {
            try {
                LOG.info((Object)Messages.get().getBundle().key("LOG_SOLR_WRITER_DOC_DELETE_3", rootPath, this.m_index.getName(), this.m_index.getPath()));
                this.m_server.deleteByQuery("path:" + rootPath + "*");
            }
            catch (SolrServerException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
    }

    public void optimize() {
    }

    public void updateDocument(String rootPath, I_CmsSearchDocument document) throws IOException {
        if (this.m_server != null && this.m_index != null && document.getDocument() != null) {
            try {
                LOG.info((Object)Messages.get().getBundle().key("LOG_SOLR_WRITER_DOC_UPDATE_3", rootPath, this.m_index.getName(), this.m_index.getPath()));
                int commitMs = new Long(OpenCms.getSearchManager().getSolrServerConfiguration().getSolrCommitMs()).intValue();
                this.m_server.add((SolrInputDocument)document.getDocument(), commitMs);
            }
            catch (SolrServerException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
    }
}

