/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.Term;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.QParser;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchResource;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSolrResultList
extends ArrayList<CmsSearchResource> {
    private static final String HEADER_PARAMS_NAME = "params";
    private static final Log LOG = CmsLog.getLog(CmsSolrResultList.class);
    private static final String QUERY_RESPONSE_NAME = "response";
    private static final String QUERY_TIME_NAME = "QTime";
    private static final long serialVersionUID = 707475894827620542L;
    private int m_end;
    private long m_highlightEndTime;
    private int m_page;
    private SolrQuery m_query;
    private QueryResponse m_queryResponse;
    private SolrDocumentList m_resultDocuments = new SolrDocumentList();
    private Integer m_rows;
    private SolrQueryRequest m_solrQueryRequest;
    private SolrQueryResponse m_solrQueryResponse;
    private long m_startTime;
    private long m_visibleHitCount;

    public CmsSolrResultList(SolrCore core, SolrQuery query, QueryResponse queryResponse, SolrDocumentList resultDocuments, List<CmsSearchResource> resourceDocumentList, int start, Integer rows, int end, int page, long visibleHitCount, Float maxScore, long startTime) {
        super(resourceDocumentList);
        this.m_query = query;
        this.m_startTime = startTime;
        this.m_rows = rows;
        this.m_end = end;
        this.m_page = page;
        this.m_visibleHitCount = visibleHitCount;
        this.m_resultDocuments = resultDocuments;
        this.m_resultDocuments.setStart((long)start);
        this.m_resultDocuments.setMaxScore(maxScore);
        this.m_resultDocuments.setNumFound(this.m_visibleHitCount);
        this.m_queryResponse = queryResponse;
        this.m_queryResponse.getResponse().setVal(this.m_queryResponse.getResponse().indexOf(QUERY_RESPONSE_NAME, 0), (Object)this.m_resultDocuments);
        if (core != null) {
            this.initSolrReqRes(core);
        }
        this.m_queryResponse.getResponseHeader().setVal(this.m_queryResponse.getResponseHeader().indexOf(QUERY_TIME_NAME, 0), (Object)new Integer(new Long(System.currentTimeMillis() - this.m_startTime).intValue()));
    }

    public int getEnd() {
        return this.m_end;
    }

    public FacetField getFacetDate(String name) {
        return this.m_queryResponse.getFacetDate(name);
    }

    public List<FacetField> getFacetDates() {
        return this.m_queryResponse.getFacetDates();
    }

    public FacetField getFacetField(String name) {
        return this.m_queryResponse.getFacetField(name);
    }

    public List<FacetField> getFacetFields() {
        return this.m_queryResponse.getFacetFields();
    }

    public Map<String, Integer> getFacetQuery() {
        return this.m_queryResponse.getFacetQuery();
    }

    public List<RangeFacet> getFacetRanges() {
        return this.m_queryResponse.getFacetRanges();
    }

    public long getHighlightEndTime() {
        return this.m_highlightEndTime;
    }

    public List<FacetField> getLimitingFacets() {
        return this.m_queryResponse.getLimitingFacets();
    }

    public Float getMaxScore() {
        return this.m_resultDocuments.getMaxScore();
    }

    public long getNumFound() {
        return this.m_resultDocuments.getNumFound();
    }

    public int getPage() {
        return this.m_page;
    }

    public SolrQuery getQuery() {
        return this.m_query;
    }

    public Integer getRows() {
        return this.m_rows;
    }

    public Long getStart() {
        return new Long(this.m_resultDocuments.getStart());
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public long getVisibleHitCount() {
        return this.m_visibleHitCount;
    }

    protected SolrQueryRequest getSolrQueryRequest() {
        return this.m_solrQueryRequest;
    }

    protected SolrQueryResponse getSolrQueryResponse() {
        return this.m_solrQueryResponse;
    }

    private void initSolrReqRes(SolrCore core) {
        this.m_solrQueryResponse = new SolrQueryResponse();
        this.m_solrQueryResponse.setAllValues(this.m_queryResponse.getResponse());
        this.m_solrQueryResponse.setEndTime((long)this.m_queryResponse.getQTime());
        int paramsIndex = this.m_queryResponse.getResponseHeader().indexOf(HEADER_PARAMS_NAME, 0);
        NamedList header = null;
        Object o = this.m_queryResponse.getResponseHeader().getVal(paramsIndex);
        if (o instanceof NamedList) {
            header = (NamedList)o;
            header.setVal(header.indexOf("rows", 0), (Object)this.m_rows);
            header.setVal(header.indexOf("start", 0), (Object)this.getStart());
        }
        this.m_solrQueryRequest = new LocalSolrQueryRequest(core, this.m_queryResponse.getResponseHeader());
        this.m_solrQueryRequest.setParams((SolrParams)this.m_query);
        SearchComponent highlightComponenet = core.getSearchComponent("highlight");
        if (header != null && this.m_query.getHighlight() && highlightComponenet != null) {
            String formatter;
            header.add("hl", (Object)"on");
            if (this.m_query.getHighlightFields() != null && this.m_query.getHighlightFields().length > 0) {
                header.add("hl.fl", (Object)CmsStringUtil.arrayAsString(this.m_query.getHighlightFields(), ","));
            }
            String string = formatter = this.m_query.getParams("hl.formatter") != null ? this.m_query.getParams("hl.formatter")[0] : null;
            if (formatter != null) {
                header.add("hl.formatter", (Object)formatter);
            }
            if (this.m_query.getHighlightFragsize() != 100) {
                header.add("hl.fragsize", (Object)new Integer(this.m_query.getHighlightFragsize()));
            }
            if (this.m_query.getHighlightRequireFieldMatch()) {
                header.add("hl.requireFieldMatch", (Object)new Boolean(this.m_query.getHighlightRequireFieldMatch()));
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_query.getHighlightSimplePost())) {
                header.add("hl.simple.post", (Object)this.m_query.getHighlightSimplePost());
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_query.getHighlightSimplePre())) {
                header.add("hl.simple.pre", (Object)this.m_query.getHighlightSimplePre());
            }
            if (this.m_query.getHighlightSnippets() != 1) {
                header.add("hl.snippets", (Object)new Integer(this.m_query.getHighlightSnippets()));
            }
            ResponseBuilder rb = new ResponseBuilder(this.m_solrQueryRequest, this.m_solrQueryResponse, Collections.singletonList(highlightComponenet));
            try {
                rb.doHighlights = true;
                DocListAndSet res = new DocListAndSet();
                res.docList = this.solrDocumentListToDocList(this.m_resultDocuments);
                rb.setResults(res);
                rb.setQuery(QParser.getParser((String)this.getQuery().getQuery(), null, (SolrQueryRequest)this.m_solrQueryRequest).getQuery());
                rb.setQueryString(this.getQuery().getQuery());
                highlightComponenet.prepare(rb);
                highlightComponenet.process(rb);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            this.m_highlightEndTime = System.currentTimeMillis();
        }
    }

    private DocList solrDocumentListToDocList(SolrDocumentList list) throws IOException {
        SchemaField idField = OpenCms.getSearchManager().getSolrServerConfiguration().getSolrSchema().getUniqueKeyField();
        int[] luceneIds = new int[this.m_rows.intValue()];
        int docs = 0;
        for (SolrDocument doc : list) {
            String idString = (String)doc.getFirstValue("id");
            int id = this.m_solrQueryRequest.getSearcher().getFirstMatch(new Term(idField.getName(), idField.getType().toInternal(idString)));
            luceneIds[docs++] = id;
        }
        return new DocSlice(0, docs, luceneIds, null, docs, 0.0f);
    }
}

