/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.db.CmsCacheSettings;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsSecurityManager;
import org.opencms.db.I_CmsCacheKey;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPermissionHandler;
import org.opencms.security.Messages;

public class CmsDefaultPermissionHandler
implements I_CmsPermissionHandler {
    private static final Log LOG = CmsLog.getLog(CmsDefaultPermissionHandler.class);
    protected CmsDriverManager m_driverManager;
    protected CmsSecurityManager m_securityManager;
    private I_CmsCacheKey m_keyGenerator;

    public I_CmsPermissionHandler.CmsPermissionCheckResult hasPermissions(CmsDbContext dbc, CmsResource resource, CmsPermissionSet requiredPermissions, boolean checkLock, CmsResourceFilter filter) throws CmsException {
        I_CmsPermissionHandler.CmsPermissionCheckResult result;
        CmsLock lock;
        boolean writeRequired;
        if (!filter.isValid(dbc.getRequestContext(), resource)) {
            return I_CmsPermissionHandler.PERM_FILTERED;
        }
        String cacheKey = this.m_keyGenerator.getCacheKeyForUserPermissions(filter.requireVisible() && checkLock ? "11" : (!filter.requireVisible() && checkLock ? "01" : (filter.requireVisible() && !checkLock ? "10" : "00")), dbc, resource, requiredPermissions);
        I_CmsPermissionHandler.CmsPermissionCheckResult cacheResult = OpenCms.getMemoryMonitor().getCachedPermission(cacheKey);
        if (cacheResult != null) {
            return cacheResult;
        }
        int denied = 0;
        if (dbc.currentProject().isOnlineProject()) {
            denied |= 2;
        }
        boolean canIgnorePermissions = this.m_securityManager.hasRoleForResource(dbc, dbc.currentUser(), CmsRole.VFS_MANAGER, resource);
        boolean bl = writeRequired = requiredPermissions.requiresWritePermission() || requiredPermissions.requiresControlPermission();
        if (writeRequired && !canIgnorePermissions && CmsResourceTypeJsp.isJsp(resource) && !this.m_securityManager.hasRoleForResource(dbc, dbc.currentUser(), CmsRole.DEVELOPER, resource)) {
            denied |= 2;
            denied |= 8;
        }
        if (writeRequired && checkLock && ((lock = this.m_driverManager.getLock(dbc, resource)).isUnlocked() || !lock.isLockableBy(dbc.currentUser()))) {
            return I_CmsPermissionHandler.PERM_NOTLOCKED;
        }
        CmsPermissionSetCustom permissions = canIgnorePermissions ? new CmsPermissionSetCustom(-1) : this.m_driverManager.getPermissions(dbc, resource, dbc.currentUser());
        permissions.denyPermissions(denied);
        if ((permissions.getPermissions() & 4) == 0) {
            if (!canIgnorePermissions && filter.requireVisible()) {
                requiredPermissions = new CmsPermissionSet(requiredPermissions.getAllowedPermissions() | 4, requiredPermissions.getDeniedPermissions());
            } else {
                permissions.setPermissions(permissions.getAllowedPermissions() | 4, permissions.getDeniedPermissions() & 0xFFFFFFFB);
            }
        }
        if (requiredPermissions.requiresDirectPublishPermission() && (permissions.getPermissions() & 0x10) == 0) {
            boolean canIgnorePublishPermission = this.m_securityManager.hasRoleForResource(dbc, dbc.currentUser(), CmsRole.PROJECT_MANAGER, resource);
            if (!canIgnorePublishPermission) {
                CmsUser user = dbc.currentUser();
                for (CmsProject project : this.m_driverManager.getAllManageableProjects(dbc, this.m_driverManager.readOrganizationalUnit(dbc, user.getOuFqn()), true)) {
                    if (!CmsProject.isInsideProject(this.m_driverManager.readProjectResources(dbc, project), resource)) continue;
                    canIgnorePublishPermission = true;
                    break;
                }
            }
            if (canIgnorePublishPermission) {
                permissions.setPermissions(permissions.getAllowedPermissions() | 0x10, permissions.getDeniedPermissions() & 0xFFFFFFEF);
            }
        }
        if ((requiredPermissions.getPermissions() & permissions.getPermissions()) == requiredPermissions.getPermissions()) {
            result = I_CmsPermissionHandler.PERM_ALLOWED;
        } else {
            result = I_CmsPermissionHandler.PERM_DENIED;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_NO_PERMISSION_RESOURCE_USER_4", new Object[]{dbc.getRequestContext().removeSiteRoot(resource.getRootPath()), dbc.currentUser().getName(), requiredPermissions.getPermissionString(), permissions.getPermissionString()}));
            }
        }
        if (dbc.getProjectId().isNullUUID()) {
            OpenCms.getMemoryMonitor().cachePermission(cacheKey, result);
        }
        return result;
    }

    public void init(CmsDriverManager driverManager, CmsSystemConfiguration systemConfiguration) {
        this.m_driverManager = driverManager;
        this.m_securityManager = driverManager.getSecurityManager();
        CmsCacheSettings settings = systemConfiguration.getCacheSettings();
        String className = settings.getCacheKeyGenerator();
        try {
            this.m_keyGenerator = (I_CmsCacheKey)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new CmsInitException(org.opencms.main.Messages.get().container("ERR_CRITICAL_CLASS_CREATION_1", className), (Throwable)e);
        }
    }
}

