/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site.xmlsitemap;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.opencms.i18n.CmsEncoder;

public class CmsXmlSitemapUrlBean {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private String m_changeFrequency;
    private Date m_lastModified;
    private double m_priority;
    private String m_url;

    public CmsXmlSitemapUrlBean(String url, long lastModified, String changeFrequency, double priority) {
        this.m_url = url;
        if (lastModified >= 0L) {
            this.m_lastModified = new Date(lastModified);
        }
        this.m_changeFrequency = changeFrequency;
        this.m_priority = priority;
    }

    private static String formatDate(Date date) {
        String dateStr = dateFormat.format(date);
        return dateStr.substring(0, 22) + ":" + dateStr.substring(22);
    }

    public String getChangeFrequency() {
        return this.m_changeFrequency;
    }

    public Date getDateLastModified() {
        return this.m_lastModified;
    }

    public String getFormattedDate() {
        return CmsXmlSitemapUrlBean.formatDate(this.m_lastModified);
    }

    public double getPriority() {
        return this.m_priority;
    }

    public String getUrl() {
        return this.m_url;
    }

    public String renderXml() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<url>");
        this.writeElement(buffer, "loc", this.getUrl());
        if (this.m_lastModified != null) {
            this.writeElement(buffer, "lastmod", this.getFormattedDate());
        }
        if (this.m_changeFrequency != null) {
            this.writeElement(buffer, "changefreq", this.getChangeFrequency());
        }
        if (this.m_priority >= 0.0 && this.m_priority <= 1.0) {
            this.writeElement(buffer, "priority", "" + this.getPriority());
        }
        buffer.append("</url>");
        return buffer.toString();
    }

    private void writeElement(StringBuffer buffer, String tag, String content) {
        buffer.append("<" + tag + ">");
        buffer.append(CmsEncoder.escapeXml(content));
        buffer.append("</" + tag + ">");
    }
}

