/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsAfterPublishStaticExportHandler;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.staticexport.CmsStaticExportRfsRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsAfterPublishMultiLanguageStaticExportHandler
extends CmsAfterPublishStaticExportHandler {
    private static List<CmsStaticExportRfsRule> m_rules;

    @Override
    protected List<File> getRelatedFilesToPurge(String exportFileName, String vfsName) {
        CmsStaticExportManager manager = OpenCms.getStaticExportManager();
        ArrayList<File> result = new ArrayList<File>();
        if (m_rules == null) {
            CmsLocaleManager locManager = OpenCms.getLocaleManager();
            m_rules = new ArrayList<CmsStaticExportRfsRule>();
            for (CmsStaticExportRfsRule rule : manager.getRfsRules()) {
                Locale locale = CmsLocaleManager.getLocale(rule.getName());
                if (!locManager.getDefaultLocales().contains(locale)) continue;
                m_rules.add(rule);
            }
        }
        for (CmsStaticExportRfsRule rule : m_rules) {
            result.add(new File(rule.getLocalizedRfsName(exportFileName, File.separator)));
        }
        return result;
    }
}

