/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsHtmlConverter;
import org.opencms.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsHtmlConverter {
    public static final String PARAM_DISABLED = CmsStringUtil.FALSE;
    public static final String PARAM_ENABLED = CmsStringUtil.TRUE;
    public static final String PARAM_REPLACE_PARAGRAPHS = "replace-paragraphs";
    public static final String PARAM_WORD = "cleanup";
    public static final String PARAM_XHTML = "xhtml";
    public static final char SEPARATOR_MODES = ';';
    private static final Log LOG = CmsLog.getLog(CmsHtmlConverter.class);
    private String m_encoding;
    private String m_mode;

    public CmsHtmlConverter() {
        this.init("UTF-8", PARAM_ENABLED);
    }

    public CmsHtmlConverter(String encoding, String mode) {
        this.init(encoding, mode);
    }

    public static String getConversionSettings(CmsObject cms, CmsResource resource) {
        String contentConversion;
        try {
            String resourceName = cms.getSitePath(resource);
            CmsProperty contentConversionProperty = cms.readPropertyObject(resourceName, "content-conversion", true);
            contentConversion = contentConversionProperty.getValue(PARAM_DISABLED);
        }
        catch (CmsException e) {
            contentConversion = PARAM_DISABLED;
        }
        return contentConversion;
    }

    public static boolean isConversionEnabled(String conversionMode) {
        boolean value = true;
        if (conversionMode == null || conversionMode.indexOf(PARAM_DISABLED) != -1) {
            value = false;
        }
        return value;
    }

    public byte[] convertToByte(byte[] htmlInput) throws UnsupportedEncodingException {
        return this.convertToByte(new String(htmlInput, this.getEncoding()));
    }

    public byte[] convertToByte(String htmlInput) throws UnsupportedEncodingException {
        return this.convertToString(htmlInput).getBytes(this.getEncoding());
    }

    public byte[] convertToByteSilent(byte[] htmlInput) {
        try {
            return this.convertToByte(htmlInput);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e);
            }
            return htmlInput;
        }
    }

    public byte[] convertToByteSilent(String htmlInput) {
        try {
            return this.convertToByte(htmlInput.getBytes(this.getEncoding()));
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e);
            }
            try {
                return htmlInput.getBytes(this.getEncoding());
            }
            catch (UnsupportedEncodingException e1) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e1);
                }
                return htmlInput.getBytes();
            }
        }
    }

    public String convertToString(byte[] htmlInput) throws UnsupportedEncodingException {
        return this.convertToString(new String(htmlInput, this.getEncoding()));
    }

    public String convertToString(String htmlInput) throws UnsupportedEncodingException {
        ArrayList<String> modes;
        HashMap<String, ArrayList<String>> converters = new HashMap<String, ArrayList<String>>();
        for (String string : this.getModes()) {
            String converterClass = OpenCms.getResourceManager().getHtmlConverter(string);
            modes = new ArrayList<String>();
            if (converters.containsKey(converterClass)) {
                modes = (List)converters.get(converterClass);
            }
            modes.add(string);
            converters.put(converterClass, modes);
        }
        for (Map.Entry entry : converters.entrySet()) {
            String className = (String)entry.getKey();
            modes = (List)entry.getValue();
            try {
                I_CmsHtmlConverter converter = (I_CmsHtmlConverter)Class.forName(className).newInstance();
                converter.init(this.getEncoding(), modes);
                htmlInput = converter.convertToString(htmlInput);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)org.opencms.loader.Messages.get().getBundle().key("LOG_HTML_CONVERTER_CLASS_NOT_FOUND_1", className), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)org.opencms.loader.Messages.get().getBundle().key("LOG_HTML_CONVERTER_CLASS_NOT_FOUND_1", className), (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error((Object)org.opencms.loader.Messages.get().getBundle().key("LOG_HTML_CONVERTER_CLASS_NOT_FOUND_1", className), (Throwable)e);
            }
        }
        return htmlInput;
    }

    public String convertToStringSilent(byte[] htmlInput) {
        try {
            return this.convertToString(htmlInput);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e);
            }
            try {
                return new String(htmlInput, this.getEncoding());
            }
            catch (UnsupportedEncodingException e1) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e1);
                }
                return new String(htmlInput);
            }
        }
    }

    public String convertToStringSilent(String htmlInput) {
        try {
            return this.convertToString(htmlInput);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e);
            }
            return htmlInput;
        }
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public String getMode() {
        return this.m_mode;
    }

    private List<String> getModes() {
        List<String> modes = new ArrayList<String>();
        try {
            modes = CmsStringUtil.splitAsList(this.getMode(), ';', true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modes;
    }

    private void init(String encoding, String mode) {
        this.m_encoding = encoding == null ? "UTF-8" : encoding;
        this.m_mode = CmsStringUtil.isEmptyOrWhitespaceOnly(mode) ? "" : mode;
    }
}

