/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Page;
import org.htmlparser.scanners.Scanner;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.htmlparser.visitors.NodeVisitor;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public final class CmsHtmlTagRemoveFactory
extends PrototypicalNodeFactory {
    private static final Log LOG = CmsLog.getLog(CmsHtmlTagRemoveFactory.class);
    private static final long serialVersionUID = 6961158563666656633L;
    private Set<String> m_invisibleTags = new TreeSet<String>();
    private Set<String> m_visibleTags = new TreeSet<String>();

    public boolean addTagPreserve(Tag tag) {
        boolean result = false;
        String tagName = tag.getTagName();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(tagName)) {
            result = this.m_visibleTags.add(tagName.toLowerCase());
        }
        return result;
    }

    public boolean addTagRemoval(Tag tag) {
        boolean result = false;
        String tagName = tag.getTagName();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(tagName)) {
            result = this.m_invisibleTags.add(tagName.toLowerCase());
        }
        return result;
    }

    public Tag createTagNode(Page arg0, int arg1, int arg2, Vector arg3) {
        try {
            String tagName = ((Attribute)arg3.get(0)).getName().toLowerCase();
            if (tagName.charAt(0) == '/') {
                tagName = tagName.substring(1);
            }
            Tag result = super.createTagNode(arg0, arg1, arg2, arg3);
            if (!this.keepTag(tagName)) {
                result = new CmsInvisibleTag(result);
            }
            return result;
        }
        catch (RuntimeException rte) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)rte);
            }
            throw rte;
        }
    }

    private boolean keepTag(String tagName) {
        boolean result = false;
        if (this.m_visibleTags.size() > 0) {
            result = this.m_visibleTags.contains(tagName);
        }
        if (this.m_invisibleTags.contains(tagName)) {
            result = false;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CmsInvisibleTag
    implements Tag {
        private Tag m_decorated;

        CmsInvisibleTag(Tag delegate) {
            this.m_decorated = delegate;
        }

        public void accept(NodeVisitor visitor) {
            NodeList children = this.m_decorated.getChildren();
            if (children == null) {
                return;
            }
            SimpleNodeIterator itChildren = children.elements();
            while (itChildren.hasMoreNodes()) {
                itChildren.nextNode().accept(visitor);
            }
        }

        public boolean breaksFlow() {
            return this.m_decorated.breaksFlow();
        }

        public Object clone() throws CloneNotSupportedException {
            return this.m_decorated.clone();
        }

        public void collectInto(NodeList arg0, NodeFilter arg1) {
            this.m_decorated.collectInto(arg0, arg1);
        }

        public void doSemanticAction() throws ParserException {
            this.m_decorated.doSemanticAction();
        }

        public String getAttribute(String arg0) {
            return this.m_decorated.getAttribute(arg0);
        }

        public Attribute getAttributeEx(String arg0) {
            return this.m_decorated.getAttributeEx(arg0);
        }

        public Vector<Attribute> getAttributesEx() {
            return this.m_decorated.getAttributesEx();
        }

        public NodeList getChildren() {
            return this.m_decorated.getChildren();
        }

        public String[] getEnders() {
            return this.m_decorated.getEnders();
        }

        public int getEndingLineNumber() {
            return this.m_decorated.getEndingLineNumber();
        }

        public int getEndPosition() {
            return this.m_decorated.getEndPosition();
        }

        public Tag getEndTag() {
            return this.m_decorated.getEndTag();
        }

        public String[] getEndTagEnders() {
            return this.m_decorated.getEndTagEnders();
        }

        public Node getFirstChild() {
            return this.m_decorated.getFirstChild();
        }

        public String[] getIds() {
            return this.m_decorated.getIds();
        }

        public Node getLastChild() {
            return this.m_decorated.getLastChild();
        }

        public Node getNextSibling() {
            return this.m_decorated.getNextSibling();
        }

        public Page getPage() {
            return this.m_decorated.getPage();
        }

        public Node getParent() {
            return this.m_decorated.getParent();
        }

        public Node getPreviousSibling() {
            return this.m_decorated.getPreviousSibling();
        }

        public String getRawTagName() {
            return this.m_decorated.getRawTagName();
        }

        public int getStartingLineNumber() {
            return this.m_decorated.getStartingLineNumber();
        }

        public int getStartPosition() {
            return this.m_decorated.getStartPosition();
        }

        public String getTagName() {
            return this.m_decorated.getTagName();
        }

        public String getText() {
            return this.m_decorated.getText();
        }

        public Scanner getThisScanner() {
            return this.m_decorated.getThisScanner();
        }

        public boolean isEmptyXmlTag() {
            return this.m_decorated.isEmptyXmlTag();
        }

        public boolean isEndTag() {
            return this.m_decorated.isEndTag();
        }

        public void removeAttribute(String arg0) {
            this.m_decorated.removeAttribute(arg0);
        }

        public void setAttribute(String arg0, String arg1) {
            this.m_decorated.setAttribute(arg0, arg1);
        }

        public void setAttribute(String arg0, String arg1, char arg2) {
            this.m_decorated.setAttribute(arg0, arg1, arg2);
        }

        public void setAttributeEx(Attribute arg0) {
            this.m_decorated.setAttributeEx(arg0);
        }

        public void setAttributesEx(Vector arg0) {
            this.m_decorated.setAttributesEx(arg0);
        }

        public void setChildren(NodeList arg0) {
            this.m_decorated.setChildren(arg0);
        }

        public void setEmptyXmlTag(boolean arg0) {
            this.m_decorated.setEmptyXmlTag(arg0);
        }

        public void setEndPosition(int arg0) {
            this.m_decorated.setEndPosition(arg0);
        }

        public void setEndTag(Tag arg0) {
            this.m_decorated.setEndTag(arg0);
        }

        public void setPage(Page arg0) {
            this.m_decorated.setPage(arg0);
        }

        public void setParent(Node arg0) {
            this.m_decorated.setParent(arg0);
        }

        public void setStartPosition(int arg0) {
            this.m_decorated.setStartPosition(arg0);
        }

        public void setTagName(String arg0) {
            this.m_decorated.setTagName(arg0);
        }

        public void setText(String arg0) {
            this.m_decorated.setText(arg0);
        }

        public void setThisScanner(Scanner arg0) {
            this.m_decorated.setThisScanner(arg0);
        }

        public String toHtml() {
            return this.m_decorated.toHtml();
        }

        public String toHtml(boolean value) {
            return this.m_decorated.toHtml(value);
        }

        public String toPlainTextString() {
            return this.m_decorated.toPlainTextString();
        }

        public String toString() {
            return this.m_decorated.toString();
        }
    }
}

