/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.collections.Factory;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsMacroResolver;
import org.opencms.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsMacroResolver
implements I_CmsMacroResolver {
    public static final String KEY_ATTRIBUTE = "attribute.";
    public static final String KEY_CONTEXT_PATH = "contextPath";
    public static final String KEY_CURRENT_ORGUNIT_DESCRIPTION = "currentou.description";
    public static final String KEY_CURRENT_ORGUNIT_FQN = "currentou.fqn";
    public static final String KEY_CURRENT_TIME = "currenttime";
    public static final String KEY_CURRENT_USER_CITY = "currentuser.city";
    public static final String KEY_CURRENT_USER_COUNTRY = "currentuser.country";
    public static final String KEY_CURRENT_USER_DISPLAYNAME = "currentuser.displayname";
    public static final String KEY_CURRENT_USER_EMAIL = "currentuser.email";
    public static final String KEY_CURRENT_USER_FIRSTNAME = "currentuser.firstname";
    public static final String KEY_CURRENT_USER_FULLNAME = "currentuser.fullname";
    public static final String KEY_CURRENT_USER_INSTITUTION = "currentuser.institution";
    public static final String KEY_CURRENT_USER_LASTLOGIN = "currentuser.lastlogin";
    public static final String KEY_CURRENT_USER_LASTNAME = "currentuser.lastname";
    public static final String KEY_CURRENT_USER_NAME = "currentuser.name";
    public static final String KEY_CURRENT_USER_STREET = "currentuser.street";
    public static final String KEY_CURRENT_USER_ZIP = "currentuser.zip";
    public static final String KEY_LOCALIZED_PREFIX = "key.";
    public static final String KEY_OPENCMS = "opencms.";
    public static final String KEY_PAGE_CONTEXT = "pageContext.";
    public static final String KEY_PROJECT_ID = "projectid";
    public static final String KEY_PROPERTY = "property.";
    public static final String KEY_PROPERTY_ELEMENT = "elementProperty.";
    public static final String KEY_REQUEST_ENCODING = "request.encoding";
    public static final String KEY_REQUEST_FOLDER = "request.folder";
    public static final String KEY_REQUEST_LOCALE = "request.locale";
    public static final String KEY_REQUEST_PARAM = "param.";
    public static final String KEY_REQUEST_SITEROOT = "request.siteroot";
    public static final String KEY_REQUEST_URI = "request.uri";
    public static final String KEY_VALIDATION_PATH = "validation.path";
    public static final String KEY_VALIDATION_REGEX = "validation.regex";
    public static final String KEY_VALIDATION_VALUE = "validation.value";
    static final String[] VALUE_NAMES_ARRAY = new String[]{"uri", "filename", "folder", "default.encoding", "remoteaddress", "webapp", "webbasepath", "version"};
    public static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList(VALUE_NAMES_ARRAY));
    private static final Log LOG = CmsLog.getLog(CmsMacroResolver.class);
    protected Map<String, String> m_additionalMacros;
    protected CmsObject m_cms;
    protected PageContext m_jspPageContext;
    protected boolean m_keepEmptyMacros;
    protected CmsMessages m_messages;
    protected String m_resourceName;
    private Map<String, Factory> m_factories;

    public static String formatMacro(String input) {
        StringBuffer result = new StringBuffer(input.length() + 4);
        result.append('%');
        result.append('(');
        result.append(input);
        result.append(')');
        return result.toString();
    }

    public static boolean isMacro(String input) {
        if (CmsStringUtil.isEmpty(input) || input.length() < 3) {
            return false;
        }
        return input.charAt(0) == '$' && input.charAt(1) == '{' && input.charAt(input.length() - 1) == '}' || input.charAt(0) == '%' && input.charAt(1) == '(' && input.charAt(input.length() - 1) == ')';
    }

    public static boolean isMacro(String input, String macroName) {
        if (CmsMacroResolver.isMacro(input)) {
            return input.substring(2, input.length() - 1).equals(macroName);
        }
        return false;
    }

    public static String localizedKeyMacro(String keyName, Object[] params) {
        String parameters = "";
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                parameters = parameters + "|" + params[i].toString();
            }
        }
        return "%(key." + keyName + parameters + ')';
    }

    public static CmsMacroResolver newInstance() {
        return new CmsMacroResolver();
    }

    public static String resolveMacros(String input, CmsObject cms, CmsMessages messages) {
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.m_cms = cms;
        resolver.m_messages = messages;
        resolver.m_keepEmptyMacros = true;
        return resolver.resolveMacros(input);
    }

    public static String resolveMacros(String input, I_CmsMacroResolver resolver) {
        int np;
        int de;
        int ds;
        int p;
        if (input == null || input.length() < 3) {
            return input;
        }
        int pn = input.indexOf(37);
        int po = input.indexOf(36);
        if (po == -1 && pn == -1) {
            return input;
        }
        int len = input.length();
        StringBuffer result = new StringBuffer(len << 1);
        boolean keep = resolver.isKeepEmptyMacros();
        boolean resolvedNone = true;
        if (po == -1 || pn > -1 && pn < po) {
            p = pn;
            ds = 40;
            de = 41;
        } else {
            p = po;
            ds = 123;
            de = 125;
        }
        result.append(input.substring(0, p));
        do {
            int e;
            int pp1;
            int pp2;
            if ((pp2 = (pp1 = p + 1) + 1) >= len) {
                result.append(input.substring(p, len));
                break;
            }
            if (pn > -1 && pn < pp1) {
                pn = input.indexOf(37, pp1);
            }
            if (po > -1 && po < pp1) {
                po = input.indexOf(36, pp1);
            }
            np = po == -1 && pn == -1 ? len : (po == -1 || pn > -1 && pn < po ? pn : po);
            int st = input.charAt(pp1);
            if (st == ds) {
                e = input.indexOf(de, p);
                if (e > 0 && e < np) {
                    String macro = input.substring(pp2, e);
                    String value = resolver.getMacroValue(macro);
                    ++e;
                    if (value != null) {
                        result.append(value);
                        resolvedNone = false;
                    } else if (keep) {
                        result.append(input.substring(p, e));
                    }
                } else {
                    e = p;
                }
            } else {
                e = p;
            }
            if (np == pn) {
                ds = 40;
                de = 41;
            } else {
                ds = 123;
                de = 125;
            }
            result.append(input.substring(e, np));
        } while ((p = np) < len);
        if (resolvedNone && keep) {
            return input;
        }
        return result.toString();
    }

    public static String stripMacro(String input) {
        if (CmsMacroResolver.isMacro(input)) {
            return input.substring(2, input.length() - 1);
        }
        return null;
    }

    public void addDynamicMacro(String name, Factory factory) {
        if (this.m_factories == null) {
            this.m_factories = new HashMap<String, Factory>();
        }
        this.m_factories.put(name, factory);
    }

    public void addMacro(String key, String value) {
        if (this.m_additionalMacros == null) {
            this.m_additionalMacros = new HashMap<String, String>();
        }
        this.m_additionalMacros.put(key, value);
    }

    @Override
    public String getMacroValue(String macro) {
        Factory factory;
        if (this.m_messages != null && macro.startsWith(KEY_LOCALIZED_PREFIX)) {
            String keyName = macro.substring(KEY_LOCALIZED_PREFIX.length());
            return this.m_messages.keyWithParams(keyName);
        }
        if (this.m_factories != null && (factory = this.m_factories.get(macro)) != null) {
            String value = (String)factory.create();
            return value;
        }
        if (this.m_jspPageContext != null) {
            block64: {
                if (this.m_jspPageContext.getRequest() != null) {
                    if (macro.startsWith(KEY_REQUEST_PARAM)) {
                        macro = macro.substring(KEY_REQUEST_PARAM.length());
                        String result = this.m_jspPageContext.getRequest().getParameter(macro);
                        if (result == null && macro.equals(KEY_PROJECT_ID)) {
                            result = this.m_cms.getRequestContext().getCurrentProject().getUuid().toString();
                        }
                        return result;
                    }
                    if (this.m_cms != null && macro.startsWith(KEY_PROPERTY_ELEMENT)) {
                        macro = macro.substring(KEY_PROPERTY_ELEMENT.length());
                        CmsFlexController controller = CmsFlexController.getController(this.m_jspPageContext.getRequest());
                        try {
                            CmsProperty property = this.m_cms.readPropertyObject(controller.getCurrentRequest().getElementUri(), macro, false);
                            if (property != CmsProperty.getNullProperty()) {
                                return property.getValue();
                            }
                        }
                        catch (CmsException e) {
                            if (!LOG.isWarnEnabled()) break block64;
                            LOG.warn((Object)Messages.get().getBundle().key("LOG_PROPERTY_READING_FAILED_2", macro, controller.getCurrentRequest().getElementUri()), (Throwable)e);
                        }
                    }
                }
            }
            if (macro.startsWith(KEY_PAGE_CONTEXT)) {
                macro = macro.substring(KEY_PAGE_CONTEXT.length());
                int scope = this.m_jspPageContext.getAttributesScope(macro);
                return this.m_jspPageContext.getAttribute(macro, scope).toString();
            }
        }
        if (this.m_cms != null) {
            if (macro.startsWith(KEY_PROPERTY)) {
                block65: {
                    macro = macro.substring(KEY_PROPERTY.length());
                    try {
                        CmsProperty property = this.m_cms.readPropertyObject(this.m_cms.getRequestContext().getUri(), macro, true);
                        if (property != CmsProperty.getNullProperty()) {
                            return property.getValue();
                        }
                    }
                    catch (CmsException e) {
                        if (!LOG.isWarnEnabled()) break block65;
                        CmsMessageContainer message = Messages.get().container("LOG_PROPERTY_READING_FAILED_2", macro, this.m_cms.getRequestContext().getUri());
                        LOG.warn((Object)message.key(), (Throwable)e);
                    }
                }
                return null;
            }
            if (macro.startsWith(KEY_ATTRIBUTE)) {
                macro = macro.substring(KEY_ATTRIBUTE.length());
                Object attribute = this.m_cms.getRequestContext().getAttribute(macro);
                if (attribute != null) {
                    return attribute.toString();
                }
                return null;
            }
            if (macro.startsWith(KEY_OPENCMS)) {
                String originalKey = macro;
                macro = macro.substring(KEY_OPENCMS.length());
                int index = VALUE_NAMES.indexOf(macro);
                String value = null;
                switch (index) {
                    case 0: {
                        value = this.m_cms.getRequestContext().getUri();
                        break;
                    }
                    case 1: {
                        value = this.m_resourceName;
                        break;
                    }
                    case 2: {
                        value = this.m_cms.getRequestContext().getFolderUri();
                        break;
                    }
                    case 3: {
                        value = OpenCms.getSystemInfo().getDefaultEncoding();
                        break;
                    }
                    case 4: {
                        value = this.m_cms.getRequestContext().getRemoteAddress();
                        break;
                    }
                    case 5: {
                        value = OpenCms.getSystemInfo().getWebApplicationName();
                        break;
                    }
                    case 6: {
                        value = OpenCms.getSystemInfo().getWebApplicationRfsPath();
                        break;
                    }
                    case 7: {
                        value = OpenCms.getSystemInfo().getVersionNumber();
                        break;
                    }
                    default: {
                        value = originalKey;
                    }
                }
                return value;
            }
            if (KEY_CURRENT_USER_NAME.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getName();
            }
            if (KEY_CURRENT_USER_FIRSTNAME.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getFirstname();
            }
            if (KEY_CURRENT_USER_LASTNAME.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getLastname();
            }
            if (KEY_CURRENT_USER_DISPLAYNAME.equals(macro)) {
                try {
                    if (this.m_messages != null) {
                        return this.m_cms.getRequestContext().getCurrentUser().getDisplayName(this.m_cms, this.m_messages.getLocale());
                    }
                    return this.m_cms.getRequestContext().getCurrentUser().getDisplayName(this.m_cms, this.m_cms.getRequestContext().getLocale());
                }
                catch (CmsException e) {
                    // empty catch block
                }
            }
            if (KEY_CURRENT_ORGUNIT_FQN.equals(macro)) {
                return this.m_cms.getRequestContext().getOuFqn();
            }
            if (KEY_CURRENT_ORGUNIT_DESCRIPTION.equals(macro)) {
                try {
                    CmsOrganizationalUnit ou = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, this.m_cms.getRequestContext().getOuFqn());
                    if (this.m_messages != null) {
                        return ou.getDescription(this.m_messages.getLocale());
                    }
                    return ou.getDescription(this.m_cms.getRequestContext().getLocale());
                }
                catch (CmsException e) {
                    // empty catch block
                }
            }
            if (KEY_CURRENT_USER_FULLNAME.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getFullName();
            }
            if (KEY_CURRENT_USER_EMAIL.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getEmail();
            }
            if (KEY_CURRENT_USER_STREET.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getAddress();
            }
            if (KEY_CURRENT_USER_ZIP.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getZipcode();
            }
            if (KEY_CURRENT_USER_COUNTRY.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getCountry();
            }
            if (KEY_CURRENT_USER_CITY.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getCity();
            }
            if (KEY_CURRENT_USER_LASTLOGIN.equals(macro) && this.m_messages != null) {
                return this.m_messages.getDateTime(this.m_cms.getRequestContext().getCurrentUser().getLastlogin());
            }
            if (KEY_REQUEST_SITEROOT.equals(macro)) {
                return this.m_cms.getRequestContext().getSiteRoot();
            }
            if (KEY_REQUEST_URI.equals(macro)) {
                return this.m_cms.getRequestContext().getUri();
            }
            if (KEY_REQUEST_FOLDER.equals(macro)) {
                return CmsResource.getParentFolder(this.m_cms.getRequestContext().getUri());
            }
            if (KEY_REQUEST_ENCODING.equals(macro)) {
                return this.m_cms.getRequestContext().getEncoding();
            }
            if (KEY_REQUEST_LOCALE.equals(macro)) {
                return this.m_cms.getRequestContext().getLocale().toString();
            }
            if (KEY_CONTEXT_PATH.equals(macro)) {
                return OpenCms.getSystemInfo().getContextPath();
            }
            if (KEY_CURRENT_USER_INSTITUTION.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getInstitution();
            }
        }
        if (KEY_CURRENT_TIME.equals(macro)) {
            return String.valueOf(System.currentTimeMillis());
        }
        if (macro.startsWith(KEY_CURRENT_TIME)) {
            macro = macro.substring(KEY_CURRENT_TIME.length()).trim();
            char operator = macro.charAt(0);
            macro = macro.substring(1).trim();
            long delta = 0L;
            try {
                delta = Long.parseLong(macro);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            long resultTime = System.currentTimeMillis();
            switch (operator) {
                case '+': {
                    resultTime += delta;
                    break;
                }
                case '-': {
                    resultTime -= delta;
                    break;
                }
            }
            return String.valueOf(resultTime);
        }
        if (this.m_additionalMacros != null) {
            return this.m_additionalMacros.get(macro);
        }
        return null;
    }

    @Override
    public boolean isKeepEmptyMacros() {
        return this.m_keepEmptyMacros;
    }

    @Override
    public String resolveMacros(String input) {
        String result = input;
        if (input != null) {
            String lastResult;
            do {
                lastResult = result;
            } while (!(result = CmsMacroResolver.resolveMacros(result, this)).equals(lastResult));
        }
        return result;
    }

    public CmsMacroResolver setAdditionalMacros(Map<String, String> additionalMacros) {
        this.m_additionalMacros = additionalMacros;
        return this;
    }

    public CmsMacroResolver setCmsObject(CmsObject cms) {
        this.m_cms = cms;
        return this;
    }

    public CmsMacroResolver setJspPageContext(PageContext jspPageContext) {
        this.m_jspPageContext = jspPageContext;
        return this;
    }

    public CmsMacroResolver setKeepEmptyMacros(boolean keepEmptyMacros) {
        this.m_keepEmptyMacros = keepEmptyMacros;
        return this;
    }

    public CmsMacroResolver setMessages(CmsMessages messages) {
        this.m_messages = messages;
        return this;
    }

    public CmsMacroResolver setResourceName(String resourceName) {
        this.m_resourceName = resourceName;
        return this;
    }
}

