/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsPatternLayout
extends PatternLayout {
    private List<String> m_excludes;
    private List<String> m_filters = new ArrayList<String>();
    private int m_maxLength;

    public CmsPatternLayout() {
        this("%m%n");
    }

    CmsPatternLayout(String pattern) {
        super(pattern);
        this.m_excludes = new ArrayList<String>();
        this.m_maxLength = Integer.MAX_VALUE;
    }

    public String format(LoggingEvent event) {
        String result = super.format(event);
        ThrowableInformation ti = event.getThrowableInformation();
        if (ti != null) {
            StringBuffer trace = new StringBuffer();
            StringBuffer minTrace = new StringBuffer();
            boolean exclFound = false;
            int count = 0;
            int filtered = 0;
            int truncated = 0;
            String[] elements = ti.getThrowableStrRep();
            for (int i = 0; i < elements.length; ++i) {
                String elem = elements[i];
                if (!elem.trim().startsWith("at ") && !elem.trim().startsWith("...")) {
                    minTrace.append(elem).append(Layout.LINE_SEP);
                }
                if (elem.trim().startsWith("Caused")) {
                    if (!(exclFound || truncated <= 0 && filtered <= 0)) {
                        trace.append(this.createSummary(truncated, filtered));
                    }
                    count = 0;
                    filtered = 0;
                    truncated = 0;
                }
                if (!this.matches(elem, this.m_filters) && !exclFound) {
                    if (count < this.m_maxLength) {
                        trace.append(elem).append(Layout.LINE_SEP);
                        ++count;
                    } else {
                        ++truncated;
                    }
                } else {
                    ++filtered;
                }
                if (exclFound || !this.matches(elem, this.m_excludes)) continue;
                exclFound = true;
            }
            if (exclFound) {
                result = result + minTrace.toString();
            } else {
                if (truncated > 0 || filtered > 0) {
                    trace.append(this.createSummary(truncated, filtered));
                }
                result = result + trace.toString();
            }
        }
        return result;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void setExclude(String exclude) {
        String[] entries = exclude.split(",");
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i].trim();
            if (!entry.startsWith("at ")) {
                entry = "at " + entry;
            }
            this.m_excludes.add(entry);
        }
    }

    public void setFilter(String filter) {
        String[] entries = filter.split(",");
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i].trim();
            if (!entry.startsWith("at ")) {
                entry = "at " + entry;
            }
            this.m_filters.add(entry);
        }
    }

    public void setMaxLength(String len) {
        try {
            this.m_maxLength = Integer.parseInt(len);
        }
        catch (NumberFormatException ex) {
            this.m_maxLength = Integer.MAX_VALUE;
        }
    }

    private String createSummary(int truncated, int filtered) {
        StringBuffer result = new StringBuffer(128);
        result.append("\t... ");
        result.append(filtered + truncated);
        result.append(" more (");
        result.append(filtered);
        result.append(" filtered; ");
        result.append(truncated);
        result.append(" truncated)");
        result.append(Layout.LINE_SEP);
        return result.toString();
    }

    private boolean matches(String element, List<String> list) {
        boolean result = false;
        for (String rule : list) {
            if (!element.trim().startsWith(rule)) continue;
            return true;
        }
        return result;
    }
}

