/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.util.Messages;
import org.safehaus.uuid.EthernetAddress;
import org.safehaus.uuid.UUID;
import org.safehaus.uuid.UUIDGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsUUID
implements Cloneable,
Comparable<CmsUUID>,
Externalizable {
    public static final String UUID_REGEX = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
    private static final Log LOG = CmsLog.getLog(CmsUUID.class);
    private static EthernetAddress m_ethernetAddress;
    private static UUID m_opencmsUUID;
    private static final CmsUUID NULL_UUID;
    private static final long serialVersionUID = 1736324454709298676L;
    private transient UUID m_uuid;

    public CmsUUID() {
        if (m_ethernetAddress == null) {
            CmsUUID.init(CmsUUID.getDummyEthernetAddress());
        }
        this.m_uuid = UUIDGenerator.getInstance().generateTimeBasedUUID(m_ethernetAddress);
    }

    public CmsUUID(byte[] data) {
        this.m_uuid = new UUID(data);
    }

    public CmsUUID(String uuid) throws NumberFormatException {
        this.m_uuid = new UUID(uuid);
    }

    private CmsUUID(UUID uuid) {
        this.m_uuid = uuid;
    }

    public static void checkId(CmsUUID id, boolean canBeNull) {
        if (canBeNull && id == null) {
            return;
        }
        if (!canBeNull && id == null || id.isNullUUID()) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INVALID_UUID_1", id));
        }
    }

    public static CmsUUID getConstantUUID(String name) {
        return new CmsUUID(UUIDGenerator.getInstance().generateNameBasedUUID(m_opencmsUUID, name));
    }

    public static String getDummyEthernetAddress() {
        return UUIDGenerator.getInstance().getDummyAddress().toString();
    }

    public static CmsUUID getNullUUID() {
        return NULL_UUID;
    }

    public static CmsUUID getOpenCmsUUID() {
        return new CmsUUID(m_opencmsUUID);
    }

    public static void init(String ethernetAddress) throws CmsInitException {
        try {
            m_ethernetAddress = new EthernetAddress(ethernetAddress);
        }
        catch (Exception e) {
            throw new CmsInitException(Messages.get().container("ERR_INVALID_ETHERNET_ADDRESS_1", ethernetAddress));
        }
    }

    public static boolean isValidUUID(String uuid) {
        try {
            return null != uuid && null != UUID.valueOf((String)uuid);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static CmsUUID valueOf(String uuid) throws NumberFormatException {
        return new CmsUUID(UUID.valueOf((String)uuid));
    }

    public Object clone() {
        if (this == NULL_UUID) {
            return NULL_UUID;
        }
        return new CmsUUID((UUID)this.m_uuid.clone());
    }

    @Override
    public int compareTo(CmsUUID obj) {
        return this.m_uuid.compareTo((Object)obj.m_uuid);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsUUID) {
            return ((CmsUUID)obj).m_uuid.equals((Object)this.m_uuid);
        }
        return false;
    }

    public String getStringValue() {
        return this.toString();
    }

    public int hashCode() {
        return this.m_uuid.hashCode();
    }

    public boolean isNullUUID() {
        if (this == NULL_UUID) {
            return true;
        }
        return this.m_uuid.equals((Object)UUID.getNullUUID());
    }

    @Override
    public void readExternal(ObjectInput in) {
        Object o;
        block7: {
            o = null;
            try {
                o = in.readObject();
            }
            catch (Throwable e) {
                try {
                    in.readLong();
                    o = in.readObject();
                }
                catch (Throwable t) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_READ_UUID_OLD_1", o), t);
                }
            }
        }
        if (o instanceof String) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_READ_UUID_1", o));
            }
            this.m_uuid = new UUID((String)o);
        }
        if (this.m_uuid == null && LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_READ_UUID_0"));
        }
    }

    public byte[] toByteArray() {
        return this.m_uuid.toByteArray();
    }

    public String toString() {
        return this.m_uuid.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_WRITE_UUID_1", this.toString()));
        }
        out.writeObject(this.toString());
    }

    static {
        m_opencmsUUID = UUIDGenerator.getInstance().generateNameBasedUUID(new UUID("6ba7b810-9dad-11d1-80b4-00c04fd430c8"), "www.opencms.org");
        NULL_UUID = new CmsUUID(UUID.getNullUUID());
    }
}

