/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class A_CmsWidget
implements I_CmsWidget {
    public static final String HELP_POSTFIX = ".help";
    public static final String LABEL_PREFIX = "label.";
    private String m_configuration;

    protected A_CmsWidget() {
        this.setConfiguration("");
    }

    protected A_CmsWidget(String configuration) {
        this.setConfiguration(configuration);
    }

    public static String getHelpKey(I_CmsWidgetParameter param) {
        StringBuffer result = new StringBuffer(64);
        result.append(LABEL_PREFIX);
        result.append(param.getKey());
        result.append(HELP_POSTFIX);
        return result.toString();
    }

    public static String getLabelKey(I_CmsWidgetParameter param) {
        StringBuffer result = new StringBuffer(64);
        result.append(LABEL_PREFIX);
        result.append(param.getKey());
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof A_CmsWidget) {
            return this.getClass().getName().equals(obj.getClass().getName());
        }
        return false;
    }

    @Override
    public String getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public String getDialogHtmlEnd(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter value) {
        return this.getHelpText(widgetDialog, value);
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return "";
    }

    @Override
    public String getDialogInitCall(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return "";
    }

    @Override
    public String getDialogInitMethod(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return "";
    }

    @Override
    public String getHelpBubble(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        StringBuffer result = new StringBuffer(128);
        String locKey = A_CmsWidget.getHelpKey(param);
        String locValue = widgetDialog.getMessages().key(locKey, true);
        if (!widgetDialog.useNewStyle()) {
            locKey = param.getId();
        }
        if (locValue == null) {
            return widgetDialog.dialogHorizontalSpacer(16);
        }
        result.append("<td>");
        result.append("<img id=\"img");
        result.append(locKey);
        result.append("\" src=\"");
        result.append(OpenCms.getLinkManager().substituteLink(cms, "/system/workplace/resources/commons/help.png"));
        result.append("\" alt=\"\" border=\"0\"");
        if (widgetDialog.useNewStyle()) {
            result.append(this.getJsHelpMouseHandler(widgetDialog, locKey, null));
        } else {
            locValue = CmsStringUtil.substitute(locValue, "\"", "&quot;");
            result.append(this.getJsHelpMouseHandler(widgetDialog, locKey, CmsStringUtil.escapeJavaScript(locValue)));
        }
        result.append("></td>");
        return result.toString();
    }

    @Override
    public String getHelpText(I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String helpId = A_CmsWidget.getHelpKey(param);
        Set<String> helpIdsShown = widgetDialog.getHelpMessageIds();
        if (helpIdsShown.contains(helpId)) {
            return "";
        }
        helpIdsShown.add(helpId);
        String locValue = widgetDialog.getMessages().key(helpId, true);
        if (locValue == null) {
            return "";
        }
        if (widgetDialog.useNewStyle()) {
            StringBuffer result = new StringBuffer(128);
            result.append("<div class=\"help\" id=\"help");
            result.append(helpId);
            result.append("\"");
            result.append(this.getJsHelpMouseHandler(widgetDialog, helpId, helpId));
            result.append(">");
            result.append(locValue);
            result.append("</div>\n");
            return result.toString();
        }
        return "";
    }

    @Override
    public String getWidgetStringValue(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        if (param != null) {
            return param.getStringValue(cms);
        }
        return null;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public void setConfiguration(String configuration) {
        this.m_configuration = configuration;
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            param.setStringValue(cms, values[0]);
        }
    }

    protected String getJsHelpMouseHandler(I_CmsWidgetDialog widgetDialog, String key, String value) {
        String keyHide;
        String jsHide;
        String jsShow;
        if (widgetDialog.useNewStyle()) {
            jsShow = "sMH";
            jsHide = "hMH";
            keyHide = "'" + key + "'";
        } else {
            jsShow = "showHelpText";
            jsHide = "hideHelpText";
            keyHide = "";
        }
        StringBuffer result = new StringBuffer(128);
        result.append(" onmouseover=\"");
        result.append(jsShow);
        result.append("('");
        result.append(key);
        if (!widgetDialog.useNewStyle()) {
            result.append("', '");
            result.append(value);
        }
        result.append("');\" onmouseout=\"");
        result.append(jsHide);
        result.append("(");
        result.append(keyHide);
        result.append(");\"");
        return result.toString();
    }

    protected String getJSIncludeFile(String fileName) {
        StringBuffer result = new StringBuffer(8);
        result.append("<script type=\"text/javascript\" src=\"");
        result.append(fileName);
        result.append("\"></script>");
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CmsDummyWidgetDialog
    implements I_CmsWidgetDialog {
        private CmsMessages m_message;
        private Locale m_locale;

        public CmsDummyWidgetDialog(Locale locale, CmsMessages message) {
            this.m_locale = locale;
            this.m_message = message;
        }

        @Override
        public String button(String href, String target, String image, String label, int type) {
            return null;
        }

        @Override
        public String buttonBar(int segment) {
            return null;
        }

        @Override
        public String buttonBarHorizontalLine() {
            return null;
        }

        @Override
        public String buttonBarSeparator(int leftPixel, int rightPixel) {
            return null;
        }

        @Override
        public String buttonBarSpacer(int width) {
            return null;
        }

        @Override
        public String buttonBarStartTab(int leftPixel, int rightPixel) {
            return null;
        }

        @Override
        public String dialogHorizontalSpacer(int width) {
            return null;
        }

        @Override
        public int getButtonStyle() {
            return 0;
        }

        @Override
        public Set<String> getHelpMessageIds() {
            return null;
        }

        @Override
        public Locale getLocale() {
            return this.m_locale;
        }

        @Override
        public CmsMessages getMessages() {
            return this.m_message;
        }

        @Override
        public String getUserAgent() {
            return null;
        }

        @Override
        public boolean useNewStyle() {
            return false;
        }
    }
}

