/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.file.CmsObject;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsAdeGalleryWidget;
import org.opencms.widgets.CmsVfsImageWidgetConfiguration;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;

public class CmsAdeImageGalleryWidget
extends A_CmsAdeGalleryWidget {
    private CmsVfsImageWidgetConfiguration m_widgetConfiguration;
    private static final String GALLERY_NAME = "image";

    public CmsAdeImageGalleryWidget() {
        this("");
    }

    protected CmsAdeImageGalleryWidget(String configuration) {
        super(configuration);
    }

    public String getGalleryName() {
        return GALLERY_NAME;
    }

    public String getWidgetName() {
        return CmsAdeImageGalleryWidget.class.getName();
    }

    public I_CmsWidget newInstance() {
        return new CmsAdeImageGalleryWidget(this.getConfiguration());
    }

    protected JSONObject getAdditionalGalleryInfo(CmsObject cms, CmsMessages messages, I_CmsWidgetParameter param) throws JSONException {
        CmsVfsImageWidgetConfiguration config = this.getWidgetConfiguration(cms, messages, param);
        JSONObject result = new JSONObject();
        result.put(I_CmsGalleryProviderConstants.ReqParam.useFormats.name(), config.isShowFormat());
        result.put(I_CmsGalleryProviderConstants.ReqParam.imageFormats.name(), new JSONArray(config.getFormatValues()));
        String temp = config.getSelectFormatString();
        String[] formatNames = new String[]{};
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(temp)) {
            formatNames = config.getSelectFormatString().split("\\|");
        }
        result.put(I_CmsGalleryProviderConstants.ReqParam.imageFormatNames.name(), new JSONArray(formatNames));
        return result;
    }

    protected String getGalleryTypes() {
        return CmsResourceTypeImage.getStaticTypeName();
    }

    protected String getOpenPreviewCall(I_CmsWidgetDialog widgetDialog, String id) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("javascript:cmsOpenImagePreview('").append(widgetDialog.getMessages().key("GUI_BUTTON_PREVIEW_0"));
        sb.append("', '").append(OpenCms.getSystemInfo().getOpenCmsContext());
        sb.append("', '").append(id);
        sb.append("'); return false;");
        return sb.toString();
    }

    protected CmsVfsImageWidgetConfiguration getWidgetConfiguration(CmsObject cms, CmsMessages messages, I_CmsWidgetParameter param) {
        if (this.m_widgetConfiguration == null) {
            this.m_widgetConfiguration = new CmsVfsImageWidgetConfiguration(cms, messages, param, this.getConfiguration());
        }
        return this.m_widgetConfiguration;
    }
}

