/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.xml.types.CmsXmlBooleanValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsCheckboxWidget
extends A_CmsWidget {
    public static final String HIDDEN_SUFFIX = ".value";

    public CmsCheckboxWidget() {
        this("");
    }

    public CmsCheckboxWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        StringBuffer result = new StringBuffer(16);
        result.append("<td class=\"xmlTd\">");
        result.append("<input type=\"checkbox\" name=\"");
        result.append(param.getId());
        result.append("\" value=\"true\"");
        boolean booleanValue = CmsXmlBooleanValue.getBooleanValue(cms, param);
        if (booleanValue) {
            result.append(" checked=\"checked\"");
        }
        result.append(">");
        result.append("<input type=\"hidden\" name=\"");
        result.append(param.getId());
        result.append(HIDDEN_SUFFIX);
        result.append("\" value=\"");
        result.append(booleanValue);
        result.append("\">");
        result.append("</td>");
        return result.toString();
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsCheckboxWidget(this.getConfiguration());
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            boolean booleanValue = CmsXmlBooleanValue.getBooleanValue(cms, param);
            String formValue = values[0].trim();
            if (CmsStringUtil.isNotEmpty(formValue)) {
                booleanValue = Boolean.valueOf(formValue);
            }
            param.setStringValue(cms, String.valueOf(booleanValue));
        } else {
            values = formParameters.get(param.getId() + HIDDEN_SUFFIX);
            String value = values != null && values.length > 0 ? Boolean.FALSE.toString() : param.getDefault(cms);
            param.setStringValue(cms, value);
        }
    }
}

