/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplace;

public class CmsGroupWidget
extends A_CmsWidget {
    public static final String CONFIGURATION_FLAGS = "flags";
    public static final String CONFIGURATION_OUFQN = "oufqn";
    public static final String CONFIGURATION_USER = "user";
    private Integer m_flags;
    private String m_ouFqn;
    private String m_userName;

    public CmsGroupWidget() {
        this("");
    }

    public CmsGroupWidget(Integer flags, String userName) {
        this.m_flags = flags;
        this.m_userName = userName;
        this.m_ouFqn = null;
    }

    public CmsGroupWidget(Integer flags, String userName, String ouFqn) {
        this.m_flags = flags;
        this.m_userName = userName;
        this.m_ouFqn = ouFqn;
    }

    public CmsGroupWidget(String configuration) {
        super(configuration);
    }

    public String getConfiguration() {
        StringBuffer result = new StringBuffer(8);
        if (this.m_flags != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_FLAGS);
            result.append("=");
            result.append(this.m_flags);
        }
        if (this.m_userName != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_USER);
            result.append("=");
            result.append(this.m_userName);
        }
        if (this.m_ouFqn != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_OUFQN);
            result.append("=");
            result.append(this.m_ouFqn);
        }
        return result.toString();
    }

    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/groupselector.js"));
        return result.toString();
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(128);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\"><tr><td style=\"width: 100%;\">");
        result.append("<input style=\"width: 99%;\" class=\"xmlInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" value=\"");
        result.append(param.getStringValue(cms));
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        StringBuffer buttonJs = new StringBuffer(8);
        buttonJs.append("javascript:openGroupWin('");
        buttonJs.append(OpenCms.getSystemInfo().getOpenCmsContext());
        buttonJs.append("/system/workplace/commons/group_selection.jsp");
        buttonJs.append("','EDITOR',  '");
        buttonJs.append(id);
        buttonJs.append("', document, ");
        if (this.m_flags != null) {
            buttonJs.append("'");
            buttonJs.append(this.m_flags);
            buttonJs.append("'");
        } else {
            buttonJs.append("null");
        }
        buttonJs.append(", ");
        if (this.m_userName != null) {
            buttonJs.append("'");
            buttonJs.append(this.m_userName);
            buttonJs.append("'");
        } else {
            buttonJs.append("null");
        }
        buttonJs.append(", ");
        if (this.m_ouFqn != null) {
            buttonJs.append("'");
            buttonJs.append(this.m_ouFqn);
            buttonJs.append("'");
        } else {
            buttonJs.append("null");
        }
        buttonJs.append(");");
        result.append(widgetDialog.button(buttonJs.toString(), null, "group", "GUI_DIALOG_BUTTON_SEARCH_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append("</td>");
        return result.toString();
    }

    public Integer getFlags() {
        return this.m_flags;
    }

    public String getOufqn() {
        return this.m_ouFqn;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public I_CmsWidget newInstance() {
        return new CmsGroupWidget(this.getConfiguration());
    }

    public void setConfiguration(String configuration) {
        this.m_userName = null;
        this.m_flags = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration)) {
            int oufqnIndex;
            int groupIndex;
            int flagsIndex = configuration.indexOf(CONFIGURATION_FLAGS);
            if (flagsIndex != -1) {
                String flags = configuration.substring(CONFIGURATION_FLAGS.length() + 1);
                if (flags.indexOf(124) != -1) {
                    flags = flags.substring(0, flags.indexOf(124));
                }
                try {
                    this.m_flags = Integer.valueOf(flags);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if ((groupIndex = configuration.indexOf(CONFIGURATION_USER)) != -1) {
                String user = configuration.substring(groupIndex + CONFIGURATION_USER.length() + 1);
                if (user.indexOf(124) != -1) {
                    user = user.substring(0, user.indexOf(124));
                }
                this.m_userName = user;
            }
            if ((oufqnIndex = configuration.indexOf(CONFIGURATION_OUFQN)) != -1) {
                String oufqn = configuration.substring(oufqnIndex + CONFIGURATION_OUFQN.length() + 1);
                if (oufqn.indexOf(124) != -1) {
                    oufqn = oufqn.substring(0, oufqn.indexOf(124));
                }
                this.m_ouFqn = oufqn;
            }
        }
        super.setConfiguration(configuration);
    }
}

