/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsGalleryWidgetConfiguration;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsImageWidgetDynamicConfiguration;
import org.opencms.widgets.I_CmsWidgetParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsVfsImageWidgetConfiguration
extends CmsGalleryWidgetConfiguration {
    public static final String CONFIG_KEY_FORMATNAMES = "formatnames";
    public static final String CONFIG_KEY_FORMATVALUES = "formatvalues";
    public static final String CONFIG_KEY_SCALEPARAMS = "scaleparams";
    public static final String CONFIG_KEY_USEDESCRIPTION = "usedescription";
    public static final String CONFIG_KEY_USEFORMAT = "useformat";
    public static final String TYPE_CATEGORY = "category";
    public static final String TYPE_GALLERY = "gallery";
    private List<String> m_formatValues;
    private String m_scaleParams;
    private List<CmsSelectWidgetOption> m_selectFormat;
    private String m_selectFormatString;
    private boolean m_showDescription;
    private boolean m_showFormat;

    public CmsVfsImageWidgetConfiguration(CmsObject cms, CmsMessages widgetDialog, I_CmsWidgetParameter param, String configuration) {
        this.init(cms, widgetDialog, param, configuration);
    }

    public List<String> getFormatValues() {
        return this.m_formatValues;
    }

    public String getScaleParams() {
        return this.m_scaleParams;
    }

    public List<CmsSelectWidgetOption> getSelectFormat() {
        return this.m_selectFormat;
    }

    public String getSelectFormatString() {
        return this.m_selectFormatString;
    }

    public boolean isShowDescription() {
        return this.m_showDescription;
    }

    public boolean isShowFormat() {
        return this.m_showFormat;
    }

    @Override
    protected void init(CmsObject cms, CmsMessages widgetDialog, I_CmsWidgetParameter param, String configuration) {
        if (configuration == null) {
            return;
        }
        configuration = CmsMacroResolver.resolveMacros(configuration, cms, widgetDialog);
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj = new JSONObject(configuration);
        }
        catch (JSONException e) {
            return;
        }
        this.setClassName(jsonObj.optString("class", null));
        I_CmsImageWidgetDynamicConfiguration dynConf = null;
        if (this.getClassName() != null) {
            try {
                dynConf = (I_CmsImageWidgetDynamicConfiguration)Class.forName(this.getClassName()).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.setShowDescription(jsonObj.optBoolean(CONFIG_KEY_USEDESCRIPTION));
        this.setShowFormat(jsonObj.optBoolean(CONFIG_KEY_USEFORMAT));
        if (this.isShowFormat()) {
            String optionsStr = (String)jsonObj.opt(CONFIG_KEY_FORMATNAMES);
            this.setSelectFormatString(optionsStr);
            this.setSelectFormat(CmsSelectWidgetOption.parseOptions(optionsStr));
            JSONArray formatValues = jsonObj.optJSONArray(CONFIG_KEY_FORMATVALUES);
            if (formatValues != null) {
                ArrayList<String> formatValueList = new ArrayList<String>(formatValues.length());
                for (int i = 0; i < formatValues.length(); ++i) {
                    formatValueList.add(formatValues.optString(i));
                }
                this.setFormatValues(formatValueList);
            }
            if (dynConf != null) {
                this.setFormatValues(dynConf.getFormatValues(cms, widgetDialog, param, this.getSelectFormat(), this.getFormatValues()));
            }
        }
        this.setType(jsonObj.optString("type"));
        if (("dynamic".equals(this.getType()) || CmsStringUtil.isEmpty(this.getType())) && dynConf != null) {
            this.setType(dynConf.getType(cms, widgetDialog, param));
        }
        this.setStartup(jsonObj.optString("startup"));
        if (("dynamic".equals(this.getStartup()) || CmsStringUtil.isEmpty(this.getStartup())) && dynConf != null) {
            this.setStartup(dynConf.getStartup(cms, widgetDialog, param));
        }
        this.setScaleParams(jsonObj.optString(CONFIG_KEY_SCALEPARAMS));
    }

    private void setFormatValues(List<String> formatValues) {
        this.m_formatValues = formatValues;
    }

    private void setScaleParams(String scaleParams) {
        this.m_scaleParams = scaleParams;
    }

    private void setSelectFormat(List<CmsSelectWidgetOption> selectFormat) {
        this.m_selectFormat = selectFormat;
    }

    private void setSelectFormatString(String formatString) {
        this.m_selectFormatString = formatString;
    }

    private void setShowDescription(boolean showDescription) {
        this.m_showDescription = showDescription;
    }

    private void setShowFormat(boolean showFormat) {
        this.m_showFormat = showFormat;
    }

    @Override
    public String getConfigString() {
        String result = "";
        if (this.m_startup != null) {
            result = result + "&startup=" + this.m_startup;
        }
        if (this.m_type != null) {
            result = result + "&type=" + this.m_type;
        }
        return result;
    }
}

