/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workflow;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opencms.ade.publish.CmsPublish;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.ade.publish.shared.CmsWorkflow;
import org.opencms.ade.publish.shared.CmsWorkflowAction;
import org.opencms.ade.publish.shared.CmsWorkflowResponse;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.workflow.A_CmsWorkflowManager;
import org.opencms.workflow.CmsInvalidActionException;
import org.opencms.workflow.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsDefaultWorkflowManager
extends A_CmsWorkflowManager {
    public static final String ACTION_FORCE_PUBLISH = "forcepublish";
    public static final String ACTION_PUBLISH = "publish";
    public static final String WORKFLOW_PUBLISH = "WORKFLOW_PUBLISH";

    @Override
    public CmsWorkflowResponse executeAction(CmsObject userCms, CmsWorkflowAction action, List<CmsResource> resources) throws CmsException {
        String actionKey = action.getAction();
        if ("cancel".equals(actionKey)) {
            return new CmsWorkflowResponse(true, actionKey, null, null, null);
        }
        if (ACTION_PUBLISH.equals(actionKey)) {
            return this.actionPublish(userCms, resources);
        }
        if (ACTION_FORCE_PUBLISH.equals(actionKey)) {
            return this.actionForcePublish(userCms, resources);
        }
        throw new CmsInvalidActionException(actionKey);
    }

    public String getLabel(CmsObject cms, String key) {
        CmsMessages messages = Messages.get().getBundle(this.getLocale(cms));
        return messages.key(key);
    }

    @Override
    public List<CmsPublishResource> getWorkflowPublishResources(CmsObject cms, CmsWorkflow workflow, CmsPublishOptions options) {
        CmsPublish publish = new CmsPublish(cms, options);
        return publish.getPublishResourceBeans();
    }

    @Override
    public List<CmsResource> getWorkflowResources(CmsObject cms, CmsWorkflow workflow, CmsPublishOptions options) {
        CmsPublish publish = new CmsPublish(cms, options);
        return publish.getPublishResources();
    }

    @Override
    public Map<String, CmsWorkflow> getWorkflows(CmsObject cms) {
        LinkedHashMap<String, CmsWorkflow> result = new LinkedHashMap<String, CmsWorkflow>();
        ArrayList<CmsWorkflowAction> actions = new ArrayList<CmsWorkflowAction>();
        String publishLabel = this.getLabel(cms, "GUI_WORKFLOW_ACTION_PUBLISH_0");
        CmsWorkflowAction publishAction = new CmsWorkflowAction(ACTION_PUBLISH, publishLabel, true, true);
        actions.add(publishAction);
        String workflowLabel = this.getLabel(cms, "GUI_WORKFLOW_PUBLISH_0");
        CmsWorkflow publishWorkflow = new CmsWorkflow(WORKFLOW_PUBLISH, workflowLabel, actions);
        result.put(WORKFLOW_PUBLISH, publishWorkflow);
        return result;
    }

    protected CmsWorkflowResponse actionForcePublish(CmsObject userCms, List<CmsResource> resources) throws CmsException {
        CmsPublish publish = new CmsPublish(userCms);
        publish.publishResources(resources);
        CmsWorkflowResponse response = new CmsWorkflowResponse(true, "", new ArrayList<CmsPublishResource>(), new ArrayList<CmsWorkflowAction>(), null);
        return response;
    }

    protected CmsWorkflowResponse actionPublish(CmsObject userCms, List<CmsResource> resources) throws CmsException {
        CmsPublish publish = new CmsPublish(userCms);
        List<CmsPublishResource> brokenResources = publish.getBrokenResources(resources);
        if (brokenResources.size() == 0) {
            publish.publishResources(resources);
            CmsWorkflowResponse response = new CmsWorkflowResponse(true, "", new ArrayList<CmsPublishResource>(), new ArrayList<CmsWorkflowAction>(), null);
            return response;
        }
        String brokenResourcesLabel = this.getLabel(userCms, "GUI_BROKEN_LINKS_0");
        boolean canForcePublish = OpenCms.getWorkplaceManager().getDefaultUserSettings().isAllowBrokenRelations() || OpenCms.getRoleManager().hasRole(userCms, CmsRole.VFS_MANAGER);
        ArrayList<CmsWorkflowAction> actions = new ArrayList<CmsWorkflowAction>();
        if (canForcePublish) {
            String forceLabel = this.getLabel(userCms, "GUI_WORKFLOW_ACTION_FORCE_PUBLISH_0");
            actions.add(new CmsWorkflowAction(ACTION_FORCE_PUBLISH, forceLabel, true, true));
        }
        CmsWorkflowResponse response = new CmsWorkflowResponse(false, brokenResourcesLabel, brokenResources, actions, null);
        return response;
    }
}

