/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workflow;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsPublish;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResourceInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;
import org.opencms.workflow.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsExtendedPublish
extends CmsPublish {
    protected static final Log LOG = CmsLog.getLog(CmsExtendedPublish.class);
    private Map<CmsUUID, Boolean> m_workflowProjectStatus = new MapMaker().makeComputingMap((Function)new Function<CmsUUID, Boolean>(){

        public Boolean apply(CmsUUID projectId) {
            try {
                CmsProject project = CmsExtendedPublish.this.m_cms.readProject(projectId);
                return new Boolean(project.isWorkflowProject());
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return Boolean.FALSE;
            }
        }
    });

    public CmsExtendedPublish(CmsObject cms) {
        super(cms);
    }

    public CmsExtendedPublish(CmsObject cms, CmsPublishOptions options) {
        super(cms, options);
    }

    protected String getMessage(String key, String ... args) {
        return Messages.get().getBundle(this.m_cms.getRequestContext().getLocale()).key(key, args);
    }

    @Override
    protected CmsPublishResourceInfo getResourceInfo(CmsResource resource, Set<CmsResource> published, CmsPublish.ResourcesAndRelated permissions, CmsPublish.ResourcesAndRelated locked) {
        CmsPublishResourceInfo info = super.getResourceInfo(resource, published, permissions, locked);
        if (info == null) {
            CmsUUID projectId = resource.getProjectLastModified();
            CmsUUID optionsProject = this.m_options.getProjectId();
            if (this.isWorkflowProject(projectId) && (optionsProject == null || !projectId.equals(optionsProject))) {
                info = new CmsPublishResourceInfo(this.getMessage("GUI_ALREADY_IN_WORKFLOW_0", new String[0]), CmsPublishResourceInfo.Type.WORKFLOW);
            }
        }
        return info;
    }

    private boolean isWorkflowProject(CmsUUID projectId) {
        return this.m_workflowProjectStatus.get(projectId);
    }
}

