/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CmsTabDialog
extends CmsDialog {
    public static final int ACTION_SWITCHTAB = 100;
    public static final String DIALOG_SWITCHTAB = "switchtab";
    public static final String PARAM_SETPRESSED = "setpressed";
    public static final String PARAM_TAB = "tab";
    private static final Log LOG = CmsLog.getLog(CmsTabDialog.class);
    private int m_activeTab = -1;
    private String m_paramSetPressed;
    private String m_paramTab;

    public CmsTabDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsTabDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String dialogTabContent(int segment, String title, String attributes) {
        if (segment == 0) {
            StringBuffer result = new StringBuffer(512);
            result.append(this.dialogHead(title));
            result.append("<div class=\"dialogtabstart\" unselectable=\"on\">\n");
            result.append("<!-- dialogtabs start -->\n");
            result.append(this.dialogTabRow());
            result.append("<div class=\"dialogtabcontent\"");
            if (attributes != null) {
                result.append(" " + attributes);
            }
            result.append(">\n");
            result.append("<!-- dialogcontent start -->\n");
            return result.toString();
        }
        return "\n<!-- dialogcontent end --></div>\n<!-- dialogtabs end --></div>";
    }

    public String dialogTabContentEnd() {
        return this.dialogTabContent(1, null, null);
    }

    public String dialogTabContentStart(String title) {
        return this.dialogTabContent(0, title, null);
    }

    public String dialogTabContentStart(String title, String attributes) {
        return this.dialogTabContent(0, title, attributes);
    }

    public String dialogTabRow() {
        StringBuffer result = new StringBuffer(512);
        StringBuffer lineRow = new StringBuffer(256);
        List<String> tabNames = this.getTabs();
        if (tabNames.size() < 2) {
            result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\" style=\"empty-cells: show;\">\n");
            result.append("<tr>\n");
            result.append("\t<td class=\"dialogtabrow\"></td>\n");
            result.append("</tr>\n");
            result.append("</table>\n");
            return result.toString();
        }
        Iterator<String> i = tabNames.iterator();
        int counter = 1;
        int activeTab = this.getActiveTab();
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\" style=\"empty-cells: show;\">\n");
        result.append("<tr>\n");
        while (i.hasNext()) {
            String curTab = i.next();
            String curTabLink = "javascript:openTab('" + counter + "');";
            if (counter == activeTab) {
                int addDelta = 0;
                result.append("\t<td class=\"dialogtabactive\"");
                if (counter == 1) {
                    result.append(" style=\"border-left-width: 1px;\"");
                    addDelta = 1;
                }
                result.append(">");
                result.append("<span class=\"tabactive\" unselectable=\"on\"");
                result.append(" style=\"width: " + (curTab.length() * 8 + addDelta) + "px;\"");
                result.append(">");
                result.append(curTab);
                result.append("</span></td>\n");
                lineRow.append("\t<td></td>\n");
            } else {
                result.append("\t<td class=\"dialogtab\" unselectable=\"on\">");
                result.append("<a class=\"tab\" href=\"" + curTabLink + "\"");
                result.append(" style=\"width: " + curTab.length() * 8 + "px;\"");
                result.append(">");
                result.append(curTab);
                result.append("</a></td>\n");
                lineRow.append("\t<td class=\"dialogtabrow\"></td>\n");
            }
            ++counter;
        }
        result.append("\t<td class=\"maxwidth\"></td>\n");
        result.append("</tr>\n");
        result.append("<tr>\n");
        result.append(lineRow);
        result.append("\t<td class=\"dialogtabrow\"></td>\n");
        result.append("</tr>\n");
        result.append("</table>\n");
        return result.toString();
    }

    public int getActiveTab() {
        if (this.m_activeTab < 0) {
            int tab;
            block4: {
                String paramTab = this.getParamTab();
                tab = 1;
                if (CmsStringUtil.isNotEmpty(paramTab)) {
                    try {
                        tab = Integer.parseInt(paramTab);
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isInfoEnabled()) break block4;
                        LOG.info((Object)e.getLocalizedMessage());
                    }
                }
            }
            this.setParamTab("" + tab);
            this.m_activeTab = tab;
            return tab;
        }
        return this.m_activeTab;
    }

    public String getActiveTabName() {
        if (this.m_activeTab < 0) {
            this.getActiveTab();
        }
        List<String> tabNames = this.getTabs();
        try {
            return tabNames.get(this.m_activeTab - 1);
        }
        catch (IndexOutOfBoundsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e.getLocalizedMessage());
            }
            return null;
        }
    }

    public String getParamSetPressed() {
        return this.m_paramSetPressed;
    }

    public String getParamTab() {
        return this.m_paramTab;
    }

    public abstract List<String> getTabParameterOrder();

    public abstract List<String> getTabs();

    @Override
    public String htmlStart() {
        return this.htmlStart(null);
    }

    @Override
    public String htmlStart(String helpUrl) {
        String stylesheet = null;
        if (this.isPopup()) {
            stylesheet = "popup.css";
        }
        StringBuffer result = new StringBuffer(super.pageHtmlStyle(0, null, stylesheet));
        if (this.getSettings().isViewExplorer()) {
            result.append("<script type=\"text/javascript\" src=\"");
            result.append(CmsTabDialog.getSkinUri());
            result.append("commons/explorer.js\"></script>\n");
        }
        result.append("<script type=\"text/javascript\">\n");
        if (helpUrl != null) {
            result.append("top.head.helpUrl=\"");
            result.append(helpUrl + "\";\n");
        }
        result.append("function openTab(tabValue) {\n");
        result.append("\tdocument.forms[0].tab.value = tabValue;\n");
        result.append("\tdocument.forms[0].action.value = \"switchtab\";\n");
        result.append("\tdocument.forms[0].submit();\n");
        result.append("}\n");
        result.append("function submitAction(actionValue, theForm, formName) {\n");
        result.append("\tif (theForm == null) {\n");
        result.append("\t\ttheForm = document.forms[formName];\n");
        result.append("\t}\n");
        result.append("\ttheForm.framename.value = window.name;\n");
        result.append("\tif (actionValue == \"set\") {\n");
        result.append("\t\ttheForm.action.value = \"set\";\n");
        result.append("\t} else if (actionValue == \"cancel\") {\n");
        result.append("\t\ttheForm.action.value = \"cancel\";\n");
        result.append("\t}\n");
        result.append("\ttheForm.submit();\n");
        result.append("\treturn false;\n");
        result.append("}\n");
        result.append("//-->\n</script>\n");
        return result.toString();
    }

    @Override
    public String paramsAsHidden() {
        StringBuffer result = new StringBuffer(512);
        String activeTab = this.getTabParameterOrder().get(this.getActiveTab() - 1);
        Map<String, Object> params = this.paramValues();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String param = entry.getKey();
            if (param.startsWith(activeTab)) continue;
            result.append("<input type=\"hidden\" name=\"");
            result.append(param);
            result.append("\" value=\"");
            result.append(CmsEncoder.encode(entry.getValue().toString(), this.getCms().getRequestContext().getEncoding()));
            result.append("\">\n");
        }
        return result.toString();
    }

    public void setParamSetPressed(String value) {
        this.m_paramSetPressed = value;
    }

    public void setParamTab(String value) {
        this.m_paramTab = value;
    }
}

