/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.history.CmsHistoryPrincipal;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLockFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsPrincipalWidget;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsChacc
extends CmsDialog {
    public static final int ACTION_ADDACE = 300;
    public static final int ACTION_DELETE = 200;
    public static final int ACTION_INTERNALUSE = 400;
    public static final String DIALOG_ADDACE = "addace";
    public static final String DIALOG_DELETE = "delete";
    public static final String DIALOG_INTERNALUSE = "internaluse";
    public static final String DIALOG_TYPE = "chacc";
    public static final String PARAM_INHERIT = "inherit";
    public static final String PARAM_INTERNAL = "internal";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_OVERWRITEINHERITED = "overwriteinherited";
    public static final String PARAM_RESPONSIBLE = "responsible";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_VIEW = "view";
    public static final String PERMISSION_ALLOW = "allow";
    public static final String PERMISSION_DENY = "deny";
    private static final Log LOG = CmsLog.getLog(CmsChacc.class);
    private static final String UNKNOWN_TYPE = "Unknown";
    private CmsPermissionSet m_curPermissions;
    private boolean m_editable;
    private List m_errorMessages = new ArrayList();
    private boolean m_inherit;
    private String m_paramName;
    private String m_paramType;
    private String m_paramUuid;
    private Set m_permissionKeys = CmsPermissionSet.getPermissionKeys();
    private boolean m_showInheritedPermissions;
    private String[] m_types = new String[]{"GROUP", "USER", "ROLE", "ALL_OTHERS", "OVERWRITE_ALL"};
    private int[] m_typesInt = new int[]{32, 16, 512, 128, 256};
    private String[] m_typesLocalized = new String[5];

    public CmsChacc(CmsJspActionElement jsp) {
        super(jsp);
        this.m_errorMessages.clear();
    }

    public CmsChacc(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static String buildSummaryDetailsButtons(CmsDialog wp) {
        StringBuffer result = new StringBuffer(512);
        result.append("<table border=\"0\">\n<tr>\n\t<td>");
        result.append(wp.key("GUI_PERMISSION_SELECT_VIEW_0"));
        result.append("</td>\n");
        String selectedView = wp.getSettings().getPermissionDetailView();
        result.append("\t<form action=\"").append(wp.getDialogUri()).append("\" method=\"post\" name=\"selectshortview\">\n");
        result.append("\t<td>\n");
        result.append("\t<input type=\"hidden\" name=\"");
        result.append(PARAM_VIEW);
        result.append("\" value=\"short\">\n");
        wp.setParamAction(null);
        result.append(wp.paramsAsHidden());
        result.append("\t<input  type=\"submit\" class=\"dialogbutton\" value=\"").append(wp.key("GUI_LABEL_SUMMARY_0")).append("\"");
        if (!"long".equals(selectedView)) {
            result.append(" disabled=\"disabled\"");
        }
        result.append(">\n");
        result.append("\t</td>\n");
        result.append("\t</form>\n\t<form action=\"").append(wp.getDialogUri()).append("\" method=\"post\" name=\"selectlongview\">\n");
        result.append("\t<td>\n");
        result.append("\t<input type=\"hidden\" name=\"");
        result.append(PARAM_VIEW);
        result.append("\" value=\"long\">\n");
        result.append(wp.paramsAsHidden());
        result.append("\t<input type=\"submit\" class=\"dialogbutton\" value=\"").append(wp.key("GUI_LABEL_DETAILS_0")).append("\"");
        if ("long".equals(selectedView)) {
            result.append(" disabled=\"disabled\"");
        }
        result.append(">\n");
        result.append("\t</td>\n\t</form>\n");
        result.append("</tr>\n</table>\n");
        return result.toString();
    }

    public boolean actionAddAce() {
        block13: {
            int arrayPosition;
            String name;
            String file;
            block12: {
                file = this.getParamResource();
                name = this.getParamName();
                String type = this.getParamType();
                arrayPosition = -1;
                try {
                    arrayPosition = Integer.parseInt(type);
                }
                catch (Exception e) {
                    if (!LOG.isInfoEnabled()) break block12;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            if (this.checkNewEntry(name, arrayPosition)) {
                String permissionString = "";
                if (this.getInheritOption() && this.getSettings().getUserSettings().getDialogPermissionsInheritOnFolder()) {
                    permissionString = "+i";
                }
                try {
                    this.checkLock(this.getParamResource());
                    if (name.equals(this.key("GUI_LABEL_ALLOTHERS_0"))) {
                        this.getCms().chacc(file, this.getTypes(false)[arrayPosition], "ALL_OTHERS", permissionString);
                    } else if (name.equals(this.key("GUI_LABEL_OVERWRITEALL_0"))) {
                        this.getCms().chacc(file, this.getTypes(false)[arrayPosition], "OVERWRITE_ALL", permissionString);
                    } else {
                        CmsRole role2;
                        if (this.getTypes(false)[arrayPosition].equalsIgnoreCase("ROLE") && (role2 = CmsRole.valueOfRoleName(name)) == null) {
                            for (CmsRole role2 : CmsRole.getSystemRoles()) {
                                if (!role2.getName(this.getLocale()).equalsIgnoreCase(name)) continue;
                                name = role2.getRoleName();
                                break;
                            }
                        }
                        this.getCms().chacc(file, this.getTypes(false)[arrayPosition], name, permissionString);
                    }
                    return true;
                }
                catch (CmsException e) {
                    this.m_errorMessages.add(e.getMessage());
                    if (!LOG.isErrorEnabled()) break block13;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    public boolean actionInternalUse(HttpServletRequest request) {
        String internal = request.getParameter(PARAM_INTERNAL);
        boolean internalValue = false;
        if (internal != null) {
            internalValue = true;
        }
        try {
            CmsResource resource = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
            int flags = resource.getFlags();
            flags = internalValue ? (flags |= 0x200) : (flags &= 0xFFFFFDFF);
            this.getCms().lockResource(this.getParamResource());
            this.getCms().chflags(this.getParamResource(), flags);
        }
        catch (CmsException e) {
            this.m_errorMessages.add(this.key("ERR_MODIFY_INTERNAL_FLAG_0"));
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public boolean actionModifyAce(HttpServletRequest request) {
        String file = this.getParamResource();
        String name = this.getParamName();
        String type = this.getParamType();
        String inherit = request.getParameter(PARAM_INHERIT);
        String overWriteInherited = request.getParameter(PARAM_OVERWRITEINHERITED);
        String responsible = request.getParameter(PARAM_RESPONSIBLE);
        Set<String> permissionKeys = CmsPermissionSet.getPermissionKeys();
        int allowValue = 0;
        int denyValue = 0;
        for (String key : permissionKeys) {
            int paramInt;
            String param;
            int value;
            block17: {
                value = CmsPermissionSet.getPermissionValue(key);
                try {
                    param = request.getParameter(value + PERMISSION_ALLOW);
                    paramInt = Integer.parseInt(param);
                    allowValue |= paramInt;
                }
                catch (Exception e) {
                    if (!LOG.isInfoEnabled()) break block17;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            try {
                param = request.getParameter(value + PERMISSION_DENY);
                paramInt = Integer.parseInt(param);
                denyValue |= paramInt;
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        try {
            List<CmsAccessControlEntry> allEntries = this.getCms().getAccessControlEntries(file, false);
            int flags = 0;
            for (int k = 0; k < allEntries.size(); ++k) {
                I_CmsPrincipal p;
                CmsAccessControlEntry curEntry = allEntries.get(k);
                String curType = this.getEntryType(curEntry.getFlags(), false);
                try {
                    p = CmsPrincipal.readPrincipalIncludingHistory(this.getCms(), curEntry.getPrincipal());
                }
                catch (CmsException e) {
                    p = null;
                }
                if (p != null && p.getName().equals(name) && curType.equals(type)) {
                    flags = curEntry.getFlags();
                    break;
                }
                if (p != null) continue;
                CmsRole role = CmsRole.valueOfId(curEntry.getPrincipal());
                if (role != null && name.equals(role.getRoleName())) {
                    flags = curEntry.getFlags();
                    break;
                }
                if ((!curEntry.getPrincipal().equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID) || !name.equals("ALL_OTHERS")) && (!curEntry.getPrincipal().equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID) || !name.equals("OVERWRITE_ALL"))) continue;
                flags = curEntry.getFlags();
                break;
            }
            flags = Boolean.valueOf(inherit).booleanValue() ? (flags |= 2) : (flags &= 0xFFFFFFFD);
            flags = Boolean.valueOf(overWriteInherited).booleanValue() ? (flags |= 4) : (flags &= 0xFFFFFFFB);
            flags = Boolean.valueOf(responsible).booleanValue() ? (flags |= 0x40) : (flags &= 0xFFFFFFBF);
            this.checkLock(this.getParamResource());
            if (name.equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.toString())) {
                this.getCms().chacc(file, type, "ALL_OTHERS", allowValue, denyValue, flags);
            } else if (name.equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID.toString())) {
                this.getCms().chacc(file, type, "OVERWRITE_ALL", allowValue, denyValue, flags);
            } else {
                this.getCms().chacc(file, type, name, allowValue, denyValue, flags);
            }
            return true;
        }
        catch (CmsException e) {
            this.m_errorMessages.add(this.key("ERR_CHACC_MODIFY_ENTRY_0"));
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public boolean actionRemoveAce() {
        String file = this.getParamResource();
        String name = this.getParamName();
        String type = this.getParamType();
        String uuid = this.getParamUuid();
        try {
            this.checkLock(this.getParamResource());
            CmsRole role = CmsRole.valueOfGroupName(name);
            if (role != null) {
                name = role.getFqn();
            }
            try {
                this.getCms().rmacc(file, type, name);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                this.getCms().rmacc(file, type, uuid);
            }
            return true;
        }
        catch (CmsException e) {
            this.m_errorMessages.add(this.key("ERR_CHACC_DELETE_ENTRY_0"));
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public String buildCurrentPermissions() {
        StringBuffer result;
        block2: {
            result = new StringBuffer(this.dialogToggleStart(this.key("GUI_PERMISSION_USER_0"), "userpermissions", this.getSettings().getUserSettings().getDialogExpandUserPermissions()));
            result.append(this.dialogWhiteBoxStart());
            try {
                result.append(this.buildPermissionEntryForm(this.getSettings().getUser().getId(), this.buildPermissionsForCurrentUser(), false, false));
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        result.append(this.dialogWhiteBoxEnd());
        result.append("</div>\n");
        return result.toString();
    }

    public String buildErrorMessages() {
        StringBuffer result = new StringBuffer(8);
        String errorMessages = this.getErrorMessagesString();
        if (!"".equals(errorMessages)) {
            result.append(this.dialogBlock(0, this.key("GUI_PERMISSION_ERROR_0"), true));
            result.append("<font color='red'>").append(errorMessages).append("</font>");
            result.append(this.dialogBlockEnd());
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildResponsibleList(boolean show) {
        String site;
        String resourceRootPath;
        CmsObject cms;
        HashMap<Object, String> responsibles;
        block29: {
            Object resource22;
            List<Object> parentResources;
            block28: {
                parentResources = new ArrayList();
                responsibles = new HashMap<Object, String>();
                cms = this.getCms();
                try {
                    parentResources = cms.readPath(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block28;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            resourceRootPath = cms.getRequestContext().addSiteRoot(this.getParamResource());
            site = cms.getRequestContext().getSiteRoot();
            cms.getRequestContext().setSiteRoot("");
            for (Object resource22 : parentResources) {
                try {
                    String string = ((CmsResource)resource22).getRootPath();
                    for (CmsAccessControlEntry ace : cms.getAccessControlEntries(string, false)) {
                        if (!ace.isResponsible()) continue;
                        try {
                            responsibles.put(CmsPrincipal.readPrincipalIncludingHistory(cms, ace.getPrincipal()), string);
                        }
                        catch (CmsDbEntryNotFoundException e) {
                            responsibles.put(ace.getPrincipal(), string);
                        }
                    }
                }
                catch (CmsException cmsException) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)cmsException.getLocalizedMessage());
                }
            }
            if (responsibles.size() != 0) break block29;
            resource22 = this.key("GUI_AVAILABILITY_NO_RESPONSIBLES_0");
            Object var15_20 = null;
            cms.getRequestContext().setSiteRoot(site);
            return resource22;
        }
        try {
            StringBuffer result = new StringBuffer(512);
            result.append(this.dialogToggleStart(this.key("GUI_AVAILABILITY_RESPONSIBLES_0"), "responsibles", show));
            result.append(this.dialogWhiteBoxStart());
            for (Map.Entry entry : responsibles.entrySet()) {
                block30: {
                    String resourceName;
                    String image;
                    String name;
                    String ou = null;
                    if (entry.getKey() instanceof I_CmsPrincipal) {
                        I_CmsPrincipal principal = (I_CmsPrincipal)entry.getKey();
                        if (principal instanceof CmsHistoryPrincipal) {
                            if (principal.isGroup()) {
                                name = ((CmsHistoryPrincipal)principal).getDescription() + " (" + principal.getSimpleName() + ")";
                                image = "commons/group.png";
                            } else {
                                name = ((CmsHistoryPrincipal)principal).getName();
                                image = "commons/user.png";
                            }
                        } else if (principal instanceof CmsGroup) {
                            name = ((CmsGroup)principal).getDescription(this.getLocale()) + " (" + principal.getSimpleName() + ")";
                            image = "commons/group.png";
                        } else {
                            name = ((CmsUser)principal).getFullName();
                            image = "commons/user.png";
                        }
                        ou = principal.getOuFqn();
                    } else {
                        CmsRole role = CmsRole.valueOfId((CmsUUID)entry.getKey());
                        if (role != null) {
                            name = role.getName(this.getLocale());
                            image = "commons/role.png";
                        } else {
                            name = entry.getKey().toString();
                            image = "explorer/project_none.gif";
                        }
                    }
                    result.append("<div class=\"dialogrow\"><img src=\"");
                    result.append(CmsChacc.getSkinUri());
                    result.append(image);
                    result.append("\" class='noborder' width='16' height='16' alt='Principal' title='Principal'>&nbsp;<span class=\"textbold\">");
                    result.append(name);
                    result.append("</span>");
                    if ("long".equals(this.getSettings().getPermissionDetailView()) && !resourceRootPath.equals(resourceName = (String)entry.getValue())) {
                        result.append("<div class=\"dialogpermissioninherit\">");
                        result.append(this.key("GUI_PERMISSION_INHERITED_FROM_1", new Object[]{resourceName}));
                        result.append("</div>");
                    }
                    try {
                        if (ou != null && OpenCms.getOrgUnitManager().getOrganizationalUnits(this.getCms(), "", true).size() > 1) {
                            result.append("<br>");
                            result.append("<img src='").append(CmsChacc.getSkinUri()).append("explorer/project_none.gif' class='noborder' width='16' height='16' >");
                            result.append("<img src='").append(CmsChacc.getSkinUri()).append("explorer/project_none.gif' class='noborder' width='16' height='16' >");
                            result.append("&nbsp;");
                            try {
                                result.append(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), ou).getDisplayName(this.getLocale()));
                            }
                            catch (CmsException e) {
                                result.append(ou);
                            }
                        }
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block30;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                result.append("</div>\n");
            }
            result.append(this.dialogWhiteBoxEnd());
            result.append("</div>\n");
            String string = result.toString();
            Object var15_21 = null;
            cms.getRequestContext().setSiteRoot(site);
            return string;
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            cms.getRequestContext().setSiteRoot(site);
            throw throwable;
        }
    }

    public String buildRightsList() {
        ArrayList<CmsAccessControlEntry> inheritedEntries;
        ArrayList<CmsAccessControlEntry> arrayList;
        HashMap<CmsUUID, String> parents;
        StringBuffer result;
        block11: {
            String path;
            block10: {
                List<Object> parentResources;
                block9: {
                    result = new StringBuffer(this.dialogToggleStart(this.key("GUI_PERMISSION_BEQUEATH_SUBFOLDER_0"), "inheritedpermissions", this.getSettings().getUserSettings().getDialogExpandInheritedPermissions() || this.getShowInheritedPermissions()));
                    parents = new HashMap<CmsUUID, String>();
                    path = CmsResource.getParentFolder(this.getParamResource());
                    parentResources = new ArrayList();
                    try {
                        parentResources = this.getCms().readPath(path, CmsResourceFilter.IGNORE_EXPIRATION);
                    }
                    catch (CmsException e) {
                        if (!LOG.isInfoEnabled()) break block9;
                        LOG.info((Object)e.getLocalizedMessage());
                    }
                }
                for (CmsResource cmsResource : parentResources) {
                    parents.put(cmsResource.getResourceId(), cmsResource.getRootPath());
                }
                arrayList = new ArrayList<CmsAccessControlEntry>();
                try {
                    for (CmsAccessControlEntry curEntry : this.getCms().getAccessControlEntries(this.getParamResource(), false)) {
                        if (curEntry.isInherited()) continue;
                        arrayList.add(curEntry);
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block10;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            inheritedEntries = new ArrayList<CmsAccessControlEntry>();
            try {
                for (CmsAccessControlEntry curEntry : this.getCms().getAccessControlEntries(path, true)) {
                    if (!"long".equals(this.getSettings().getPermissionDetailView())) continue;
                    inheritedEntries.add(curEntry);
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block11;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        result.append(this.dialogWhiteBox(0));
        result.append(this.buildInheritedList(inheritedEntries, parents));
        result.append(this.dialogWhiteBox(1));
        result.append("</div>");
        result.append(this.buildAddForm());
        result.append(this.buildResourceList(arrayList));
        return result.toString();
    }

    public CmsPermissionSet getCurPermissions() {
        return this.m_curPermissions;
    }

    public List getErrorMessages() {
        return this.m_errorMessages;
    }

    public String getErrorMessagesString() {
        StringBuffer errors = new StringBuffer(8);
        Iterator i = this.getErrorMessages().iterator();
        while (i.hasNext()) {
            errors.append((String)i.next());
            if (!i.hasNext()) continue;
            errors.append("<br>");
        }
        return errors.toString();
    }

    public String getParamName() {
        return this.m_paramName;
    }

    public String getParamType() {
        return this.m_paramType;
    }

    public String getParamUuid() {
        return this.m_paramUuid;
    }

    public boolean getShowInheritedPermissions() {
        return this.m_showInheritedPermissions;
    }

    public String htmlStart() {
        StringBuffer result = new StringBuffer(256);
        result.append(super.htmlStart());
        result.append(new CmsPrincipalWidget().getDialogIncludes(this.getCms(), null));
        result.append("<script type='text/javascript' >");
        result.append("typeField = '").append(PARAM_TYPE).append("';");
        result.append("</script>");
        return result.toString();
    }

    public void init() {
        String resName;
        block8: {
            String userName = this.getSettings().getUser().getName();
            if (this.m_typesLocalized[0] == null) {
                this.m_typesLocalized[0] = this.key("GUI_LABEL_GROUP_0");
                this.m_typesLocalized[1] = this.key("GUI_LABEL_USER_0");
                this.m_typesLocalized[2] = this.key("GUI_LABEL_ROLE_0");
                this.m_typesLocalized[3] = this.key("GUI_LABEL_ALLOTHERS_0");
                this.m_typesLocalized[4] = this.key("GUI_LABEL_OVERWRITEALL_0");
            }
            this.setEditable(false);
            this.setInheritOption(false);
            resName = this.getParamResource();
            try {
                this.setCurPermissions(this.getCms().getPermissions(this.getParamResource(), userName));
                CmsResource resource = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
                if (resource.isFolder()) {
                    this.setInheritOption(true);
                    if (!resName.endsWith("/")) {
                        resName = resName + "/";
                    }
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block8;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        if (!this.getCms().getRequestContext().getCurrentProject().isOnlineProject() && this.getCms().isInsideCurrentProject(resName) && (OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.VFS_MANAGER) || (this.m_curPermissions.getAllowedPermissions() & 8) > 0 && (this.m_curPermissions.getDeniedPermissions() & 8) <= 0)) {
            if (this.isBlockingLocked()) {
                this.m_errorMessages.add(this.key("ERR_PERMISSION_BLOCKING_LOCKS_0"));
            } else {
                this.setEditable(true);
            }
        }
    }

    public void setParamName(String value) {
        this.m_paramName = value;
    }

    public void setParamType(String value) {
        this.m_paramType = value;
    }

    public void setParamUuid(String uuid) {
        this.m_paramUuid = uuid;
    }

    protected boolean checkNewEntry(String name, int arrayPosition) {
        this.m_errorMessages.clear();
        boolean inArray = false;
        if (this.getTypes(false)[arrayPosition] != null) {
            inArray = true;
        }
        if (!inArray) {
            this.m_errorMessages.add(this.key("ERR_PERMISSION_SELECT_TYPE_0"));
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            this.m_errorMessages.add(this.key("ERR_MISSING_GROUP_OR_USER_NAME_0"));
        }
        return this.m_errorMessages.size() <= 0;
    }

    protected String getConnectedResource(CmsAccessControlEntry entry, Map parents) {
        CmsUUID resId = entry.getResource();
        String resName = (String)parents.get(resId);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(resName)) {
            return resName;
        }
        return resId.toString();
    }

    protected boolean getEditable() {
        return this.m_editable;
    }

    protected String getEntryType(int flags, boolean all) {
        for (int i = 0; i < this.getTypes(all).length; ++i) {
            if ((flags & this.getTypesInt()[i]) <= 0) continue;
            return this.getTypes(all)[i];
        }
        return UNKNOWN_TYPE;
    }

    protected int getEntryTypeInt(int flags) {
        for (int i = 0; i < this.getTypesInt().length; ++i) {
            if ((flags & this.getTypesInt()[i]) <= 0) continue;
            return i;
        }
        return -1;
    }

    protected boolean getInheritOption() {
        return this.m_inherit;
    }

    protected String[] getTypes(boolean all) {
        if (!all) {
            String[] array = new String[3];
            return Arrays.asList(this.m_types).subList(0, 3).toArray(array);
        }
        return this.m_types;
    }

    protected int[] getTypesInt() {
        return this.m_typesInt;
    }

    protected String[] getTypesLocalized() {
        return this.m_typesLocalized;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        String detail = request.getParameter(PARAM_VIEW);
        if (detail != null) {
            settings.setPermissionDetailView(detail);
            this.setShowInheritedPermissions(true);
        }
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(0);
        } else if ("set".equals(this.getParamAction())) {
            this.setAction(5);
        } else if (DIALOG_DELETE.equals(this.getParamAction())) {
            this.setAction(200);
        } else if (DIALOG_ADDACE.equals(this.getParamAction())) {
            this.setAction(300);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else if (DIALOG_INTERNALUSE.equals(this.getParamAction())) {
            this.setAction(400);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_PERMISSION_CHANGE_1", new Object[]{CmsResource.getName(this.getParamResource())}));
        }
    }

    protected boolean isAllowed(CmsPermissionSet p, int value) {
        return (p.getAllowedPermissions() & value) > 0;
    }

    protected boolean isDenied(CmsPermissionSet p, int value) {
        return (p.getDeniedPermissions() & value) > 0;
    }

    protected boolean isOverWritingInherited(int flags) {
        return (flags & 4) > 0;
    }

    protected boolean isResponsible(int flags) {
        return (flags & 0x40) > 0;
    }

    protected void setCurPermissions(CmsPermissionSet value) {
        this.m_curPermissions = value;
    }

    protected void setEditable(boolean value) {
        this.m_editable = value;
    }

    protected void setInheritOption(boolean value) {
        this.m_inherit = value;
    }

    protected void setShowInheritedPermissions(boolean showInheritedPermissions) {
        this.m_showInheritedPermissions = showInheritedPermissions;
    }

    private String buildAddForm() {
        StringBuffer result = new StringBuffer(256);
        if (this.getEditable()) {
            result.append(this.dialogSpacer());
            result.append(this.dialogBlockStart(this.key("GUI_PERMISSION_ADD_ACE_0")));
            ArrayList<String> options = new ArrayList<String>();
            ArrayList<String> optionValues = new ArrayList<String>();
            for (int i = 0; i < this.getTypes(false).length - 1 * (this.isRoleEditable() ? 0 : 1); ++i) {
                options.add(this.getTypesLocalized()[i]);
                optionValues.add(Integer.toString(i));
            }
            result.append("<form action=\"").append(this.getDialogUri()).append("\" method=\"post\" name=\"add\" class=\"nomargin\">\n");
            this.setParamAction(DIALOG_ADDACE);
            this.setParamType(null);
            this.setParamName(null);
            result.append(this.paramsAsHidden());
            result.append("<table border=\"0\" width=\"100%\">\n");
            result.append("<tr>\n");
            result.append("\t<td>").append(this.buildSelect("name=\"type\"", options, optionValues, -1)).append("</td>\n");
            result.append("\t<td class=\"maxwidth\"><input type=\"text\" class=\"maxwidth\" name=\"");
            result.append(PARAM_NAME);
            result.append("\" value=\"\"></td>\n");
            result.append("<td><span style='display: block; height: 1px; width: 10px;'/></td>");
            result.append(this.button(new CmsPrincipalWidget().getButtonJs(PARAM_NAME, "add"), null, "principal", "GUI_DIALOG_BUTTON_SEARCH_0", this.getSettings().getUserSettings().getEditorButtonStyle()));
            result.append(this.button("javascript:document.forms['add'].submit();", null, "new", "GUI_LABEL_ADD_0", this.getSettings().getUserSettings().getEditorButtonStyle()));
            result.append("</tr>\n");
            result.append("</form>\n");
            result.append("</table>\n");
            result.append(this.dialogBlockEnd());
        }
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer buildInheritedList(ArrayList entries, Map parents) {
        StringBuffer result = new StringBuffer(32);
        String view = this.getSettings().getPermissionDetailView();
        if ("long".equals(view)) {
            for (CmsAccessControlEntry curEntry : entries) {
                result.append(this.buildPermissionEntryForm(curEntry, false, true, this.getConnectedResource(curEntry, parents)));
            }
            return result;
        } else {
            try {
                CmsAccessControlList acList = this.getCms().getAccessControlList(CmsResource.getParentFolder(this.getParamResource()), false);
                for (CmsUUID principalId : acList.getPrincipals()) {
                    if (principalId.equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID)) continue;
                    CmsPermissionSetCustom permissions = acList.getPermissions(principalId);
                    result.append(this.buildPermissionEntryForm(principalId, permissions, false, true));
                }
                return result;
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) return result;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        return result;
    }

    private String buildInternalForm() {
        StringBuffer result = new StringBuffer(128);
        CmsResource resource = null;
        boolean internal = false;
        try {
            resource = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
            internal = resource.isInternal();
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        if (resource != null && resource.isFile()) {
            result.append("<form action=\"").append(this.getDialogUri()).append("\" method=\"post\" name=\"internal\" class=\"nomargin\">\n");
            result.append("<table border=\"0\" width=\"100%\">\n");
            result.append("<tr>\n");
            result.append("\t<td class=\"dialogpermissioncell\">").append(this.key("GUI_PERMISSION_INTERNAL_0"));
            result.append(" <input type=\"checkbox\" name=\"");
            result.append(PARAM_INTERNAL);
            result.append("\" value=\"true\"");
            if (internal) {
                result.append(" checked=\"checked\"");
            }
            if (!this.getEditable()) {
                result.append(" disabled=\"disabled\"");
            }
            result.append(" ></td>\n");
            if (this.getEditable()) {
                result.append("<td><input  type=\"submit\" class=\"dialogbutton\" value=\"").append(this.key("GUI_LABEL_SET_0")).append("\">");
            }
            result.append("</td>\n");
            result.append("</tr>\n");
            result.append("</table>\n");
            this.setParamAction(DIALOG_INTERNALUSE);
            this.setParamType(null);
            this.setParamName(null);
            result.append(this.paramsAsHidden());
            result.append("</form>\n");
        }
        return result.toString();
    }

    private StringBuffer buildPermissionEntryForm(CmsAccessControlEntry entry, boolean editable, boolean extendedView, String inheritRes) {
        String name;
        String niceName;
        I_CmsPrincipal principal;
        StringBuffer result = new StringBuffer(512);
        try {
            principal = CmsPrincipal.readPrincipalIncludingHistory(this.getCms(), entry.getPrincipal());
        }
        catch (CmsException e) {
            principal = null;
        }
        String id = principal != null ? principal.getName() : entry.getPrincipal().toString();
        String ou = null;
        int flags = 0;
        if (principal != null && principal instanceof CmsHistoryPrincipal) {
            if (principal.isGroup()) {
                niceName = OpenCms.getWorkplaceManager().translateGroupName(principal.getName(), false);
                name = this.key("GUI_ORGUNIT_DISPLAY_NAME_2", new Object[]{((CmsHistoryPrincipal)principal).getDescription(), niceName});
                ou = CmsOrganizationalUnit.getParentFqn(id);
                flags = 32;
            } else {
                name = ((CmsHistoryPrincipal)principal).getName();
                ou = CmsOrganizationalUnit.getParentFqn(id);
                flags = 16;
            }
        } else if (principal != null && principal.isGroup()) {
            niceName = OpenCms.getWorkplaceManager().translateGroupName(principal.getName(), false);
            name = this.key("GUI_ORGUNIT_DISPLAY_NAME_2", new Object[]{((CmsGroup)principal).getDescription(this.getLocale()), niceName});
            ou = CmsOrganizationalUnit.getParentFqn(id);
            flags = 32;
        } else if (principal != null && principal.isUser()) {
            name = ((CmsUser)principal).getFullName();
            ou = CmsOrganizationalUnit.getParentFqn(id);
            flags = 16;
        } else if (id != null && id.equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.toString())) {
            name = this.key("GUI_LABEL_ALLOTHERS_0");
            flags = 128;
        } else if (id != null && id.equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID.toString())) {
            name = this.key("GUI_LABEL_OVERWRITEALL_0");
            flags = 256;
        } else {
            CmsRole role = CmsRole.valueOfId(entry.getPrincipal());
            if (role != null) {
                name = role.getName(this.getLocale());
                id = role.getRoleName();
                flags = 512;
            } else {
                name = entry.getPrincipal().toString();
            }
        }
        if (flags > 0 && (entry.getFlags() & flags) == 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle(this.getLocale()).key("ERR_INVALID_ACE_1", entry.toString()));
            }
            entry = new CmsAccessControlEntry(entry.getResource(), entry.getPrincipal(), entry.getAllowedPermissions(), entry.getDeniedPermissions(), entry.getFlags() | flags);
        } else if (entry.getFlags() < 16) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle(this.getLocale()).key("ERR_INVALID_ACE_1", entry.toString()));
            }
            entry = new CmsAccessControlEntry(entry.getResource(), entry.getPrincipal(), entry.getAllowedPermissions(), entry.getDeniedPermissions(), entry.getFlags() | 0x20);
        }
        String type = this.getEntryType(entry.getFlags(), false);
        if (id == null) {
            id = "";
        }
        this.setParamType(type);
        this.setParamName(id);
        this.setParamUuid(entry.getPrincipal().toString());
        String idValue = type + id + entry.getResource();
        int typeInt = this.getEntryTypeInt(entry.getFlags());
        String typeLocalized = UNKNOWN_TYPE;
        if (typeInt >= 0) {
            typeLocalized = this.getTypesLocalized()[typeInt];
        }
        String typeImg = this.getTypes(true)[0];
        if (typeInt >= 0) {
            typeImg = this.getEntryType(entry.getFlags(), true).toLowerCase();
        }
        CmsPermissionSet permissions = entry.getPermissions();
        String disabled = "";
        if (!editable || typeInt < 0) {
            disabled = " disabled=\"disabled\"";
        }
        if (!id.equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID.toString())) {
            block51: {
                result.append(this.dialogRow(0));
                if (extendedView) {
                    result.append("<a href=\"javascript:toggleDetail('").append(idValue).append("');\">");
                    result.append("<img src=\"").append(CmsChacc.getSkinUri()).append("commons/plus.png\" class=\"noborder\" id=\"ic-").append(idValue).append("\"></a>");
                } else {
                    result.append("<img src='").append(CmsChacc.getSkinUri()).append("explorer/project_none.gif' class='noborder' width='16' height='16' >");
                }
                result.append("<img src=\"").append(CmsChacc.getSkinUri()).append("commons/");
                result.append(typeImg);
                result.append(".png\" class=\"noborder\" width=\"16\" height=\"16\" alt=\"");
                result.append(typeLocalized);
                result.append("\" title=\"");
                result.append(typeLocalized);
                result.append("\">&nbsp;<span class=\"textbold\">");
                result.append(name);
                result.append("</span>");
                if (extendedView) {
                    result.append("&nbsp;(").append(entry.getPermissions().getPermissionString()).append(")");
                }
                try {
                    if (ou != null && OpenCms.getOrgUnitManager().getOrganizationalUnits(this.getCms(), "", true).size() > 1) {
                        result.append("<br>");
                        result.append("<img src='").append(CmsChacc.getSkinUri()).append("explorer/project_none.gif' class='noborder' width='16' height='16' >");
                        result.append("<img src='").append(CmsChacc.getSkinUri()).append("explorer/project_none.gif' class='noborder' width='16' height='16' >");
                        result.append("&nbsp;");
                        try {
                            result.append(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), ou).getDisplayName(this.getLocale()));
                        }
                        catch (CmsException e) {
                            result.append(ou);
                        }
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block51;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            result.append(this.dialogRow(1));
            if (extendedView) {
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(inheritRes)) {
                    result.append("<div class=\"dialogpermissioninherit\">");
                    result.append("<img src='").append(CmsChacc.getSkinUri()).append("explorer/project_none.gif' class='noborder' width='16' height='16' >");
                    result.append("&nbsp;");
                    result.append(this.key("GUI_PERMISSION_INHERITED_FROM_1", new Object[]{inheritRes}));
                    result.append("</div>\n");
                }
                result.append("<div id =\"").append(idValue).append("\" class=\"hide\">");
            }
            result.append("<table class=\"dialogpermissiondetails\">\n");
            if (editable) {
                result.append("<form action=\"").append(this.getDialogUri()).append("\" method=\"post\" class=\"nomargin\" name=\"set").append(idValue).append("\">\n");
                this.setParamAction("set");
                result.append(this.paramsAsHidden());
            } else {
                result.append("<form class=\"nomargin\">\n");
            }
            result.append("<tr>\n");
            result.append("\t<td class=\"dialogpermissioncell\"><span class=\"textbold\" unselectable=\"on\">");
            result.append(this.key("GUI_PERMISSION_0")).append("</span></td>\n");
            result.append("\t<td class=\"dialogpermissioncell textcenter\"><span class=\"textbold\" unselectable=\"on\">");
            result.append(this.key("GUI_PERMISSION_ALLOWED_0")).append("</span></td>\n");
            result.append("\t<td class=\"dialogpermissioncell textcenter\"><span class=\"textbold\" unselectable=\"on\">");
            result.append(this.key("GUI_PERMISSION_DENIED_0")).append("</span></td>\n");
            result.append("</tr>");
            for (String key : this.m_permissionKeys) {
                int value = CmsPermissionSet.getPermissionValue(key);
                String keyMessage = this.key(key);
                result.append("<tr>\n");
                result.append("\t<td class=\"dialogpermissioncell\">").append(keyMessage).append("</td>\n");
                result.append("\t<td class=\"dialogpermissioncell textcenter\"><input type=\"checkbox\" name=\"");
                result.append(value).append(PERMISSION_ALLOW).append("\" value=\"").append(value).append("\"").append(disabled);
                if (this.isAllowed(permissions, value)) {
                    result.append(" checked=\"checked\"");
                }
                result.append("></td>\n");
                result.append("\t<td class=\"dialogpermissioncell textcenter\"><input type=\"checkbox\" name=\"");
                result.append(value).append(PERMISSION_DENY).append("\" value=\"").append(value).append("\"").append(disabled);
                if (this.isDenied(permissions, value)) {
                    result.append(" checked=\"checked\"");
                }
                result.append("></td>\n");
                result.append("</tr>\n");
            }
            if (editable) {
                if (!id.equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.toString())) {
                    result.append("<tr>\n");
                    result.append("\t<td class=\"dialogpermissioncell\">").append(this.key("GUI_LABEL_RESPONSIBLE_0")).append("</td>\n");
                    result.append("\t<td class=\"dialogpermissioncell textcenter\">");
                    result.append("<input type=\"checkbox\" name=\"").append(PARAM_RESPONSIBLE).append("\" value=\"true\"").append(disabled);
                    if (this.isResponsible(entry.getFlags())) {
                        result.append(" checked=\"checked\"");
                    }
                    result.append("></td>\n");
                    result.append("\t<td class=\"dialogpermissioncell\">&nbsp;</td>\n");
                    result.append("</tr>\n");
                }
                result.append("<tr>\n");
                result.append("\t<td class=\"dialogpermissioncell\">").append(this.key("GUI_PERMISSION_OVERWRITE_INHERITED_0")).append("</td>\n");
                result.append("\t<td class=\"dialogpermissioncell textcenter\">");
                result.append("<input type=\"checkbox\" name=\"").append(PARAM_OVERWRITEINHERITED).append("\" value=\"true\"").append(disabled);
                if (this.isOverWritingInherited(entry.getFlags())) {
                    result.append(" checked=\"checked\"");
                }
                result.append("></td>\n");
                result.append("\t<td class=\"dialogpermissioncell\">&nbsp;</td>\n");
                result.append("</tr>\n");
                if (this.getInheritOption()) {
                    result.append("<tr>\n");
                    result.append("\t<td class=\"dialogpermissioncell\">").append(this.key("GUI_PERMISSION_INHERIT_ON_SUBFOLDERS_0")).append("</td>\n");
                    result.append("\t<td class=\"dialogpermissioncell textcenter\">");
                    result.append("<input type=\"checkbox\" name=\"").append(PARAM_INHERIT).append("\" value=\"true\"").append(disabled);
                    if (entry.isInheriting()) {
                        result.append(" checked=\"checked\"");
                    }
                    result.append("></td>\n");
                    result.append("\t<td class=\"dialogpermissioncell\">&nbsp;</td>\n");
                    result.append("</tr>\n");
                }
                result.append("<tr>\n");
                result.append("\t<td>&nbsp;</td>\n");
                result.append("\t<td class=\"textcenter\"><input class=\"dialogbutton\" type=\"submit\" value=\"").append(this.key("GUI_LABEL_SET_0")).append("\"></form></td>\n");
                result.append("\t<td class=\"textcenter\">\n");
                result.append("\t\t<form class=\"nomargin\" action=\"").append(this.getDialogUri()).append("\" method=\"post\" name=\"delete").append(idValue).append("\">\n");
                this.setParamAction(DIALOG_DELETE);
                result.append(this.paramsAsHidden());
                result.append("\t\t<input class=\"dialogbutton\" type=\"submit\" value=\"").append(this.key("GUI_LABEL_DELETE_0")).append("\">\n");
                result.append("\t\t</form>\n");
                result.append("\t</td>\n");
                result.append("</tr>\n");
            } else {
                result.append("</form>\n");
            }
            result.append("</table>\n");
            if (extendedView) {
                result.append("</div>");
            }
        } else {
            result.append(this.dialogRow(0));
            result.append("<table style='margin-left: 13px;' class=\"dialogpermissiondetails\">\n");
            result.append("<tr>\n");
            result.append("\t<td style=\"width: 280px;\"><span class=\"textbold\" unselectable=\"on\">");
            result.append("<img src=\"").append(CmsChacc.getSkinUri()).append("commons/");
            result.append(typeImg);
            result.append(".png\" class=\"noborder\" width=\"16\" height=\"16\" alt=\"");
            result.append(typeLocalized);
            result.append("\" title=\"");
            result.append(typeLocalized);
            result.append("\">&nbsp;<span class=\"textbold\">");
            result.append(name);
            result.append("</span></td>\n");
            result.append("\t<td class=\"dialogpermissioncell textcenter\"><span class=\"textbold\" unselectable=\"on\">");
            if (editable) {
                result.append("\t\t<form class=\"nomargin\" action=\"").append(this.getDialogUri()).append("\" method=\"post\" name=\"delete").append(idValue).append("\">\n");
                this.setParamAction(DIALOG_DELETE);
                result.append(this.paramsAsHidden());
                result.append("\t\t<input class=\"dialogbutton\" type=\"submit\" value=\"").append(this.key("GUI_LABEL_DELETE_0")).append("\">\n");
                result.append("\t\t</form>\n");
            }
            result.append("</td>\n");
            result.append("</tr>");
            result.append("</table>\n");
            result.append(this.dialogRow(1));
        }
        return result;
    }

    private StringBuffer buildPermissionEntryForm(CmsUUID id, CmsPermissionSet curSet, boolean editable, boolean extendedView) {
        String fileName = this.getParamResource();
        int flags = 0;
        try {
            I_CmsPrincipal p;
            try {
                p = CmsPrincipal.readPrincipalIncludingHistory(this.getCms(), id);
            }
            catch (CmsException e) {
                p = null;
            }
            if (p != null && p.isGroup()) {
                flags = 32;
            } else if (p != null && p.isUser()) {
                flags = 16;
            } else if (p == null && id.equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID)) {
                flags = 128;
            } else if (p == null && id.equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID)) {
                flags = 256;
            } else {
                CmsRole role = CmsRole.valueOfId(id);
                if (role != null) {
                    flags = 512;
                }
            }
            CmsResource res = this.getCms().readResource(fileName, CmsResourceFilter.ALL);
            CmsAccessControlEntry entry = new CmsAccessControlEntry(res.getResourceId(), id, curSet, flags);
            return this.buildPermissionEntryForm(entry, editable, extendedView, null);
        }
        catch (CmsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e.getLocalizedMessage());
            }
            return new StringBuffer("");
        }
    }

    private CmsPermissionSet buildPermissionsForCurrentUser() throws CmsException {
        CmsResourceUtil resUtil = new CmsResourceUtil(this.getCms(), this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL));
        return resUtil.getPermissionSet();
    }

    private StringBuffer buildResourceList(ArrayList entries) {
        StringBuffer result = new StringBuffer(256);
        Iterator i = entries.iterator();
        boolean hasEntries = i.hasNext();
        if (hasEntries || !this.getInheritOption()) {
            result.append(this.dialogSubheadline(this.key("GUI_PERMISSION_TITLE_0")));
        }
        result.append(this.buildInternalForm());
        if (hasEntries) {
            result.append(this.dialogSpacer());
            result.append(this.dialogWhiteBox(0));
            while (i.hasNext()) {
                CmsAccessControlEntry curEntry = (CmsAccessControlEntry)i.next();
                result.append(this.buildPermissionEntryForm(curEntry, this.getEditable(), false, null));
                if (!i.hasNext()) continue;
                result.append(this.dialogSeparator());
            }
            result.append(this.dialogWhiteBox(1));
        }
        return result;
    }

    private boolean isBlockingLocked() {
        boolean result;
        block2: {
            result = true;
            CmsLockFilter blockingFilter = CmsLockFilter.FILTER_ALL;
            blockingFilter = blockingFilter.filterNotLockableByUser(this.getCms().getRequestContext().getCurrentUser());
            try {
                List<String> blocking = this.getCms().getLockedResources(this.getParamResource(), blockingFilter);
                result = blocking.size() > 0;
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private boolean isRoleEditable() {
        return OpenCms.getRoleManager().hasRoleForResource(this.getCms(), CmsRole.VFS_MANAGER, this.getParamResource()) && this.getParamResource().startsWith("/system/") && this.getParamResource().startsWith("/system/");
    }
}

