/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLockFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsMultiDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.I_CmsDialogHandler;
import org.opencms.workplace.commons.CmsLockedResourcesList;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.CmsListExplorerColumn;

public class CmsLock
extends CmsMultiDialog
implements I_CmsDialogHandler {
    public static final int ACTION_SUBMIT_NOCONFIRMATION = 200;
    public static final String DIALOG_SUBMIT_NOCONFIRMATION = "submitnoconfirmation";
    public static final String DIALOG_TYPE_LOCK = "lock";
    public static final String DIALOG_TYPE_LOCKCHANGE = "lockchange";
    public static final String DIALOG_TYPE_LOCKS = "locks";
    public static final String DIALOG_TYPE_UNLOCK = "unlock";
    public static final String PARAM_INCLUDERELATED = "includerelated";
    public static final String PARAM_PROJECT_ID = "projectid";
    public static final String PARAM_PUBLISHSIBLINGS = "publishsiblings";
    public static final String PARAM_SHOWOWNLOCKS = "showownlocks";
    public static final String PARAM_SOURCE_DIALOG = "sourcedialog";
    public static final String PARAM_SUBRESOURCES = "subresources";
    public static final int TYPE_LOCK = 1;
    public static final int TYPE_LOCKCHANGE = 2;
    public static final int TYPE_LOCKS = 4;
    public static final int TYPE_UNLOCK = 3;
    public static final String URI_LOCK_DIALOG = "/system/workplace/commons/lock_standard.jsp";
    public static final String URI_LOCKCHANGE_DIALOG = "/system/workplace/commons/lockchange_standard.jsp";
    public static final String URI_LOCKS_DIALOG = "/system/workplace/commons/locks.jsp";
    public static final String URI_UNLOCK_DIALOG = "/system/workplace/commons/unlock_standard.jsp";
    private static final Log LOG = CmsLog.getLog(CmsLock.class);
    private CmsLockFilter m_blockingFilter;
    private int m_blockingLocks = -1;
    private List m_lockedResources;
    private CmsLockFilter m_nonBlockingFilter;
    private String m_paramIncluderelated;
    private String m_paramProjectid;
    private String m_paramShowownlocks;

    public CmsLock() {
        super(null);
    }

    public CmsLock(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsLock(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static int getDialogAction(CmsObject cms) {
        String fileName = CmsResource.getName(cms.getRequestContext().getUri());
        if (fileName == null) {
            return 4;
        }
        if (fileName.equalsIgnoreCase("lock.jsp")) {
            return 1;
        }
        if (fileName.indexOf("change") != -1) {
            return 2;
        }
        if (fileName.indexOf(DIALOG_TYPE_UNLOCK) != -1) {
            return 3;
        }
        return 4;
    }

    public void actionToggleLock() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            if (this.performDialogOperation()) {
                this.actionCloseDialog();
            } else {
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public void addConfigurationParameter(String paramName, String paramValue) {
    }

    public String buildDefaultConfirmationJS() {
        StringBuffer html = new StringBuffer(512);
        html.append("<script type='text/javascript'><!--\n");
        html.append("function setConfirmationMessage(locks, blockinglocks) {\n");
        html.append("\tvar confMsg = document.getElementById('conf-msg');\n");
        html.append("\tif (locks > -1) {\n");
        if (!this.getSettings().getUserSettings().getDialogShowLock() && CmsLock.getDialogAction(this.getCms()) != 4) {
            html.append("\t\tif (blockinglocks == 0) {\n");
            html.append("\t\t\tsubmitAction('");
            html.append("ok");
            html.append("', null, 'main');\n");
            html.append("\t\t\tdocument.forms['main'].submit();\n");
            html.append("\t\t\treturn;\n");
            html.append("\t\t}\n");
        }
        html.append("\t\tdocument.getElementById('lock-body-id').className = '';\n");
        html.append("\t\tif (locks > '0') {\n");
        html.append("\t\t\tshowAjaxReportContent();\n");
        html.append("\t\t\tconfMsg.innerHTML = '");
        html.append(this.getConfirmationMessage(false));
        html.append("';\n");
        html.append("\t\t} else {\n");
        html.append("\t\t\tshowAjaxOk();\n");
        html.append("\t\t\tconfMsg.innerHTML = '");
        html.append(this.getConfirmationMessage(true));
        html.append("';\n");
        html.append("\t\t}\n");
        html.append("\t} else {\n");
        html.append("\t\tconfMsg.innerHTML = '");
        html.append(this.key("GUI_AJAX_REPORT_WAIT_0"));
        html.append("';\n");
        html.append("\t}\n");
        html.append("}\n");
        html.append("// -->\n");
        html.append("</script>\n");
        return html.toString();
    }

    public String buildIncludeJs() {
        StringBuffer html = new StringBuffer(512);
        html.append("<script type='text/javascript' src='");
        html.append(CmsWorkplace.getSkinUri());
        html.append("commons/ajax.js'></script>\n");
        html.append("<script type='text/javascript' src='");
        html.append(CmsWorkplace.getSkinUri());
        html.append("editors/xmlcontent/help.js'></script>\n");
        html.append("<script type='text/javascript' src='");
        html.append(CmsWorkplace.getSkinUri());
        html.append("admin/javascript/general.js'></script>\n");
        html.append("<script type='text/javascript' src='");
        html.append(CmsWorkplace.getSkinUri());
        html.append("admin/javascript/list.js'></script>\n");
        html.append("<script type='text/javascript'><!--\n");
        html.append("function showAjaxOk() {\n");
        html.append("\tdocument.getElementById('ajaxreport-img').src = '");
        html.append(CmsWorkplace.getSkinUri());
        html.append("commons/ok.png';\n");
        html.append("\tdocument.getElementById('ajaxreport-txt').innerHTML = '");
        html.append(this.key("GUI_OPERATION_NO_LOCKS_0"));
        html.append("';\n");
        html.append("}\n");
        html.append("var ajaxReportContent = '';\n");
        html.append("var ajaxWaitMessage = '");
        html.append(CmsStringUtil.escapeJavaScript(this.buildAjaxWaitMessage()));
        html.append("';\n");
        html.append("function showAjaxReportContent() {\n");
        html.append("\tif (ajaxReportContent != '') {\n");
        html.append("\t\tdocument.getElementById('ajaxreport').innerHTML = ajaxReportContent;\n");
        html.append("\t}\n");
        html.append("}\n");
        html.append("function doReportUpdate(msg, state) {\n");
        html.append("\tvar img = state + '.png';\n");
        html.append("\tvar txt = '';\n");
        html.append("\tvar locks = -1;\n");
        html.append("\tvar blockinglocks = -1;\n");
        html.append("\tvar elem = document.getElementById('ajaxreport');\n");
        html.append("\tif (state != 'ok') {\n");
        html.append("\t\tif (state != 'wait') {\n");
        html.append("\t\t\tdocument.getElementById('lock-body-id').className = '';\n");
        html.append("\t\t}\n");
        html.append("\t\tvar img = state + '.png';\n");
        html.append("\t\tvar txt = msg;\n");
        html.append("\t\tif (state == 'fatal') {\n");
        html.append("\t\t\timg = 'error.png';\n");
        html.append("\t\t\ttxt = '");
        html.append(this.key("GUI_AJAX_REPORT_GIVEUP_0"));
        html.append("';\n");
        html.append("\t\t} else if (state == 'wait') {\n");
        html.append("\t\t\timg = 'wait.gif';\n");
        html.append("\t\t\ttxt = '");
        html.append(this.key("GUI_AJAX_REPORT_WAIT_0"));
        html.append("'\n");
        html.append("\t\t} else if (state == 'error') {\n");
        html.append("\t\t\ttxt = '");
        html.append(this.key("GUI_AJAX_REPORT_ERROR_0"));
        html.append("' + msg;\n");
        html.append("\t\t}\n");
        html.append("\t\tdocument.getElementById('ajaxreport-img').src = '");
        html.append(CmsWorkplace.getSkinUri());
        html.append("commons/' + img;\n");
        html.append("\t\tdocument.getElementById('ajaxreport-txt').innerHTML = txt;\n");
        html.append("\t} else {\n");
        html.append("\t\telem.innerHTML = elem.innerHTML + msg.substring(0, 120);\n");
        html.append("\t\tajaxReportContent = msg;\n");
        html.append("\t}\n");
        html.append("\tif (txt != '') {\n");
        html.append("\t}\n");
        html.append("\tif (state == 'ok') {\n");
        html.append("\t\tlocks = document.forms['main'].locks.value;\n");
        html.append("\t\tblockinglocks = document.forms['main'].blockinglocks.value;\n");
        html.append("\t}\n");
        html.append("\tsetConfirmationMessage(locks, blockinglocks);\n");
        html.append("}\n");
        html.append("// -->\n");
        html.append("</script>\n");
        return html.toString();
    }

    public String buildLockRequest() {
        return this.buildLockRequest(0, false);
    }

    public String buildLockRequest(int hiddenTimeout, boolean includeRelated) {
        StringBuffer html = new StringBuffer(512);
        html.append("<script type='text/javascript'><!--\n");
        html.append("makeRequest('");
        html.append(this.getJsp().link("/system/workplace/commons/report-locks.jsp"));
        html.append("', '");
        html.append("resourcelist");
        html.append("=");
        html.append(this.getParamResourcelist());
        html.append("&");
        html.append("resource");
        html.append("=");
        html.append(this.getParamResource());
        html.append("&");
        html.append(PARAM_INCLUDERELATED);
        html.append("=");
        html.append(includeRelated);
        html.append("', 'doReportUpdate');\n");
        html.append("function showLockDialog() {\n");
        html.append("\tdocument.getElementById('lock-body-id').className = '';\n");
        html.append("}\n");
        html.append("setTimeout('showLockDialog()', " + hiddenTimeout + ");\n");
        html.append("// -->\n");
        html.append("</script>\n");
        return html.toString();
    }

    public String buildReport() throws JspException, ServletException, IOException {
        ArrayList lockedResources = Boolean.valueOf(this.getParamShowownlocks()) != false ? this.getLockedResources() : new ArrayList(this.getBlockingLockedResources());
        Collections.sort(lockedResources);
        HashMap<String, String> lockParams = new HashMap<String, String>();
        if (this.getParamResource() != null) {
            lockParams.put("resource", this.getParamResource());
        }
        if (this.getParamResourcelist() != null) {
            lockParams.put("resourcelist", this.getParamResourcelist());
        }
        if (this.getParamShowownlocks() != null) {
            lockParams.put(PARAM_SHOWOWNLOCKS, this.getParamShowownlocks());
        }
        if (this.getParamIncluderelated() != null) {
            lockParams.put(PARAM_INCLUDERELATED, this.getParamIncluderelated());
        }
        CmsLockedResourcesList list = new CmsLockedResourcesList(this.getJsp(), lockedResources, CmsResource.getParentFolder(this.getResourceList().get(0)), lockParams);
        list.actionDialog();
        list.getList().setBoxed(false);
        StringBuffer result = new StringBuffer(512);
        result.append("<input type='hidden' name='locks' value='");
        result.append(this.getLockedResources().size()).append("'>\n");
        result.append("<input type='hidden' name='blockinglocks' value='");
        result.append(this.getBlockingLockedResources().size()).append("'>\n");
        result.append(CmsStringUtil.padLeft("", 120 - result.length()));
        result.append(CmsListExplorerColumn.getExplorerStyleDef());
        result.append("<div style='height:150px; overflow: auto;'>\n");
        result.append(list.getList().listHtml());
        result.append("</div>\n");
        return result.toString();
    }

    public String dialogButtons() {
        if (CmsLock.getDialogAction(this.getCms()) != 4) {
            return this.dialogButtonsOkCancel();
        }
        return this.dialogButtonsClose();
    }

    public CmsLockFilter getBlockingFilter() {
        if (this.m_blockingFilter == null) {
            this.m_blockingFilter = CmsLockFilter.FILTER_ALL;
            this.m_blockingFilter = this.m_blockingFilter.filterNotLockableByUser(this.getCms().getRequestContext().getCurrentUser());
        }
        return this.m_blockingFilter;
    }

    public Set getBlockingLockedResources() {
        HashSet<String> blockingResources = new HashSet<String>();
        for (String resName : this.getResourceList()) {
            block3: {
                try {
                    blockingResources.addAll(this.getCms().getLockedResources(resName, this.getBlockingFilter()));
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (!Boolean.valueOf(this.getParamIncluderelated()).booleanValue()) continue;
            this.addLockedRelatedResources(resName, this.getBlockingFilter(), blockingResources);
        }
        this.m_blockingLocks = blockingResources.size();
        return blockingResources;
    }

    public int getBlockingLocks() {
        if (this.m_blockingLocks == -1) {
            this.getLockedResources();
        }
        return this.m_blockingLocks;
    }

    public CmsParameterConfiguration getConfiguration() {
        return CmsParameterConfiguration.EMPTY_PARAMETERS;
    }

    public String getConfirmationMessage(boolean state) {
        if (CmsLock.getDialogAction(this.getCms()) == 4) {
            return "";
        }
        if (state) {
            if (this.isMultiOperation()) {
                return this.key("GUI_LOCK_MULTI_LOCK_CONFIRMATION_0");
            }
            return this.key("GUI_LOCK_CONFIRMATION_0");
        }
        switch (CmsLock.getDialogAction(this.getCms())) {
            case 1: {
                if (this.isMultiOperation()) {
                    return this.key("GUI_LOCK_MULTI_INFO_LOCKEDSUBRESOURCES_0");
                }
                return this.key("GUI_LOCK_INFO_LOCKEDSUBRESOURCES_0");
            }
            case 2: {
                return this.key("GUI_LOCK_CHANGE_CONFIRMATION_0");
            }
            case 3: {
                if (this.isMultiOperation()) {
                    return this.key("GUI_LOCK_MULTI_UNLOCK_CONFIRMATION_0");
                }
                return this.key("GUI_LOCK_UNLOCK_CONFIRMATION_0");
            }
        }
        return "";
    }

    public String getDialogHandler() {
        return "class_dialog_lock";
    }

    public String getDialogUri(String resource, CmsJspActionElement jsp) {
        switch (CmsLock.getDialogAction(jsp.getCmsObject())) {
            case 1: {
                return URI_LOCK_DIALOG;
            }
            case 2: {
                return URI_LOCKCHANGE_DIALOG;
            }
            case 3: {
                return URI_UNLOCK_DIALOG;
            }
        }
        return URI_LOCKS_DIALOG;
    }

    public List getLockedResources() {
        if (this.m_lockedResources == null) {
            HashSet<String> lockedResources = new HashSet<String>();
            for (String resName : this.getResourceList()) {
                block4: {
                    try {
                        lockedResources.addAll(this.getCms().getLockedResources(resName, this.getNonBlockingFilter()));
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block4;
                        LOG.error((Object)e.getLocalizedMessage(this.getLocale()), (Throwable)e);
                    }
                }
                if (!Boolean.valueOf(this.getParamIncluderelated()).booleanValue()) continue;
                this.addLockedRelatedResources(resName, this.getNonBlockingFilter(), lockedResources);
            }
            this.m_lockedResources = new ArrayList(lockedResources);
            lockedResources.addAll(this.getBlockingLockedResources());
            this.m_lockedResources = new ArrayList(lockedResources);
            Collections.sort(this.m_lockedResources);
        }
        return this.m_lockedResources;
    }

    public CmsLockFilter getNonBlockingFilter() {
        if (this.m_nonBlockingFilter == null) {
            this.m_nonBlockingFilter = CmsLockFilter.FILTER_ALL;
            this.m_nonBlockingFilter = this.m_nonBlockingFilter.filterLockableByUser(this.getCms().getRequestContext().getCurrentUser());
            this.m_nonBlockingFilter = this.m_nonBlockingFilter.filterSharedExclusive();
        }
        return this.m_nonBlockingFilter;
    }

    public String getParamIncluderelated() {
        return this.m_paramIncluderelated;
    }

    public String getParamProjectid() {
        return this.m_paramProjectid;
    }

    public String getParamShowownlocks() {
        return this.m_paramShowownlocks;
    }

    public void initConfiguration() {
    }

    public void setBlockingFilter(CmsLockFilter blockingFilter) {
        this.m_blockingFilter = blockingFilter;
        this.m_blockingLocks = -1;
        this.m_lockedResources = null;
    }

    public void setNonBlockingFilter(CmsLockFilter nonBlockingFilter) {
        this.m_nonBlockingFilter = nonBlockingFilter;
        this.m_lockedResources = null;
    }

    public void setParamIncluderelated(String paramIncluderelated) {
        this.m_paramIncluderelated = paramIncluderelated;
    }

    public void setParamProjectid(String projectid) {
        this.m_paramProjectid = projectid;
    }

    public void setParamShowownlocks(String paramShowownlocks) {
        this.m_paramShowownlocks = paramShowownlocks;
    }

    public boolean showConfirmation() {
        boolean showConfirmation = this.getSettings().getUserSettings().getDialogShowLock();
        if (DIALOG_TYPE_LOCK.equals(this.getParamDialogtype())) {
            showConfirmation = showConfirmation || this.getLockedResources().size() > 0;
        }
        return showConfirmation;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if ("confirmed".equals(this.getParamAction())) {
            this.setAction(1);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else {
            switch (CmsLock.getDialogAction(this.getCms())) {
                case 1: {
                    this.setDialogTitle("GUI_LOCK_RESOURCE_1", "GUI_LOCK_MULTI_LOCK_2");
                    this.setParamDialogtype(DIALOG_TYPE_LOCK);
                    if (this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) break;
                    this.setAction(4);
                    return;
                }
                case 2: {
                    this.setDialogTitle("GUI_LOCK_STEAL_1", "GUI_LOCK_MULTI_STEAL_2");
                    this.setParamDialogtype(DIALOG_TYPE_UNLOCK);
                    break;
                }
                case 3: {
                    this.setDialogTitle("GUI_LOCK_UNLOCK_1", "GUI_LOCK_MULTI_UNLOCK_2");
                    this.setParamDialogtype(DIALOG_TYPE_UNLOCK);
                    break;
                }
                default: {
                    this.setDialogTitle("GUI_LOCK_LOCKS_1", "GUI_LOCK_MULTI_LOCKS_2");
                    this.setParamDialogtype(DIALOG_TYPE_LOCKS);
                }
            }
            if (CmsLock.getDialogAction(this.getCms()) == 4 || this.showConfirmation()) {
                this.setAction(0);
            } else {
                this.setAction(200);
            }
        }
        if (this.getParamResource() == null && this.getParamResourcelist() == null) {
            this.setParamResource("/");
        }
    }

    protected boolean performDialogOperation() throws CmsException {
        if (this.isMultiOperation() && !"wait".equals(this.getParamAction())) {
            return false;
        }
        int dialogAction = CmsLock.getDialogAction(this.getCms());
        for (String resName : this.getResourceList()) {
            try {
                this.performSingleResourceOperation(resName, dialogAction);
            }
            catch (CmsException e) {
                this.addMultiOperationException(e);
            }
        }
        String message = dialogAction == 1 ? "ERR_LOCK_MULTI_0" : "ERR_UNLOCK_MULTI_0";
        this.checkMultiOperationException(Messages.get(), message);
        return true;
    }

    protected void performSingleResourceOperation(String resourceName, int dialogAction) throws CmsException {
        String originalResourceName = resourceName;
        CmsResource res = this.getCms().readResource(resourceName, CmsResourceFilter.ALL);
        if (res.isFolder() && !resourceName.endsWith("/")) {
            resourceName = resourceName + "/";
        }
        org.opencms.lock.CmsLock lock = this.getCms().getLock(res);
        switch (dialogAction) {
            case 1: 
            case 2: {
                if (lock.isNullLock()) {
                    this.getCms().lockResource(originalResourceName);
                    break;
                }
                if (lock.isDirectlyOwnedInProjectBy(this.getCms())) break;
                this.getCms().changeLock(resourceName);
                break;
            }
            default: {
                if (lock.isNullLock() || !lock.isOwnedBy(this.getCms().getRequestContext().getCurrentUser())) break;
                this.getCms().unlockResource(resourceName);
            }
        }
    }

    private void addLockedRelatedResources(String resName, CmsLockFilter filter, Set lockedResources) {
        block7: {
            try {
                for (CmsRelation relation : this.getCms().getRelationsForResource(resName, CmsRelationFilter.TARGETS.filterStrong().filterIncludeChildren())) {
                    String targetName;
                    CmsResource target = null;
                    try {
                        target = relation.getTarget(this.getCms(), CmsResourceFilter.ALL);
                    }
                    catch (CmsException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)e.getLocalizedMessage(this.getLocale()), (Throwable)e);
                        continue;
                    }
                    if (target.getState().isUnchanged() || lockedResources.contains(targetName = this.getCms().getSitePath(target)) || lockedResources.contains(targetName + "*") || this.m_lockedResources != null && (this.m_lockedResources.contains(targetName) || this.m_lockedResources.contains(targetName + "*"))) continue;
                    try {
                        org.opencms.lock.CmsLock lock = this.getCms().getLock(targetName);
                        if (lock.isUnlocked() || !filter.match("/", lock)) continue;
                        lockedResources.add(targetName + "*");
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)e.getLocalizedMessage(this.getLocale()), (Throwable)e);
                    }
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)e.getLocalizedMessage(this.getLocale()), (Throwable)e);
            }
        }
    }
}

