/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceAction;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsPublishScheduled
extends CmsDialog {
    public static final String DIALOG_TYPE = "publishscheduled";
    public static final String PARAM_ENABLE_NOTIFICATION = "enablenotification";
    public static final String PARAM_PUBLISHSCHEDULEDDATE = "publishscheduleddate";
    public static final String PARAM_RESETPUBLISHSCHEDULED = "resetpublishscheduled";
    private String m_paramPublishscheduleddate;

    public CmsPublishScheduled(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPublishScheduled(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCloseDialog() throws JspException {
        this.getSettings().getFrameUris().put("body", "/system/workplace/views/explorer/explorer_fs.jsp");
        super.actionCloseDialog();
    }

    public void actionUpdate() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            this.performDialogOperation();
            this.actionCloseDialog();
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public String getParamPublishscheduleddate() {
        return this.m_paramPublishscheduleddate;
    }

    public void setDialogTitle(String singleKey) {
        String resourceName = CmsStringUtil.formatResourceName(this.getParamResource(), 50);
        this.setParamTitle(this.key(singleKey, new Object[]{resourceName}));
    }

    public void setParamPublishscheduleddate(String paramPublishscheduleddate) {
        this.m_paramPublishscheduleddate = paramPublishscheduleddate;
    }

    protected String getLocalizedType(int flags) {
        if ((flags & 0x10) > 0) {
            return this.key("GUI_LABEL_USER_0");
        }
        return this.key("GUI_LABEL_GROUP_0");
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setDialogTitle("GUI_PUBLISH_SCHEDULED_SETTINGS_1");
        }
    }

    protected boolean performDialogOperation() throws CmsException, ParseException {
        String resource = this.getParamResource();
        String publishScheduledDate = this.getParamPublishscheduleddate();
        String userName = this.getCms().getRequestContext().getCurrentUser().getName();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, this.getLocale());
        Date date = dateFormat.parse(publishScheduledDate);
        if (date.getTime() < new Date().getTime()) {
            throw new CmsException(Messages.get().container("ERR_PUBLISH_SCHEDULED_DATE_IN_PAST_1", date));
        }
        CmsWorkplaceAction action = CmsWorkplaceAction.getInstance();
        CmsObject cmsAdmin = action.getCmsAdminObject();
        CmsObject cms = OpenCms.initCmsObject(this.getCms());
        cmsAdmin.getRequestContext().setSiteRoot(cms.getRequestContext().getSiteRoot());
        String dateTime = CmsDateUtil.getDateTime(date, 3, this.getLocale());
        String projectName = this.key("GUI_PUBLISH_SCHEDULED_PROJECT_NAME_2", new Object[]{this.getCms().getRequestContext().addSiteRoot(resource), dateTime});
        projectName = projectName.replace("/", "&#47;");
        CmsProject tmpProject = cmsAdmin.createProject(projectName, "", CmsRole.WORKPLACE_USER.getGroupName(), CmsRole.PROJECT_MANAGER.getGroupName(), CmsProject.PROJECT_TYPE_TEMPORARY);
        tmpProject.setHidden(true);
        cmsAdmin.writeProject(tmpProject);
        cmsAdmin.getRequestContext().setCurrentProject(tmpProject);
        cms.getRequestContext().setCurrentProject(tmpProject);
        cmsAdmin.copyResourceToProject(resource);
        CmsLock lock = cms.getLock(resource);
        if (lock != null && lock.isOwnedBy(cms.getRequestContext().getCurrentUser()) && !lock.isOwnedInProjectBy(cms.getRequestContext().getCurrentUser(), cms.getRequestContext().getCurrentProject())) {
            cms.changeLock(resource);
        }
        cms.lockResource(resource);
        lock = cms.getLock(resource);
        CmsScheduledJobInfo job = new CmsScheduledJobInfo();
        String jobName = projectName;
        job.setJobName(jobName);
        job.setClassName("org.opencms.scheduler.jobs.CmsPublishScheduledJob");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String cronExpr = "" + calendar.get(13) + " " + calendar.get(12) + " " + calendar.get(11) + " " + calendar.get(5) + " " + (calendar.get(2) + 1) + " " + "?" + " " + calendar.get(1);
        job.setCronExpression(cronExpr);
        job.setActive(true);
        CmsContextInfo contextInfo = new CmsContextInfo();
        contextInfo.setProjectName(projectName);
        contextInfo.setUserName(cmsAdmin.getRequestContext().getCurrentUser().getName());
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("mail-to-user", userName);
        params.put("jobname", jobName);
        params.put("linkcheck", "true");
        job.setParameters(params);
        job.setContextInfo(contextInfo);
        OpenCms.getScheduleManager().scheduleJob(cmsAdmin, job);
        OpenCms.writeConfiguration(CmsSystemConfiguration.class);
        return true;
    }
}

