/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.comparison;

import com.alkacon.diff.Diff;
import com.alkacon.diff.I_HtmlDiffConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.comparison.CmsDiffViewMode;
import org.opencms.workplace.comparison.CmsHtmlDifferenceConfiguration;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;

public abstract class A_CmsDiffViewDialog
extends CmsDialog {
    private CmsDiffViewMode m_mode;

    protected A_CmsDiffViewDialog(CmsJspActionElement jsp) {
        super(jsp);
        this.setParamStyle("new");
    }

    public void displayDialog() throws Exception {
        if (this.getAction() == 4) {
            this.actionCloseDialog();
        }
        JspWriter out = this.getJsp().getJspContext().getOut();
        out.print("<link rel='stylesheet' type='text/css' href='");
        out.print(A_CmsDiffViewDialog.getStyleUri(this.getJsp()));
        out.println("diff.css'>");
        out.println(this.dialogContentStart(this.getParamTitle()));
        out.print("<form name='diff-form' method='post' action='");
        out.print(this.getDialogUri());
        out.println("'>");
        out.println(this.allParamsAsHidden());
        out.println("</form>");
        out.println("<p>");
        out.println(this.getDiffOnlyButtonsHtml());
        out.println("</p>");
        out.println(this.dialogBlockStart(null));
        out.println("<table cellspacing='0' cellpadding='0' class='xmlTable'>\n<tr><td><pre style='overflow:auto'>");
        try {
            CmsHtmlDifferenceConfiguration conf = new CmsHtmlDifferenceConfiguration(this.getMode() == CmsDiffViewMode.ALL ? -1 : this.getLinesBeforeSkip(), this.getLocale());
            String diff = Diff.diffAsHtml((String)this.getOriginalSource(), (String)this.getCopySource(), (I_HtmlDiffConfiguration)conf);
            if (CmsStringUtil.isNotEmpty(diff)) {
                out.println(diff);
            } else {
                out.println(this.wrapLinesWithUnchangedStyle(CmsStringUtil.substitute(CmsStringUtil.escapeHtml(this.getOriginalSource()), "<br/>", "")));
            }
        }
        catch (Exception e) {
            out.print((Object)e);
        }
        out.println("</pre></td></tr>\n</table>");
        out.println(this.dialogBlockEnd());
        out.println(this.dialogContentEnd());
        out.println(this.dialogEnd());
        out.println(this.bodyEnd());
        out.println(this.htmlEnd());
    }

    String getDiffOnlyButtonsHtml() {
        StringBuffer result = new StringBuffer();
        if (!this.getOriginalSource().equals(this.getCopySource())) {
            String onClick1 = "javascript:document.forms['diff-form'].mode.value = '";
            String onClick2 = "javascript:document.forms['diff-form'].mode.value = '";
            onClick1 = onClick1 + CmsDiffViewMode.ALL;
            onClick2 = onClick2 + CmsDiffViewMode.DIFF_ONLY;
            onClick1 = onClick1 + "'; document.forms['diff-form'].submit();";
            onClick2 = onClick2 + "'; document.forms['diff-form'].submit();";
            result.append(this.getTwoButtonsHtml(CmsDiffViewMode.DIFF_ONLY.getName().key(this.getLocale()), CmsDiffViewMode.ALL.getName().key(this.getLocale()), onClick1, onClick2, this.getMode() == CmsDiffViewMode.DIFF_ONLY));
        } else {
            this.setMode(CmsDiffViewMode.ALL);
        }
        return result.toString();
    }

    public String getTwoButtonsHtml(String label1, String label2, String onClick1, String onClick2, boolean firstActive) {
        StringBuffer result = new StringBuffer();
        if (firstActive) {
            result.append(A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, "id", label1, null, true, "list/details_show.png", null, onClick1));
            result.append("&nbsp;&nbsp;");
            result.append(this.deactivatedEmphasizedButtonHtml(label2, "list/details_hide.png"));
        } else {
            result.append(this.deactivatedEmphasizedButtonHtml(label1, "list/details_hide.png"));
            result.append("&nbsp;&nbsp;");
            result.append(A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, "id", label2, null, true, "list/details_show.png", null, onClick2));
        }
        result.append("&nbsp;&nbsp;");
        return result.toString();
    }

    public String deactivatedEmphasizedButtonHtml(String name, String iconPath) {
        StringBuffer result = new StringBuffer();
        result.append("<span style='vertical-align:middle;'><img style='width:20px;height:20px;display:inline;vertical-align:middle;text-decoration:none;' src='");
        result.append(CmsWorkplace.getSkinUri());
        result.append(iconPath);
        result.append("' alt='");
        result.append(name);
        result.append("' title='");
        result.append(name);
        result.append("'>&nbsp;<b>");
        result.append(name);
        result.append("</b></span>");
        return result.toString();
    }

    public CmsDiffViewMode getMode() {
        return this.m_mode;
    }

    public String getParamMode() {
        if (this.m_mode == null) {
            return null;
        }
        return this.m_mode.getMode();
    }

    public void setMode(CmsDiffViewMode mode) {
        this.m_mode = mode;
    }

    public void setParamMode(String mode) {
        this.m_mode = CmsDiffViewMode.valueOf(mode);
    }

    protected abstract String getCopySource();

    protected abstract int getLinesBeforeSkip();

    protected abstract String getOriginalSource();

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.getParamMode())) {
            this.m_mode = CmsDiffViewMode.DIFF_ONLY;
        }
        try {
            this.validateParamaters();
        }
        catch (Exception e) {
            this.setAction(4);
            try {
                this.actionCloseDialog();
            }
            catch (JspException e1) {
                // empty catch block
            }
            return;
        }
    }

    protected abstract void validateParamaters() throws Exception;

    protected String wrapLinesWithUnchangedStyle(String diff) throws IOException {
        String line;
        StringBuffer result = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(diff));
        while ((line = br.readLine()) != null) {
            if ("".equals(line.trim())) {
                line = "&nbsp;";
            }
            result.append("<div class=\"df-unc\"><span class=\"df-unc\">").append(line).append("</span></div>\n");
        }
        return result.toString();
    }
}

