/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsRequestContext;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.CmsDialogElement;
import org.opencms.workplace.editors.CmsDialogElements;
import org.opencms.workplace.editors.CmsEditor;
import org.opencms.workplace.editors.I_CmsEditorActionHandler;
import org.opencms.workplace.editors.I_CmsEditorCssHandler;
import org.opencms.workplace.editors.Messages;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.CmsXmlPageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CmsDefaultPageEditor
extends CmsEditor {
    public static final String PARAM_ELEMENTNAME = "elementname";
    public static final String PARAM_OLDELEMENTNAME = "oldelementname";
    public static final String[] SELECTBOX_FONTS = new String[]{"Arial", "Arial Narrow", "System", "Times New Roman", "Verdana", "Monospace", "SansSerif"};
    public static final String XML_BODY_ELEMENT = "body";
    private static final Log LOG = CmsLog.getLog(CmsDefaultPageEditor.class);
    protected CmsFile m_file;
    protected CmsXmlPage m_page;
    private List<CmsDialogElement> m_elementList;
    private Locale m_elementLocale;
    private String m_paramElementname;
    private String m_paramOldelementname;
    private String m_uriStyleSheet;

    public CmsDefaultPageEditor(CmsJspActionElement jsp) {
        super(jsp);
    }

    public void actionChangeBodyElement() {
        block5: {
            try {
                Locale oldLocale = CmsLocaleManager.getLocale(this.getParamOldelementlanguage());
                this.performSaveContent(this.getParamOldelementname(), oldLocale);
            }
            catch (CmsException e) {
                try {
                    this.showErrorPage(this, e);
                }
                catch (JspException exc) {
                    if (!LOG.isInfoEnabled()) break block5;
                    LOG.info((Object)exc);
                }
            }
        }
        if (!this.getParamElementlanguage().equals(this.getParamOldelementlanguage())) {
            this.initBodyElementName(this.getParamOldelementname());
        }
        this.initContent();
    }

    public void actionCleanupBodyElement() {
        block4: {
            try {
                Locale oldLocale = CmsLocaleManager.getLocale(this.getParamOldelementlanguage());
                this.performSaveContent(this.getParamOldelementname(), oldLocale);
            }
            catch (CmsException e) {
                try {
                    this.showErrorPage(this, e);
                }
                catch (JspException exc) {
                    if (!LOG.isInfoEnabled()) break block4;
                    LOG.info((Object)exc);
                }
            }
        }
    }

    @Override
    public void actionClear(boolean forceUnlock) {
        block3: {
            this.deleteTempFile();
            boolean directEditMode = Boolean.valueOf(this.getParamDirectedit());
            boolean modified = Boolean.valueOf(this.getParamModified());
            if (directEditMode || forceUnlock || !modified) {
                try {
                    this.getCms().unlockResource(this.getParamResource());
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info((Object)e);
                }
            }
        }
    }

    public void actionDeleteElementLocale() throws JspException {
        block6: {
            try {
                Locale loc = this.getElementLocale();
                this.m_page.removeLocale(loc);
                this.m_file.setContents(this.m_page.marshal());
                this.m_file = this.getCms().writeFile(this.m_file);
                List<Locale> locales = this.m_page.getLocales();
                if (locales.size() > 0) {
                    Locale newLoc = locales.get(0);
                    this.setParamElementlanguage(newLoc.toString());
                    this.m_elementLocale = newLoc;
                } else if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_GET_LOCALES_1", this.getParamResource()));
                }
                this.initContent();
            }
            catch (CmsXmlException e) {
                this.showErrorPage(e);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block6;
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void actionDirectEdit() throws IOException, JspException, ServletException {
        I_CmsEditorActionHandler actionClass = OpenCms.getWorkplaceManager().getEditorActionHandler();
        if (actionClass == null) {
            this.actionSave();
            this.actionExit();
        } else {
            actionClass.editorAction(this, this.getJsp());
        }
    }

    @Override
    public void actionExit() throws IOException, JspException, ServletException {
        if (this.getAction() == 4) {
            return;
        }
        this.actionClear(false);
        this.actionClose();
    }

    public void actionPreview() throws IOException, JspException {
        try {
            this.performSaveContent(this.getParamElementname(), this.getElementLocale());
        }
        catch (CmsException e) {
            this.showErrorPage(this, e);
        }
        String param = "?__locale=" + this.getParamElementlanguage();
        this.sendCmsRedirect(this.getParamTempfile() + param);
    }

    @Override
    public void actionSave() throws JspException {
        try {
            this.performSaveContent(this.getParamElementname(), this.getElementLocale());
            this.commitTempFile();
            this.setParamModified(Boolean.TRUE.toString());
        }
        catch (CmsException e) {
            this.showErrorPage(e);
        }
        if (this.getAction() != 4) {
            this.setAction(121);
        }
    }

    public String buildSelectElementLanguage(String attributes) {
        return this.buildSelectElementLanguage(attributes, this.getParamTempfile(), this.getElementLocale());
    }

    public String buildSelectElementName(String attributes) {
        List<CmsDialogElement> elementList = this.getElementList();
        int counter = 0;
        int currentIndex = -1;
        ArrayList<String> options = new ArrayList<String>(elementList.size());
        ArrayList<String> values = new ArrayList<String>(elementList.size());
        String elementName = this.getParamElementname();
        if (CmsStringUtil.isEmpty(elementName)) {
            elementName = this.getParamOldelementname();
        }
        for (int i = 0; i < elementList.size(); ++i) {
            CmsDialogElement element = elementList.get(i);
            if (CmsStringUtil.isNotEmpty(elementName) && elementName.equals(element.getName())) {
                currentIndex = counter;
            }
            if ((this.m_page.hasValue(element.getName(), this.getElementLocale()) || !element.isMandantory()) && !this.m_page.isEnabled(element.getName(), this.getElementLocale())) continue;
            options.add(element.getNiceName());
            values.add(element.getName());
            ++counter;
        }
        return CmsDefaultPageEditor.buildSelect(attributes, options, values, currentIndex, false);
    }

    public String buildSelectFonts(String attributes) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < SELECTBOX_FONTS.length; ++i) {
            String value = SELECTBOX_FONTS[i];
            names.add(value);
        }
        return CmsDefaultPageEditor.buildSelect(attributes, names, names, -1, false);
    }

    public void escapeParams() {
        this.setParamContent(CmsEncoder.escapeWBlanks(this.getParamContent(), "UTF-8"));
    }

    public Locale getElementLocale() {
        if (this.m_elementLocale == null) {
            this.m_elementLocale = CmsLocaleManager.getLocale(this.getParamElementlanguage());
        }
        return this.m_elementLocale;
    }

    public String getParamElementname() {
        return this.m_paramElementname;
    }

    public String getParamOldelementname() {
        return this.m_paramOldelementname;
    }

    public String getUriStyleSheet() {
        block5: {
            if (this.m_uriStyleSheet == null) {
                try {
                    if (OpenCms.getWorkplaceManager().getEditorCssHandlers().size() > 0) {
                        for (I_CmsEditorCssHandler cssHandler : OpenCms.getWorkplaceManager().getEditorCssHandlers()) {
                            if (!cssHandler.matches(this.getCms(), this.getParamTempfile())) continue;
                            this.m_uriStyleSheet = cssHandler.getUriStyleSheet(this.getCms(), this.getParamTempfile());
                            break block5;
                        }
                        break block5;
                    }
                    String currentTemplate = this.getUriTemplate();
                    this.m_uriStyleSheet = this.getCms().readPropertyObject(currentTemplate, "template", false).getValue("");
                }
                catch (CmsException e) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_READ_TEMPLATE_PROP_STYLESHEET_FAILED_0"), (Throwable)e);
                }
            }
        }
        return this.m_uriStyleSheet;
    }

    public String getUriTemplate() {
        String result = "";
        try {
            result = this.getCms().readPropertyObject(this.getParamTempfile(), "template", true).getValue("");
        }
        catch (CmsException e) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_READ_TEMPLATE_PROP_FAILED_0"), (Throwable)e);
        }
        return result;
    }

    public void setParamElementname(String elementName) {
        this.m_paramElementname = elementName;
    }

    public void setParamOldelementname(String oldElementName) {
        this.m_paramOldelementname = oldElementName;
    }

    protected List<CmsDialogElement> getElementList() {
        if (this.m_elementList == null) {
            this.m_elementList = CmsDialogElements.computeElements(this.getCms(), this.m_page, this.getParamTempfile(), this.getElementLocale());
        }
        return this.m_elementList;
    }

    protected void initBodyElementLanguage() {
        List<Locale> locales = this.m_page.getLocales();
        Locale defaultLocale = OpenCms.getLocaleManager().getDefaultLocales(this.getCms(), this.getCms().getSitePath(this.m_file)).get(0);
        if (locales.size() == 0) {
            block9: {
                if (!this.m_page.hasValue(XML_BODY_ELEMENT, defaultLocale)) {
                    this.m_page.addValue(XML_BODY_ELEMENT, defaultLocale);
                }
                try {
                    this.m_file.setContents(this.m_page.marshal());
                    this.getCms().writeFile(this.m_file);
                }
                catch (CmsException e) {
                    try {
                        this.showErrorPage(this, e);
                    }
                    catch (JspException exc) {
                        if (!LOG.isInfoEnabled()) break block9;
                        LOG.info((Object)exc);
                    }
                }
            }
            this.setParamElementlanguage(defaultLocale.toString());
        } else if (locales.contains(defaultLocale)) {
            this.setParamElementlanguage(defaultLocale.toString());
        } else {
            this.setParamElementlanguage(locales.get(0).toString());
        }
    }

    protected void initBodyElementName(String elementName) {
        if (elementName == null || this.m_page.hasValue(elementName, this.getElementLocale()) && !this.m_page.isEnabled(elementName, this.getElementLocale())) {
            List<String> allElements = this.m_page.getNames(this.getElementLocale());
            int elementCount = allElements.size();
            ArrayList<String> elements = new ArrayList<String>(elementCount);
            for (int i = 0; i < elementCount; ++i) {
                if (!this.m_page.isEnabled(allElements.get(i), this.getElementLocale())) continue;
                elements.add(allElements.get(i));
            }
            List<CmsDialogElement> elementList = this.getElementList();
            for (int i = 0; i < elementList.size(); ++i) {
                CmsDialogElement checkElement = elementList.get(i);
                if (!elements.contains(checkElement.getName())) continue;
                this.setParamElementname(checkElement.getName());
                return;
            }
            if (elements.contains(XML_BODY_ELEMENT)) {
                this.setParamElementname(XML_BODY_ELEMENT);
            } else {
                this.setParamElementname((String)elements.get(0));
            }
        } else {
            this.setParamElementname(elementName);
        }
    }

    @Override
    protected void initContent() {
        String elementData;
        if (CmsStringUtil.isNotEmpty(this.getParamContent()) && CmsStringUtil.isNotEmpty(this.getParamElementname()) && this.getParamElementname().equals(this.getParamOldelementname()) && CmsStringUtil.isNotEmpty(this.getParamElementlanguage()) && this.getParamElementlanguage().equals(this.getParamOldelementlanguage())) {
            return;
        }
        this.getCms().getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_EDITOR, Boolean.TRUE);
        if (this.m_page.hasValue(this.getParamElementname(), this.getElementLocale())) {
            elementData = this.m_page.getStringValue(this.getCms(), this.getParamElementname(), this.getElementLocale());
        } else {
            if (Boolean.valueOf(this.getParamDirectedit()).booleanValue()) {
                this.m_page.addValue(this.getParamElementname(), this.getElementLocale());
            }
            elementData = "";
        }
        this.setParamContent(elementData);
    }

    protected void performSaveContent(String body, Locale locale) throws CmsException {
        String content = this.prepareContent(true);
        String contentConversion = this.m_page.getConversion();
        if ("cleanup".equals(this.getParamAction())) {
            contentConversion = contentConversion == null || contentConversion.equals(CmsHtmlConverter.PARAM_DISABLED) ? "cleanup" : contentConversion + ";cleanup";
        }
        this.m_page.setConversion(contentConversion);
        if (!this.m_page.hasValue(body, locale) && !"".equals(content)) {
            this.m_page.addValue(body, locale);
        }
        boolean enabled = this.m_page.isEnabled(body, locale);
        if (this.m_page.hasValue(body, locale)) {
            this.m_page.setStringValue(this.getCms(), body, locale, content);
        }
        this.m_file.setContents(this.m_page.marshal());
        this.m_file = this.getCms().writeFile(this.m_file);
        this.m_page = CmsXmlPageFactory.unmarshal(this.getCms(), this.m_file);
        if (this.m_page.hasValue(body, locale)) {
            this.getCms().getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_EDITOR, Boolean.TRUE);
            content = this.m_page.getStringValue(this.getCms(), body, locale);
            if (content == null) {
                content = "";
            }
            this.setParamContent(content);
            this.prepareContent(false);
            this.m_page.setEnabled(body, locale, enabled);
        }
    }

    protected abstract String prepareContent(boolean var1);
}

