/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.I_CmsEditorTypeMatcher;
import org.opencms.workplace.editors.Messages;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsWorkplaceEditorConfiguration {
    public static final String DOCUMENT_NODE = "editor";
    protected static final String N_AGENT = "agent";
    protected static final String N_CLASS = "class";
    protected static final String N_LABEL = "label";
    protected static final String N_MAPTO = "mapto";
    protected static final String N_NAME = "name";
    protected static final String N_RANKING = "ranking";
    protected static final String N_RESOURCETYPES = "resourcetypes";
    protected static final String N_TYPE = "type";
    protected static final String N_USERAGENTS = "useragents";
    protected static final String N_WIDGETEDITOR = "widgeteditor";
    private static final Log LOG = CmsLog.getLog(CmsWorkplaceEditorConfiguration.class);
    private List<Pattern> m_browserPattern;
    private String m_editorLabel;
    private String m_editorUri;
    private Map<String, String[]> m_resTypes;
    private List<String> m_userAgentsRegEx;
    private boolean m_validConfiguration;
    private String m_widgetEditor;

    public CmsWorkplaceEditorConfiguration(byte[] xmlData, String editorUri) {
        this.setValidConfiguration(true);
        try {
            this.initialize(CmsXmlUtils.unmarshalHelper(xmlData, null), editorUri);
        }
        catch (CmsXmlException e) {
            this.logConfigurationError(Messages.get().getBundle().key("ERR_XML_PARSE_0"), e);
        }
    }

    public List<Pattern> getBrowserPattern() {
        return this.m_browserPattern;
    }

    public String getEditorLabel() {
        return this.m_editorLabel;
    }

    public String getEditorUri() {
        return this.m_editorUri;
    }

    public String getMappingForResourceType(String resourceType) {
        String[] resourceTypeParams = this.getResourceTypes().get(resourceType);
        if (resourceTypeParams == null) {
            return null;
        }
        return resourceTypeParams[1];
    }

    public float getRankingForResourceType(String resourceType) {
        String[] resourceTypeParams = this.getResourceTypes().get(resourceType);
        if (resourceTypeParams == null) {
            return -1.0f;
        }
        return Float.parseFloat(resourceTypeParams[0]);
    }

    public Map<String, String[]> getResourceTypes() {
        return this.m_resTypes;
    }

    public List<String> getUserAgentsRegEx() {
        return this.m_userAgentsRegEx;
    }

    public String getWidgetEditor() {
        return this.m_widgetEditor;
    }

    public boolean isValidConfiguration() {
        return this.m_validConfiguration;
    }

    public boolean isWidgetEditor() {
        return CmsStringUtil.isNotEmpty(this.m_widgetEditor);
    }

    public boolean matchesBrowser(String currentBrowser) {
        if (currentBrowser == null) {
            return false;
        }
        for (int i = 0; i < this.getBrowserPattern().size(); ++i) {
            boolean matches = this.getBrowserPattern().get(i).matcher(currentBrowser.trim()).matches();
            if (!matches) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_BROWSER_MATCHES_CONFIG_1", currentBrowser));
            }
            return true;
        }
        return false;
    }

    public boolean matchesResourceType(String resourceType) {
        return this.m_resTypes.containsKey(resourceType);
    }

    private void initialize(Document document, String editorUri) {
        Element rootElement = document.getRootElement();
        this.setEditorLabel(rootElement.elementText(N_LABEL));
        String widgetClass = rootElement.elementText(N_WIDGETEDITOR);
        if (CmsStringUtil.isNotEmpty(widgetClass)) {
            this.setWidgetEditor(widgetClass);
        }
        this.setEditorUri(editorUri);
        Iterator i = rootElement.element(N_RESOURCETYPES).elementIterator(N_TYPE);
        HashMap<String, String[]> resTypes = new HashMap<String, String[]>();
        while (i.hasNext()) {
            float ranking;
            Element currentType = (Element)i.next();
            String name = currentType.elementText(N_NAME);
            if (CmsStringUtil.isEmpty(name)) {
                this.logConfigurationError(Messages.get().getBundle().key("ERR_INVALID_RESTYPE_NAME_0"), null);
                continue;
            }
            try {
                ranking = Float.parseFloat(currentType.elementText(N_RANKING));
            }
            catch (Throwable t) {
                this.logConfigurationError(Messages.get().getBundle().key("ERR_INVALID_RESTYPE_RANKING_1", name), t);
                continue;
            }
            String mapTo = currentType.elementText(N_MAPTO);
            if (CmsStringUtil.isEmpty(mapTo)) {
                mapTo = null;
            }
            resTypes.put(name, new String[]{"" + ranking, mapTo});
        }
        i = rootElement.element(N_RESOURCETYPES).elementIterator(N_CLASS);
        while (i.hasNext()) {
            float ranking;
            Element currentClass = (Element)i.next();
            String name = currentClass.elementText(N_NAME);
            List<Object> assignedTypes = new ArrayList();
            try {
                I_CmsEditorTypeMatcher matcher = (I_CmsEditorTypeMatcher)Class.forName(name).newInstance();
                assignedTypes = matcher.getAdditionalResourceTypes();
            }
            catch (Throwable t) {
                this.logConfigurationError(Messages.get().getBundle().key("ERR_INVALID_RESTYPE_CLASS_1", name), t);
                continue;
            }
            try {
                ranking = Float.parseFloat(currentClass.elementText(N_RANKING));
            }
            catch (Throwable t) {
                this.logConfigurationError(Messages.get().getBundle().key("ERR_INVALID_RESTYPE_RANKING_1", name), t);
                continue;
            }
            String mapTo = currentClass.elementText(N_MAPTO);
            if ("".equals(mapTo)) {
                mapTo = null;
            }
            for (String string : assignedTypes) {
                resTypes.put(string, new String[]{"" + ranking, mapTo});
            }
        }
        this.setResourceTypes(resTypes);
        i = document.getRootElement().element(N_USERAGENTS).elementIterator(N_AGENT);
        ArrayList<Pattern> pattern = new ArrayList<Pattern>();
        ArrayList<String> userAgents = new ArrayList<String>();
        while (i.hasNext()) {
            Element currentAgent = (Element)i.next();
            String agentName = currentAgent.getText();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(agentName)) {
                userAgents.add(agentName);
                try {
                    pattern.add(Pattern.compile(agentName));
                }
                catch (PatternSyntaxException e) {
                    this.logConfigurationError(Messages.get().getBundle().key("ERR_COMPILE_EDITOR_REGEX_1", agentName), e);
                }
                continue;
            }
            this.logConfigurationError(Messages.get().getBundle().key("ERR_INVALID_USERAGENT_DEF_0"), null);
        }
        this.setBrowserPattern(pattern);
        this.setUserAgentsRegEx(userAgents);
    }

    private void logConfigurationError(String message, Throwable t) {
        this.setValidConfiguration(false);
        if (LOG.isErrorEnabled()) {
            if (t == null) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_EDITOR_CONFIG_ERROR_1", message));
            } else {
                LOG.error((Object)Messages.get().getBundle().key("LOG_EDITOR_CONFIG_ERROR_1", message), t);
            }
        }
    }

    private void setBrowserPattern(List<Pattern> pattern) {
        if (pattern == null || pattern.size() == 0) {
            this.setValidConfiguration(false);
            LOG.error((Object)Messages.get().getBundle().key("LOG_EDITOR_CONFIG_NO_PATTERN_0"));
        }
        this.m_browserPattern = pattern;
    }

    private void setEditorLabel(String label) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(label)) {
            this.setValidConfiguration(false);
            LOG.error((Object)Messages.get().getBundle().key("LOG_EDITOR_CONFIG_NO_LABEL_0"));
        }
        this.m_editorLabel = label;
    }

    private void setEditorUri(String uri) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(uri)) {
            this.setValidConfiguration(false);
            LOG.error((Object)Messages.get().getBundle().key("LOG_EDITOR_CONFIG_NO_URI_0"));
        }
        this.m_editorUri = uri;
    }

    private void setResourceTypes(Map<String, String[]> types) {
        if (types == null || types.size() == 0) {
            this.setValidConfiguration(false);
            LOG.error((Object)Messages.get().getBundle().key("LOG_NO_RESOURCE_TYPES_0"));
        }
        this.m_resTypes = types;
    }

    private void setUserAgentsRegEx(List<String> agents) {
        if (agents == null || agents.size() == 0) {
            this.setValidConfiguration(false);
            LOG.error((Object)Messages.get().getBundle().key("LOG_NO_USER_AGENTS_0"));
        }
        this.m_userAgentsRegEx = agents;
    }

    private void setValidConfiguration(boolean isValid) {
        this.m_validConfiguration = isValid;
    }

    private void setWidgetEditor(String widgetEditor) {
        this.m_widgetEditor = widgetEditor;
    }
}

