/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.editors.Messages;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.I_CmsXmlContentValueVisitor;
import org.opencms.xml.types.I_CmsXmlContentValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsXmlContentWidgetVisitor
implements I_CmsXmlContentValueVisitor {
    private static final Log LOG = CmsLog.getLog(CmsXmlContentWidgetVisitor.class);
    private Locale m_locale;
    private List<I_CmsWidget> m_uniqueWidgets;
    private Map<String, I_CmsXmlContentValue> m_values;
    private Map<String, I_CmsWidget> m_widgets;

    public CmsXmlContentWidgetVisitor() {
        this.initialize(null);
    }

    public CmsXmlContentWidgetVisitor(Locale locale) {
        this.initialize(locale);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public List<I_CmsWidget> getUniqueWidgets() {
        return this.m_uniqueWidgets;
    }

    public Map<String, I_CmsXmlContentValue> getValues() {
        return this.m_values;
    }

    public Map<String, I_CmsWidget> getWidgets() {
        return this.m_widgets;
    }

    @Override
    public void visit(I_CmsXmlContentValue value) {
        block7: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_VISITING_1", value.getPath()));
            }
            if (value.isSimpleType()) {
                boolean useLocale;
                boolean bl = useLocale = this.m_locale != null;
                if (useLocale && value.getLocale().equals(this.getLocale()) || !useLocale) {
                    try {
                        I_CmsWidget widget = value.getContentDefinition().getContentHandler().getWidget(value);
                        if (!this.m_uniqueWidgets.contains(widget)) {
                            this.m_uniqueWidgets.add(widget);
                        }
                        this.m_widgets.put(value.getPath(), widget);
                        this.m_values.put(value.getPath(), value);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)org.opencms.widgets.Messages.get().getBundle().key("LOG_DEBUG_WIDGETCOLLECTOR_ADD_1", value.getPath()));
                        }
                    }
                    catch (CmsXmlException e) {
                        if (!LOG.isErrorEnabled()) break block7;
                        LOG.error((Object)org.opencms.widgets.Messages.get().getBundle().key("ERR_WIDGETCOLLECTOR_ADD_1", value), (Throwable)e);
                    }
                }
            }
        }
    }

    private void initialize(Locale locale) {
        this.m_widgets = new HashMap<String, I_CmsWidget>(25);
        this.m_uniqueWidgets = new ArrayList<I_CmsWidget>(12);
        this.m_values = new HashMap<String, I_CmsXmlContentValue>(25);
        this.m_locale = locale;
    }
}

