/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.commons.CmsProgressThread;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListRadioMultiAction;
import org.opencms.workplace.list.CmsListState;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListItemComparator;
import org.opencms.workplace.list.Messages;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsHtmlList {
    public static final String ICON_LEFT = "list/leftarrow.png";
    public static final String ICON_RIGHT = "list/rightarrow.png";
    public static final String ITEM_SEPARATOR = "|";
    public static final String NO_SELECTION_HELP_VAR = "noSelHelp";
    public static final String NO_SELECTION_MATCH_HELP_VAR = "noSelMatchHelp";
    protected int m_currentPage;
    protected CmsListOrderEnum m_currentSortOrder;
    protected List<CmsListItem> m_filteredItems;
    protected final String m_id;
    protected boolean m_isBoxed = true;
    protected int m_maxItemsPerPage = 20;
    protected CmsListMetadata m_metadata;
    protected CmsMessageContainer m_name;
    protected List<CmsListItem> m_originalItems = new ArrayList<CmsListItem>();
    protected boolean m_printable;
    protected String m_searchFilter = "";
    protected boolean m_showTitle;
    protected int m_size;
    protected String m_sortedColumn;
    protected int m_totalSize;
    protected List<CmsListItem> m_visibleItems;
    protected transient A_CmsListDialog m_wp;

    public CmsHtmlList(String id, CmsMessageContainer name, CmsListMetadata metadata) {
        this.m_id = id;
        this.m_name = name;
        this.m_metadata = metadata;
        this.m_currentPage = 1;
        this.m_showTitle = true;
    }

    public static String htmlPageSelector(int nrPages, int itemsPage, int nrItems, int curPage, Locale locale) {
        StringBuffer html = new StringBuffer(256);
        for (int i = 0; i < nrPages; ++i) {
            int displayedFrom = i * itemsPage + 1;
            int displayedTo = (i + 1) * itemsPage < nrItems ? (i + 1) * itemsPage : nrItems;
            html.append("\t\t\t\t<option value='");
            html.append(i + 1);
            html.append("'");
            html.append(i + 1 == curPage ? " selected" : "");
            html.append(">");
            html.append(Messages.get().getBundle(locale).key("GUI_LIST_PAGE_ENTRY_3", new Integer(i + 1), new Integer(displayedFrom), new Integer(displayedTo)));
            html.append("</option>\n");
        }
        return html.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.m_originalItems != null) {
            this.m_originalItems.clear();
        }
        this.m_filteredItems = null;
        CmsHtmlList cmsHtmlList = this;
        synchronized (cmsHtmlList) {
            if (this.m_visibleItems != null) {
                this.m_visibleItems.clear();
            }
        }
        this.setSearchFilter("");
        this.m_sortedColumn = null;
    }

    public List<CmsListItem> getAllContent() {
        if (this.m_metadata.isSelfManaged()) {
            if (this.m_filteredItems != null) {
                return Collections.unmodifiableList(this.m_filteredItems);
            }
            return Collections.emptyList();
        }
        if (this.m_originalItems != null) {
            return Collections.unmodifiableList(this.m_originalItems);
        }
        return Collections.emptyList();
    }

    public List<CmsListItem> getContent() {
        if (this.m_filteredItems == null) {
            return this.getAllContent();
        }
        return Collections.unmodifiableList(this.m_filteredItems);
    }

    public int getCurrentPage() {
        return this.m_currentPage;
    }

    public List<CmsListItem> getCurrentPageItems() {
        if (this.getSize() == 0) {
            return Collections.emptyList();
        }
        if (this.m_metadata.isSelfManaged()) {
            return this.getContent();
        }
        return Collections.unmodifiableList(this.getContent().subList(this.displayedFrom() - 1, this.displayedTo()));
    }

    public CmsListOrderEnum getCurrentSortOrder() {
        return this.m_currentSortOrder;
    }

    public String getId() {
        return this.m_id;
    }

    public CmsListItem getItem(String id) {
        for (CmsListItem item : this.getAllContent()) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public int getMaxItemsPerPage() {
        return this.m_maxItemsPerPage;
    }

    public CmsListMetadata getMetadata() {
        return this.m_metadata;
    }

    public CmsMessageContainer getName() {
        return this.m_name;
    }

    public int getNumberOfPages() {
        return (int)Math.ceil((double)this.getSize() / (double)this.getMaxItemsPerPage());
    }

    public String getSearchFilter() {
        return this.m_searchFilter;
    }

    public int getSize() {
        if (this.m_metadata.isSelfManaged() && this.m_size != 0) {
            return this.m_size;
        }
        return this.getContent().size();
    }

    public String getSortedColumn() {
        return this.m_sortedColumn;
    }

    public CmsListState getState() {
        return new CmsListState(this);
    }

    public int getTotalNumberOfPages() {
        return (int)Math.ceil((double)this.getTotalSize() / (double)this.getMaxItemsPerPage());
    }

    public int getTotalSize() {
        if (this.m_metadata.isSelfManaged() && this.m_totalSize != 0) {
            return this.m_totalSize;
        }
        return this.getAllContent().size();
    }

    public A_CmsListDialog getWp() {
        return this.m_wp;
    }

    public boolean isBoxed() {
        return this.m_isBoxed;
    }

    public boolean isPrintable() {
        return this.m_printable;
    }

    public boolean isShowTitle() {
        return this.m_showTitle;
    }

    public String listCsv() {
        StringBuffer csv = new StringBuffer(5120);
        csv.append(this.m_metadata.csvHeader());
        if (this.getContent().isEmpty()) {
            csv.append(this.m_metadata.csvEmptyList());
        } else {
            for (CmsListItem item : this.getContent()) {
                csv.append(this.m_metadata.csvItem(item));
            }
        }
        return this.getWp().resolveMacros(csv.toString());
    }

    public synchronized String listHtml() {
        CmsProgressThread thread = null;
        int progressOffset = 0;
        if (Thread.currentThread() instanceof CmsProgressThread) {
            thread = (CmsProgressThread)Thread.currentThread();
            progressOffset = thread.getProgress();
        }
        this.m_visibleItems = this.isPrintable() ? new ArrayList<CmsListItem>(this.getContent()) : new ArrayList<CmsListItem>(this.getCurrentPageItems());
        StringBuffer html = new StringBuffer(5120);
        html.append(this.htmlBegin());
        if (!this.isPrintable()) {
            html.append(this.htmlTitle());
            html.append(this.htmlToolBar());
        } else {
            html.append("<style type='text/css'>\n");
            html.append("td.listdetailitem, \n");
            html.append(".linkdisabled {\n");
            html.append("\tcolor: black;\n");
            html.append("}\n");
            html.append(".list th {\n");
            html.append("\tborder: 1px solid black;\n");
            html.append("}\n");
            html.append(".list {\n");
            html.append("\tborder: 1px solid black;\n");
            html.append("}\n");
            html.append("</style>");
        }
        html.append("<!--[if IE 7]>");
        html.append("<style type='text/css'>");
        html.append("table.list * { word-wrap: break-word !important; white-space: normal !important; }");
        html.append("table.list { table-layout: fixed; }");
        html.append("</style>");
        html.append("<![endif]-->");
        html.append("<table width='100%' cellpadding='1' cellspacing='0' class='list'>\n");
        html.append(this.m_metadata.htmlHeader(this));
        if (this.m_visibleItems.isEmpty()) {
            html.append(this.m_metadata.htmlEmptyTable());
        } else {
            Iterator<CmsListItem> itItems = this.m_visibleItems.iterator();
            boolean odd = true;
            int count = 0;
            while (itItems.hasNext()) {
                ++count;
                if (thread != null) {
                    if (thread.isInterrupted()) {
                        throw new CmsIllegalStateException(org.opencms.workplace.commons.Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                    }
                    thread.setProgress(count * (100 - progressOffset) / this.m_visibleItems.size() + progressOffset);
                    thread.setDescription(org.opencms.workplace.commons.Messages.get().getBundle(thread.getLocale()).key("GUI_PROGRESS_PUBLISH_STEP4_2", new Integer(count), new Integer(this.m_visibleItems.size())));
                }
                CmsListItem item = itItems.next();
                html.append(this.m_metadata.htmlItem(item, odd, this.isPrintable()));
                odd = !odd;
            }
        }
        html.append("</table>\n");
        if (!this.isPrintable()) {
            html.append(this.htmlPagingBar());
        }
        html.append(this.htmlEnd());
        return this.getWp().resolveMacros(html.toString());
    }

    public String listJs() {
        StringBuffer js = new StringBuffer(1024);
        CmsMessages messages = Messages.get().getBundle(this.getWp().getLocale());
        js.append("<script type='text/javascript' src='");
        js.append(CmsWorkplace.getSkinUri());
        js.append("jquery/unpacked/jquery.js'></script>\n");
        js.append("<script type='text/javascript' src='");
        js.append(CmsWorkplace.getSkinUri());
        js.append("jquery/unpacked/jquery.hint.js'></script>\n");
        js.append("<script type='text/javascript' src='");
        js.append(CmsWorkplace.getSkinUri());
        js.append("admin/javascript/list.js'></script>\n");
        if (!this.m_metadata.getMultiActions().isEmpty()) {
            js.append("<script type='text/javascript'>\n");
            js.append("\tvar ");
            js.append(NO_SELECTION_HELP_VAR);
            js.append(" = '");
            js.append(CmsStringUtil.escapeJavaScript(messages.key("GUI_LIST_ACTION_NO_SELECTION_0")));
            js.append("';\n");
            for (CmsListMultiAction action : this.m_metadata.getMultiActions()) {
                if (!(action instanceof CmsListRadioMultiAction)) continue;
                CmsListRadioMultiAction rAction = (CmsListRadioMultiAction)action;
                js.append("\tvar ");
                js.append(NO_SELECTION_MATCH_HELP_VAR);
                js.append(rAction.getId());
                js.append(" = '");
                js.append(CmsStringUtil.escapeJavaScript(messages.key("GUI_LIST_ACTION_NO_SELECTION_MATCH_1", new Integer(rAction.getSelections()))));
                js.append("';\n");
            }
            js.append("</script>\n");
        }
        return js.toString();
    }

    public CmsListItem newItem(String id) {
        return new CmsListItem(this.getMetadata(), id);
    }

    public String printableHtml() {
        this.m_printable = true;
        String html = this.listHtml();
        this.m_printable = false;
        return html;
    }

    public CmsListItem removeItem(String id) {
        CmsListItem item = this.getItem(id);
        if (item == null) {
            return null;
        }
        CmsListState state = null;
        if (this.m_filteredItems != null || this.m_visibleItems != null) {
            state = this.getState();
        }
        this.m_originalItems.remove(item);
        if (this.m_filteredItems != null) {
            this.m_filteredItems.remove(item);
        }
        if (this.m_visibleItems != null) {
            this.m_visibleItems.remove(item);
        }
        if (state != null) {
            this.setState(state);
        }
        return item;
    }

    public void setBoxed(boolean isBoxed) {
        this.m_isBoxed = isBoxed;
    }

    public void setContent(Collection<CmsListItem> listItems) {
        if (this.m_metadata.isSelfManaged()) {
            this.m_filteredItems = new ArrayList<CmsListItem>(listItems);
            this.m_originalItems = null;
        } else {
            this.m_filteredItems = null;
            this.m_originalItems = new ArrayList<CmsListItem>(listItems);
        }
    }

    public void setCurrentPage(int currentPage) throws CmsIllegalArgumentException {
        if (this.getSize() != 0 && (currentPage < 1 || currentPage > this.getNumberOfPages())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LIST_INVALID_PAGE_1", new Integer(currentPage)));
        }
        this.m_currentPage = currentPage;
    }

    public void setMaxItemsPerPage(int maxItemsPerPage) {
        this.m_maxItemsPerPage = maxItemsPerPage;
    }

    public void setName(CmsMessageContainer name) {
        this.m_name = name;
    }

    public void setSearchFilter(String searchFilter) {
        if (!this.m_metadata.isSearchable()) {
            return;
        }
        if (searchFilter == null) {
            searchFilter = "";
        }
        this.m_searchFilter = searchFilter;
        boolean showAll = CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_searchFilter);
        this.getMetadata().getSearchAction().getShowAllAction().setVisible(showAll);
        if (!this.m_metadata.isSelfManaged()) {
            this.m_filteredItems = CmsStringUtil.isEmptyOrWhitespaceOnly(searchFilter) ? null : this.getMetadata().getSearchAction().filter(this.getAllContent(), this.m_searchFilter);
        }
        String sCol = this.m_sortedColumn;
        this.m_sortedColumn = "";
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(sCol)) {
            CmsListOrderEnum order = this.getCurrentSortOrder();
            this.setSortedColumn(sCol);
            if (order == CmsListOrderEnum.ORDER_DESCENDING) {
                this.setSortedColumn(sCol);
            }
        }
        this.setCurrentPage(1);
    }

    public void setShowTitle(boolean showTitle) {
        this.m_showTitle = showTitle;
    }

    public void setSize(int size) {
        this.m_size = size;
    }

    public void setSortedColumn(String sortedColumn) throws CmsIllegalArgumentException {
        if (this.getMetadata().getColumnDefinition(sortedColumn) == null || !this.getMetadata().getColumnDefinition(sortedColumn).isSorteable()) {
            return;
        }
        this.setCurrentPage(1);
        if (sortedColumn.equals(this.m_sortedColumn)) {
            this.m_currentSortOrder = this.m_currentSortOrder == CmsListOrderEnum.ORDER_ASCENDING ? CmsListOrderEnum.ORDER_DESCENDING : CmsListOrderEnum.ORDER_ASCENDING;
            if (!this.m_metadata.isSelfManaged()) {
                if (this.m_filteredItems == null) {
                    this.m_filteredItems = new ArrayList<CmsListItem>(this.getAllContent());
                }
                Collections.reverse(this.m_filteredItems);
            }
            return;
        }
        this.m_sortedColumn = sortedColumn;
        this.m_currentSortOrder = CmsListOrderEnum.ORDER_ASCENDING;
        if (!this.m_metadata.isSelfManaged()) {
            if (this.m_filteredItems == null) {
                this.m_filteredItems = new ArrayList<CmsListItem>(this.getAllContent());
            }
            I_CmsListItemComparator c = this.getMetadata().getColumnDefinition(sortedColumn).getListItemComparator();
            Collections.sort(this.m_filteredItems, c.getComparator(sortedColumn, this.getWp().getLocale()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(CmsListState listState) {
        if (!this.m_metadata.isSelfManaged()) {
            this.m_filteredItems = null;
        }
        CmsHtmlList cmsHtmlList = this;
        synchronized (cmsHtmlList) {
            if (this.m_visibleItems != null) {
                this.m_visibleItems.clear();
            }
        }
        this.setSearchFilter(listState.getFilter());
        this.setSortedColumn(listState.getColumn());
        if (listState.getOrder() == CmsListOrderEnum.ORDER_DESCENDING) {
            this.setSortedColumn(listState.getColumn());
        }
        if (listState.getPage() > 0) {
            if (listState.getPage() <= this.getNumberOfPages()) {
                this.setCurrentPage(listState.getPage());
            } else {
                this.setCurrentPage(1);
            }
        }
    }

    public void setTotalSize(int totalSize) {
        this.m_totalSize = totalSize;
    }

    public void setWp(A_CmsListDialog wp) {
        this.m_wp = wp;
        this.m_metadata.setWp(wp);
    }

    protected int displayedFrom() {
        if (this.getSize() != 0) {
            if (this.isPrintable()) {
                return 1;
            }
            return (this.getCurrentPage() - 1) * this.getMaxItemsPerPage() + 1;
        }
        return 0;
    }

    protected int displayedTo() {
        if (this.getSize() != 0 && !this.isPrintable() && this.getCurrentPage() * this.getMaxItemsPerPage() < this.getSize()) {
            return this.getCurrentPage() * this.getMaxItemsPerPage();
        }
        return this.getSize();
    }

    protected String htmlBegin() {
        StringBuffer html = new StringBuffer(512);
        if (!this.isPrintable() && this.m_visibleItems != null && !this.m_visibleItems.isEmpty()) {
            for (CmsListColumnDefinition col : this.getMetadata().getColumnDefinitions()) {
                for (I_CmsListDirectAction action : col.getDirectActions()) {
                    action.setItem(this.m_visibleItems.get(0));
                    html.append(action.helpTextHtml());
                    html.append(action.confirmationTextHtml());
                }
                for (I_CmsListDirectAction i_CmsListDirectAction : col.getDefaultActions()) {
                    i_CmsListDirectAction.setItem(this.m_visibleItems.get(0));
                    html.append(i_CmsListDirectAction.helpTextHtml());
                    html.append(i_CmsListDirectAction.confirmationTextHtml());
                }
            }
        }
        html.append("<div class='listArea'>\n");
        if (this.isBoxed()) {
            html.append(this.getWp().dialogBlock(0, this.m_name.key(this.getWp().getLocale()), false));
        }
        html.append("\t\t<table width='100%' cellspacing='0' cellpadding='0' border='0'>\n");
        html.append("\t\t\t<tr><td>\n");
        return html.toString();
    }

    protected String htmlEnd() {
        StringBuffer html = new StringBuffer(512);
        html.append("\t\t\t</td></tr>\n");
        html.append("\t\t</table>\n");
        if (this.isBoxed()) {
            html.append(this.getWp().dialogBlock(1, this.m_name.key(this.getWp().getLocale()), false));
        }
        html.append("</div>\n");
        return html.toString();
    }

    protected String htmlPagingBar() {
        if (this.getNumberOfPages() < 2) {
            return "";
        }
        StringBuffer html = new StringBuffer(1024);
        CmsMessages messages = Messages.get().getBundle(this.getWp().getLocale());
        html.append("<table width='100%' cellspacing='0' style='margin-top: 5px;'>\n");
        html.append("\t<tr>\n");
        html.append("\t\t<td class='main'>\n");
        String id = "listPrev";
        String name = messages.key("GUI_LIST_PAGING_PREVIOUS_NAME_0");
        String iconPath = ICON_LEFT;
        boolean enabled = this.getCurrentPage() > 1;
        String helpText = messages.key("GUI_LIST_PAGING_PREVIOUS_HELP_0");
        if (!enabled) {
            helpText = messages.key("GUI_LIST_PAGING_PREVIOUS_HELPDIS_0");
        }
        String onClic = "listSetPage('" + this.getId() + "', " + (this.getCurrentPage() - 1) + ")";
        html.append(A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, id, name, helpText, enabled, iconPath, null, onClic));
        html.append("\n");
        id = "listNext";
        name = messages.key("GUI_LIST_PAGING_NEXT_NAME_0");
        iconPath = ICON_RIGHT;
        enabled = this.getCurrentPage() < this.getNumberOfPages();
        helpText = messages.key("GUI_LIST_PAGING_NEXT_HELP_0");
        if (!enabled) {
            helpText = messages.key("GUI_LIST_PAGING_NEXT_HELPDIS_0");
        }
        onClic = "listSetPage('" + this.getId() + "', " + (this.getCurrentPage() + 1) + ")";
        html.append(A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, id, name, helpText, enabled, iconPath, null, onClic));
        html.append("\n");
        html.append("\t\t\t&nbsp;&nbsp;&nbsp;");
        html.append("\t\t\t<select name='listPageSet' id='id-page_set' onChange =\"listSetPage('");
        html.append(this.getId());
        html.append("', this.value);\" style='vertical-align: bottom;'>\n");
        html.append(CmsHtmlList.htmlPageSelector(this.getNumberOfPages(), this.getMaxItemsPerPage(), this.getSize(), this.getCurrentPage(), this.getWp().getLocale()));
        html.append("\t\t\t</select>\n");
        html.append("\t\t\t&nbsp;&nbsp;&nbsp;");
        boolean isNotSearching = true;
        if (this.getMetadata().isSearchable()) {
            isNotSearching = CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_searchFilter);
        }
        if (isNotSearching) {
            html.append(messages.key("GUI_LIST_PAGING_TEXT_2", new Object[]{this.m_name.key(this.getWp().getLocale()), new Integer(this.getTotalSize())}));
        } else {
            html.append(messages.key("GUI_LIST_PAGING_FILTER_TEXT_3", new Object[]{this.m_name.key(this.getWp().getLocale()), new Integer(this.getSize()), new Integer(this.getTotalSize())}));
        }
        html.append("\t\t</td>\n");
        html.append("\t</tr>\n");
        html.append("</table>\n");
        return html.toString();
    }

    protected String htmlTitle() {
        boolean showTitle = this.isShowTitle();
        Iterator<I_CmsListAction> itIndepActions = this.getMetadata().getIndependentActions().iterator();
        while (!showTitle && itIndepActions.hasNext()) {
            I_CmsListAction indepAction = itIndepActions.next();
            showTitle = showTitle || indepAction.isVisible();
        }
        Iterator<CmsListItemDetails> itItemDetails = this.getMetadata().getItemDetailDefinitions().iterator();
        while (!showTitle && itItemDetails.hasNext()) {
            CmsListItemDetails itemDetail = itItemDetails.next();
            showTitle = showTitle || itemDetail.getAction().isVisible();
        }
        if (!showTitle) {
            return "";
        }
        StringBuffer html = new StringBuffer(512);
        CmsMessages messages = Messages.get().getBundle(this.getWp().getLocale());
        html.append("<table width='100%' cellspacing='0'>");
        html.append("\t<tr>\n");
        if (this.isShowTitle()) {
            html.append("\t\t<td align='left'>\n");
            html.append("\t\t\t");
            boolean isNotSearching = true;
            if (this.getMetadata().isSearchable()) {
                isNotSearching = CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_searchFilter);
            }
            if (this.getTotalNumberOfPages() > 1) {
                if (isNotSearching) {
                    html.append(messages.key("GUI_LIST_TITLE_TEXT_4", new Object[]{this.m_name.key(this.getWp().getLocale()), new Integer(this.displayedFrom()), new Integer(this.displayedTo()), new Integer(this.getTotalSize())}));
                } else {
                    html.append(messages.key("GUI_LIST_TITLE_FILTERED_TEXT_5", new Object[]{this.m_name.key(this.getWp().getLocale()), new Integer(this.displayedFrom()), new Integer(this.displayedTo()), new Integer(this.getSize()), new Integer(this.getTotalSize())}));
                }
            } else if (isNotSearching) {
                html.append(messages.key("GUI_LIST_SINGLE_TITLE_TEXT_2", new Object[]{this.m_name.key(this.getWp().getLocale()), new Integer(this.getTotalSize())}));
            } else {
                html.append(messages.key("GUI_LIST_SINGLE_TITLE_FILTERED_TEXT_3", new Object[]{this.m_name.key(this.getWp().getLocale()), new Integer(this.getSize()), new Integer(this.getTotalSize())}));
            }
            html.append("\n");
            html.append("\t\t</td>\n\t\t");
        }
        html.append(this.getMetadata().htmlActionBar());
        html.append("\n\t</tr>\n");
        html.append("</table>\n");
        return html.toString();
    }

    protected String htmlToolBar() {
        boolean showToolBar = this.getMetadata().isSearchable();
        Iterator<CmsListMultiAction> itMultiActions = this.getMetadata().getMultiActions().iterator();
        while (!showToolBar && itMultiActions.hasNext()) {
            CmsListMultiAction multiAction = itMultiActions.next();
            showToolBar = showToolBar || multiAction.isVisible();
        }
        if (!showToolBar) {
            return "";
        }
        StringBuffer html = new StringBuffer(512);
        html.append("<table width='100%' cellspacing='0' style='margin-bottom: 5px'>\n");
        html.append("\t<tr>\n");
        html.append(this.m_metadata.htmlSearchBar());
        html.append(this.m_metadata.htmlMultiActionBar());
        html.append("\t</tr>\n");
        html.append("</table>\n");
        return html.toString();
    }

    protected void setMetadata(CmsListMetadata metadata) {
        this.m_metadata = metadata;
    }
}

