/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListAction;
import org.opencms.workplace.list.Messages;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;

public class CmsListIndependentAction
extends A_CmsListAction {
    public static final String ACTION_EXPLORER_SWITCH_ID = "iaes";

    public CmsListIndependentAction(String id) {
        super(id);
    }

    protected String resolveOnClic(CmsWorkplace wp) {
        return "listIndepAction('" + this.getListId() + "','" + this.getId() + "', '" + CmsStringUtil.escapeJavaScript(wp.resolveMacros(this.getConfirmationMessage().key(wp.getLocale()))) + "');";
    }

    public String buttonHtml(CmsWorkplace wp) {
        if (!this.isVisible()) {
            return "";
        }
        return A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, this.getId(), this.getName().key(wp.getLocale()), this.getHelpText().key(wp.getLocale()), this.isEnabled(), this.getIconPath(), null, this.resolveOnClic(wp));
    }

    public static CmsListIndependentAction getDefaultExplorerSwitchAction() {
        CmsListIndependentAction defAction = new CmsListIndependentAction(ACTION_EXPLORER_SWITCH_ID);
        defAction.setName(Messages.get().container("GUI_LIST_ACTION_EXPLORER_SWITCH_NAME_0"));
        defAction.setHelpText(Messages.get().container("GUI_LIST_ACTION_EXPLORER_SWITCH_HELP_0"));
        defAction.setConfirmationMessage(Messages.get().container("GUI_LIST_ACTION_EXPLORER_SWITCH_CONF_0"));
        defAction.setIconPath("list/explorer.png");
        defAction.setEnabled(true);
        defAction.setVisible(true);
        return defAction;
    }
}

