/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsHtmlList;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListRadioMultiAction;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.Messages;
import org.opencms.workplace.tools.CmsIdentifiableObjectContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsListMetadata {
    public static final String SEARCH_BAR_INPUT_ID = "listSearchFilter";
    private CmsIdentifiableObjectContainer<CmsListColumnDefinition> m_columns = new CmsIdentifiableObjectContainer(true, false);
    private CmsIdentifiableObjectContainer<I_CmsListAction> m_indepActions = new CmsIdentifiableObjectContainer(true, false);
    private CmsIdentifiableObjectContainer<CmsListItemDetails> m_itemDetails = new CmsIdentifiableObjectContainer(true, false);
    private String m_listId;
    private CmsIdentifiableObjectContainer<CmsListMultiAction> m_multiActions = new CmsIdentifiableObjectContainer(true, false);
    private CmsListSearchAction m_searchAction;
    private boolean m_selfManaged;
    private boolean m_volatile;
    private transient A_CmsListDialog m_wp;

    public CmsListMetadata(String listId) {
        this.m_listId = listId;
    }

    public void addColumn(CmsListColumnDefinition listColumn) {
        this.addColumn(listColumn, this.m_columns.elementList().size());
    }

    public void addColumn(CmsListColumnDefinition listColumn, int position) {
        this.setListIdForColumn(listColumn);
        if (this.m_columns.elementList().isEmpty()) {
            listColumn.setPrintable(true);
        } else {
            listColumn.setPrintable(listColumn.isSorteable());
        }
        if (listColumn.getName() == null && listColumn.isPrintable()) {
            listColumn.setPrintable(false);
        }
        this.m_columns.addIdentifiableObject(listColumn.getId(), listColumn, position);
    }

    public void addIndependentAction(I_CmsListAction action) {
        action.setListId(this.getListId());
        this.m_indepActions.addIdentifiableObject(action.getId(), action);
    }

    public void addItemDetails(CmsListItemDetails itemDetail) {
        itemDetail.setListId(this.getListId());
        this.m_itemDetails.addIdentifiableObject(itemDetail.getId(), itemDetail);
    }

    public void addItemDetails(CmsListItemDetails itemDetail, int position) {
        itemDetail.setListId(this.getListId());
        this.m_itemDetails.addIdentifiableObject(itemDetail.getId(), itemDetail, position);
    }

    public void addMultiAction(CmsListMultiAction multiAction) {
        multiAction.setListId(this.getListId());
        this.m_multiActions.addIdentifiableObject(multiAction.getId(), multiAction);
    }

    public String csvEmptyList() {
        StringBuffer html = new StringBuffer(512);
        html.append("\n");
        return html.toString();
    }

    public String csvHeader() {
        StringBuffer csv = new StringBuffer(1024);
        for (CmsListColumnDefinition col : this.m_columns.elementList()) {
            if (!col.isVisible()) continue;
            csv.append(col.csvHeader());
            csv.append("\t");
        }
        csv.append("\n\n");
        return csv.toString();
    }

    public String csvItem(CmsListItem item) {
        StringBuffer csv = new StringBuffer(1024);
        for (CmsListColumnDefinition col : this.m_columns.elementList()) {
            if (!col.isVisible()) continue;
            csv.append(col.csvCell(item));
            csv.append("\t");
        }
        csv.append("\n");
        return csv.toString();
    }

    public CmsListColumnDefinition getColumnDefinition(String columnId) {
        return this.m_columns.getObject(columnId);
    }

    public List<CmsListColumnDefinition> getColumnDefinitions() {
        return this.m_columns.elementList();
    }

    public I_CmsListAction getIndependentAction(String actionId) {
        return this.m_indepActions.getObject(actionId);
    }

    public List<I_CmsListAction> getIndependentActions() {
        return this.m_indepActions.elementList();
    }

    public CmsListItemDetails getItemDetailDefinition(String itemDetailId) {
        return this.m_itemDetails.getObject(itemDetailId);
    }

    public List<CmsListItemDetails> getItemDetailDefinitions() {
        return this.m_itemDetails.elementList();
    }

    public String getListId() {
        return this.m_listId;
    }

    public CmsListMultiAction getMultiAction(String actionId) {
        return this.m_multiActions.getObject(actionId);
    }

    public List<CmsListMultiAction> getMultiActions() {
        return this.m_multiActions.elementList();
    }

    public CmsListSearchAction getSearchAction() {
        return this.m_searchAction;
    }

    public int getWidth() {
        return this.m_columns.elementList().size() + (this.hasCheckMultiActions() ? 1 : 0);
    }

    public A_CmsListDialog getWp() {
        return this.m_wp;
    }

    public boolean hasActions() {
        return !this.m_indepActions.elementList().isEmpty();
    }

    public boolean hasCheckMultiActions() {
        for (CmsListMultiAction action : this.m_multiActions.elementList()) {
            if (action instanceof CmsListRadioMultiAction) continue;
            return true;
        }
        return false;
    }

    public boolean hasMultiActions() {
        return !this.m_multiActions.elementList().isEmpty();
    }

    public boolean hasSingleActions() {
        for (CmsListColumnDefinition col : this.m_columns.elementList()) {
            if (col.getDefaultActions().isEmpty() && col.getDirectActions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String htmlActionBar() {
        StringBuffer html = new StringBuffer(1024);
        html.append("<td class='misc'>\n");
        html.append("\t<div>\n");
        Iterator<CmsListItemDetails> itDetails = this.m_itemDetails.elementList().iterator();
        while (itDetails.hasNext()) {
            I_CmsListAction detailAction = itDetails.next().getAction();
            html.append("\t\t");
            html.append(detailAction.buttonHtml());
            if (itDetails.hasNext()) {
                html.append("&nbsp;");
            }
            html.append("\n");
        }
        for (I_CmsListAction indepAction : this.m_indepActions.elementList()) {
            html.append("\t\t");
            html.append("&nbsp;");
            html.append(indepAction.buttonHtml());
            html.append("\n");
        }
        html.append("\t</div>\n");
        html.append("</td>\n");
        return html.toString();
    }

    public String htmlEmptyTable() {
        StringBuffer html = new StringBuffer(512);
        html.append("<tr class='oddrowbg'>\n");
        html.append("\t<td align='center' colspan='");
        html.append(this.getWidth());
        html.append("'>\n");
        html.append(Messages.get().getBundle(this.getWp().getLocale()).key("GUI_LIST_EMPTY_0"));
        html.append("\t</td>\n");
        html.append("</tr>\n");
        return html.toString();
    }

    public String htmlHeader(CmsHtmlList list) {
        StringBuffer html = new StringBuffer(1024);
        html.append("<tr>\n");
        for (CmsListColumnDefinition col : this.m_columns.elementList()) {
            if (!col.isVisible() && !list.isPrintable() || !col.isPrintable() && list.isPrintable()) continue;
            html.append(col.htmlHeader(list));
        }
        if (!list.isPrintable() && this.hasCheckMultiActions()) {
            html.append("\t<th width='0' class='select'>\n");
            html.append("\t\t<input type='checkbox' class='checkbox' name='listSelectAll' value='true' onClick=\"listSelect('");
            html.append(list.getId());
            html.append("')\">\n");
            html.append("\t</th>\n");
        }
        html.append("</tr>\n");
        return html.toString();
    }

    public String htmlItem(CmsListItem item, boolean odd, boolean isPrintable) {
        StringBuffer html = new StringBuffer(1024);
        html.append("<tr ");
        if (!isPrintable) {
            html.append("class='");
            html.append(odd ? "oddrowbg" : (this.getWp().useNewStyle() ? "evenrowbg" : "evenrowbgnew"));
            html.append("'");
        }
        html.append(">\n");
        Iterator<CmsListColumnDefinition> itCols = this.m_columns.elementList().iterator();
        int width = 0;
        while (itCols.hasNext()) {
            CmsListColumnDefinition col = itCols.next();
            if (!col.isVisible() && !isPrintable || !col.isPrintable() && isPrintable) continue;
            ++width;
            StringBuffer style = new StringBuffer(64);
            html.append("<td");
            CmsListColumnAlignEnum align = col.getAlign();
            if (align != CmsListColumnAlignEnum.ALIGN_LEFT && CmsStringUtil.isNotEmpty(align.toString())) {
                style.append("text-align: ");
                style.append(col.getAlign());
                style.append("; ");
            }
            if (col.isTextWrapping()) {
                style.append("white-space: normal;");
            }
            if (isPrintable) {
                style.append("border-top: 1px solid black;");
            }
            if (style.length() > 0) {
                html.append(" style='");
                html.append(style);
                html.append("'");
            }
            html.append(">\n");
            html.append(col.htmlCell(item, isPrintable));
            html.append("</td>\n");
        }
        if (!isPrintable && this.hasCheckMultiActions()) {
            ++width;
            html.append("\t<td class='select' style='text-align: center'>\n");
            html.append("\t\t<input type='checkbox' class='checkbox' name='listMultiAction' value='");
            html.append(item.getId());
            html.append("'>\n");
            html.append("\t</td>\n");
        }
        html.append("</tr>\n");
        for (CmsListItemDetails lid : this.m_itemDetails.elementList()) {
            if (!lid.isVisible() && !isPrintable || !lid.isPrintable() && isPrintable || item.get(lid.getId()) == null || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(item.get(lid.getId()).toString())) continue;
            int padCols = 0;
            for (CmsListColumnDefinition col : this.m_columns.elementList()) {
                if (col.getId().equals(lid.getAtColumn())) break;
                if (!col.isVisible() && !isPrintable || !col.isPrintable() && isPrintable) continue;
                ++padCols;
            }
            int spanCols = width - padCols;
            html.append("<tr ");
            if (!isPrintable) {
                html.append("class='");
                html.append(odd ? "oddrowbg" : (this.getWp().useNewStyle() ? "evenrowbg" : "evenrowbgnew"));
                html.append("'");
            }
            html.append(">\n");
            if (padCols > 0) {
                html.append("<td colspan='");
                html.append(padCols);
                html.append("'>&nbsp;</td>\n");
            }
            html.append("<td colspan='");
            html.append(spanCols);
            html.append("' style='padding-left: 20px; white-space:normal;'>\n");
            html.append(lid.htmlCell(item, isPrintable));
            html.append("\n</td>\n");
            html.append("\n");
            html.append("</tr>\n");
        }
        return html.toString();
    }

    public String htmlMultiActionBar() {
        StringBuffer html = new StringBuffer(1024);
        html.append("<td class='misc'>\n");
        html.append("\t<div>\n");
        Iterator<CmsListMultiAction> itActions = this.m_multiActions.elementList().iterator();
        while (itActions.hasNext()) {
            CmsListMultiAction multiAction = itActions.next();
            html.append("\t\t");
            html.append(multiAction.buttonHtml());
            if (itActions.hasNext()) {
                html.append("&nbsp;&nbsp;");
            }
            html.append("\n");
        }
        html.append("\t</div>\n");
        html.append("</td>\n");
        return html.toString();
    }

    public String htmlSearchBar() {
        if (!this.isSearchable()) {
            return "";
        }
        StringBuffer html = new StringBuffer(1024);
        html.append("<td class='main'>\n");
        html.append("\t<div>\n");
        html.append("\t\t<input type='text' name='listSearchFilter' id='listSearchFilter' value='' size='20' maxlength='245' style='vertical-align: bottom;'>\n");
        html.append(this.m_searchAction.buttonHtml());
        I_CmsListAction showAllAction = this.m_searchAction.getShowAllAction();
        if (showAllAction != null) {
            html.append("&nbsp;&nbsp;");
            html.append(showAllAction.buttonHtml());
        }
        html.append("\t</div>\n");
        html.append("</td>\n");
        return html.toString();
    }

    public boolean isSearchable() {
        return this.m_searchAction != null;
    }

    public boolean isSelfManaged() {
        return this.m_selfManaged;
    }

    public boolean isSorteable() {
        for (CmsListColumnDefinition col : this.m_columns.elementList()) {
            if (!col.isSorteable()) continue;
            return true;
        }
        return false;
    }

    public boolean isVolatile() {
        return this.m_volatile;
    }

    public void setSearchAction(CmsListSearchAction searchAction) {
        this.m_searchAction = searchAction;
        if (this.m_searchAction != null) {
            this.m_searchAction.setListId(this.getListId());
        }
    }

    public void setSelfManaged(boolean selfManaged) {
        this.m_selfManaged = selfManaged;
    }

    public void setVolatile(boolean volatileFlag) {
        this.m_volatile = volatileFlag;
    }

    public void setWp(A_CmsListDialog wp) {
        this.m_wp = wp;
        for (CmsListColumnDefinition column : this.getColumnDefinitions()) {
            column.setWp(wp);
        }
        for (CmsListItemDetails detail : this.getItemDetailDefinitions()) {
            detail.setWp(wp);
        }
        for (CmsListMultiAction action : this.getMultiActions()) {
            action.setWp(wp);
        }
        for (I_CmsListAction action : this.getIndependentActions()) {
            action.setWp(wp);
        }
        if (this.m_searchAction != null) {
            this.m_searchAction.setWp(wp);
        }
    }

    public void toogleDetailState(String itemDetailId) {
        CmsListItemDetails lid;
        lid.setVisible(!(lid = this.m_itemDetails.getObject(itemDetailId)).isVisible());
    }

    void checkIds() {
        TreeSet<String> ids = new TreeSet<String>();
        Iterator<I_CmsListAction> itIndepActions = this.getIndependentActions().iterator();
        while (itIndepActions.hasNext()) {
            String id = itIndepActions.next().getId();
            if (ids.contains(id)) {
                throw new CmsIllegalStateException(Messages.get().container("ERR_DUPLICATED_ID_1", id));
            }
            ids.add(id);
        }
        Iterator<CmsListMultiAction> itMultiActions = this.getMultiActions().iterator();
        while (itMultiActions.hasNext()) {
            String id = itMultiActions.next().getId();
            if (ids.contains(id)) {
                throw new CmsIllegalStateException(Messages.get().container("ERR_DUPLICATED_ID_1", id));
            }
            ids.add(id);
        }
        Iterator<CmsListItemDetails> itItemDetails = this.getItemDetailDefinitions().iterator();
        while (itItemDetails.hasNext()) {
            String id = itItemDetails.next().getId();
            if (ids.contains(id)) {
                throw new CmsIllegalStateException(Messages.get().container("ERR_DUPLICATED_ID_1", id));
            }
            ids.add(id);
        }
        for (CmsListColumnDefinition col : this.getColumnDefinitions()) {
            if (ids.contains(col.getId())) {
                throw new CmsIllegalStateException(Messages.get().container("ERR_DUPLICATED_ID_1", col.getId()));
            }
            ids.add(col.getId());
            for (CmsListDefaultAction action : col.getDefaultActions()) {
                if (ids.contains(action.getId())) {
                    throw new CmsIllegalStateException(Messages.get().container("ERR_DUPLICATED_ID_1", action.getId()));
                }
                ids.add(action.getId());
            }
            for (I_CmsListDirectAction action : col.getDirectActions()) {
                if (ids.contains(action.getId())) {
                    throw new CmsIllegalStateException(Messages.get().container("ERR_DUPLICATED_ID_1", action.getId()));
                }
                ids.add(action.getId());
            }
        }
    }

    private void setListIdForColumn(CmsListColumnDefinition col) {
        col.setListId(this.getListId());
        Iterator<CmsListDefaultAction> itDefaultActions = col.getDefaultActions().iterator();
        while (itDefaultActions.hasNext()) {
            itDefaultActions.next().setListId(this.getListId());
        }
        Iterator<I_CmsListDirectAction> itDirectActions = col.getDirectActions().iterator();
        while (itDirectActions.hasNext()) {
            itDirectActions.next().setListId(this.getListId());
        }
    }
}

