/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.A_CmsListSearchAction;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsListSearchAction
extends A_CmsListSearchAction {
    public static final String SEARCH_BAR_INPUT_ID = "listSearchFilter";
    private boolean m_caseInSensitive;
    private final List<CmsListColumnDefinition> m_columns = new ArrayList<CmsListColumnDefinition>();

    public CmsListSearchAction(CmsListColumnDefinition column) {
        this.useDefaultShowAllAction();
        this.m_columns.add(column);
    }

    public void addColumn(CmsListColumnDefinition column) {
        this.m_columns.add(column);
    }

    public String barHtml(CmsWorkplace wp) {
        if (wp == null) {
            wp = this.getWp();
        }
        StringBuffer html = new StringBuffer(1024);
        html.append("\t\t<input type='text' name='");
        html.append(SEARCH_BAR_INPUT_ID);
        html.append("' id='");
        html.append(SEARCH_BAR_INPUT_ID);
        html.append("' value='");
        if (wp instanceof A_CmsListDialog) {
            html.append(CmsStringUtil.escapeJavaScript(CmsEncoder.escapeXml(((A_CmsListDialog)wp).getList().getSearchFilter())));
        }
        html.append("' size='20' maxlength='245' style='vertical-align: bottom;' >\n");
        html.append(this.buttonHtml(wp));
        if (this.getShowAllAction() != null) {
            html.append("&nbsp;&nbsp;");
            html.append(this.getShowAllAction().buttonHtml());
        }
        return html.toString();
    }

    @Override
    public String buttonHtml(CmsWorkplace wp) {
        if (this.getHelpText() == EMPTY_MESSAGE) {
            String columns = "";
            Iterator<CmsListColumnDefinition> it = this.m_columns.iterator();
            while (it.hasNext()) {
                CmsListColumnDefinition col = it.next();
                columns = columns + "${key." + col.getName().getKey() + "}";
                if (!it.hasNext()) continue;
                columns = columns + ", ";
            }
            if (columns.lastIndexOf(", ") > 0) {
                columns = columns.substring(0, columns.lastIndexOf(", ")) + " and " + columns.substring(columns.lastIndexOf(", ") + 2);
            }
            this.setHelpText(new CmsMessageContainer(Messages.get(), "GUI_LIST_ACTION_SEARCH_HELP_1", columns));
        }
        return super.buttonHtml(wp);
    }

    public List<CmsListItem> filter(List<CmsListItem> items, String filter) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(filter)) {
            return items;
        }
        String filterCriteria = filter;
        if (this.m_caseInSensitive) {
            filterCriteria = filter.toLowerCase();
        }
        ArrayList<CmsListItem> res = new ArrayList<CmsListItem>();
        block0: for (CmsListItem item : items) {
            if (res.contains(item)) continue;
            for (CmsListColumnDefinition col : this.m_columns) {
                if (item.get(col.getId()) == null) continue;
                String columnValue = item.get(col.getId()).toString();
                if (this.m_caseInSensitive) {
                    columnValue = columnValue.toLowerCase();
                }
                if (columnValue.indexOf(filterCriteria) <= -1) continue;
                res.add(item);
                continue block0;
            }
        }
        return res;
    }

    public List<CmsListColumnDefinition> getColumns() {
        return Collections.unmodifiableList(this.m_columns);
    }

    public boolean isCaseInSensitive() {
        return this.m_caseInSensitive;
    }

    public void setCaseInSensitive(boolean caseInSensitive) {
        this.m_caseInSensitive = caseInSensitive;
    }

    @Deprecated
    public void setSearchFilter(String filter) {
    }

    @Override
    public void setWp(A_CmsListDialog wp) {
        super.setWp(wp);
        if (this.getShowAllAction() != null) {
            this.getShowAllAction().setWp(wp);
        }
    }
}

