/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsUUID;
import org.opencms.util.I_CmsMacroResolver;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.tools.Messages;

public class CmsToolMacroResolver
implements I_CmsMacroResolver {
    public static final String PREFIX_ADMIN = "admin.";
    public static final String KEY_USERNAME = "userName.";
    public static final String KEY_GROUPNAME = "groupName.";
    public static final String KEY_JOBNAME = "jobName.";
    public static final String KEY_PROJECTNAME = "projectName.";
    public static final String KEY_OUDESCRIPTION = "ouDescription.";
    public static final String KEY_OUTYPE = "ouType.";
    public static final String KEY_ROLENAME = "roleName.";
    public static final String[] VALUE_NAME_ARRAY = new String[]{"userName.", "groupName.", "jobName.", "projectName.", "ouDescription.", "ouType.", "roleName."};
    public static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList(VALUE_NAME_ARRAY));
    private CmsWorkplace m_wp;

    public CmsToolMacroResolver(CmsWorkplace wp) {
        this.m_wp = wp;
    }

    public static String resolveMacros(String input, CmsWorkplace wp) {
        return new CmsToolMacroResolver(wp).resolveMacros(input);
    }

    public String getMacroValue(String macro) {
        if (!macro.startsWith(PREFIX_ADMIN)) {
            return this.m_wp.getMacroResolver().getMacroValue(macro);
        }
        macro = macro.substring(PREFIX_ADMIN.length());
        String id = null;
        for (String cmd : VALUE_NAMES) {
            if (!macro.startsWith(cmd)) continue;
            id = macro.substring(cmd.length());
            macro = cmd;
        }
        if (id == null) {
            return null;
        }
        try {
            if (macro == KEY_USERNAME) {
                return this.m_wp.getCms().readUser(new CmsUUID(id)).getSimpleName();
            }
            if (macro == KEY_GROUPNAME) {
                return this.m_wp.getCms().readGroup(new CmsUUID(id)).getSimpleName();
            }
            if (macro == KEY_PROJECTNAME) {
                return this.m_wp.getCms().readProject(new CmsUUID(id)).getSimpleName();
            }
            if (macro == KEY_JOBNAME) {
                return OpenCms.getScheduleManager().getJob(id).getJobName();
            }
            if (macro == KEY_OUDESCRIPTION) {
                return OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_wp.getCms(), id).getDisplayName(this.m_wp.getLocale());
            }
            if (macro == KEY_OUTYPE) {
                if (OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_wp.getCms(), id).hasFlagWebuser()) {
                    return Messages.get().getBundle(this.m_wp.getLocale()).key("GUI_OU_TYPE_WEBUSER_0");
                }
                return Messages.get().getBundle(this.m_wp.getLocale()).key("GUI_OU_TYPE_NORMAL_0");
            }
            if (macro == KEY_ROLENAME) {
                return CmsRole.valueOf(this.m_wp.getCms().readGroup(id)).getName(this.m_wp.getCms().getRequestContext().getLocale());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public String resolveMacros(String input) {
        String result = input;
        if (input != null) {
            String lastResult;
            do {
                lastResult = result;
            } while (!(result = CmsMacroResolver.resolveMacros(result, this)).equals(lastResult));
        }
        return result;
    }

    public boolean isKeepEmptyMacros() {
        return false;
    }
}

