/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.main.CmsLog;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsADECacheSettings;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.Messages;
import org.opencms.xml.content.CmsXmlContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsADECache
extends CmsVfsCache {
    private static final Log LOG = CmsLog.getLog(CmsADECache.class);
    private Map<String, CmsXmlContainerPage> m_containerPagesOffline;
    private Map<String, CmsXmlContainerPage> m_containerPagesOnline;
    private Map<String, CmsXmlGroupContainer> m_groupContainersOffline;
    private Map<String, CmsXmlGroupContainer> m_groupContainersOnline;
    private ReadWriteLock m_lock = new ReentrantReadWriteLock(true);

    public CmsADECache(CmsMemoryMonitor memMonitor, CmsADECacheSettings cacheSettings) {
        this.initialize(memMonitor, cacheSettings);
        this.registerEventListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushContainerPages(boolean online) {
        try {
            this.m_lock.writeLock().lock();
            if (online) {
                this.m_containerPagesOnline.clear();
            } else {
                this.m_containerPagesOffline.clear();
            }
            Object var3_2 = null;
            this.m_lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushGroupContainers(boolean online) {
        try {
            this.m_lock.writeLock().lock();
            if (online) {
                this.m_groupContainersOnline.clear();
            } else {
                this.m_groupContainersOffline.clear();
            }
            Object var3_2 = null;
            this.m_lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsXmlContainerPage getCacheContainerPage(String key, boolean online) {
        try {
            CmsXmlContainerPage retValue;
            this.m_lock.readLock().lock();
            if (online) {
                retValue = this.m_containerPagesOnline.get(key);
                if (LOG.isDebugEnabled()) {
                    if (retValue == null) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MISSED_ONLINE_1", new Object[]{key}));
                    } else {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MATCHED_ONLINE_2", new Object[]{key, retValue}));
                    }
                }
            } else {
                retValue = this.m_containerPagesOffline.get(key);
                if (LOG.isDebugEnabled()) {
                    if (retValue == null) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MISSED_OFFLINE_1", new Object[]{key}));
                    } else {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MATCHED_OFFLINE_2", new Object[]{key, retValue}));
                    }
                }
            }
            if (retValue != null) {
                // empty if block
            }
            CmsXmlContainerPage cmsXmlContainerPage = retValue;
            Object var6_5 = null;
            this.m_lock.readLock().unlock();
            return cmsXmlContainerPage;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsXmlGroupContainer getCacheGroupContainer(String key, boolean online) {
        try {
            CmsXmlGroupContainer retValue;
            this.m_lock.readLock().lock();
            if (online) {
                retValue = this.m_groupContainersOnline.get(key);
                if (LOG.isDebugEnabled()) {
                    if (retValue == null) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MISSED_ONLINE_1", new Object[]{key}));
                    } else {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MATCHED_ONLINE_2", new Object[]{key, retValue}));
                    }
                }
            } else {
                retValue = this.m_groupContainersOffline.get(key);
                if (LOG.isDebugEnabled()) {
                    if (retValue == null) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MISSED_OFFLINE_1", new Object[]{key}));
                    } else {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_MATCHED_OFFLINE_2", new Object[]{key, retValue}));
                    }
                }
            }
            CmsXmlGroupContainer cmsXmlGroupContainer = retValue;
            Object var6_5 = null;
            this.m_lock.readLock().unlock();
            return cmsXmlGroupContainer;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_lock.readLock().unlock();
            throw throwable;
        }
    }

    public String getCacheKey(CmsUUID structureId, boolean keepEncoding) {
        return structureId.toString() + "_" + keepEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheContainerPage(String key, CmsXmlContainerPage containerPage, boolean online) {
        try {
            this.m_lock.writeLock().lock();
            if (online) {
                this.m_containerPagesOnline.put(key, containerPage);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_SET_ONLINE_2", new Object[]{key, containerPage}));
                }
            } else {
                this.m_containerPagesOffline.put(key, containerPage);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_SET_OFFLINE_2", new Object[]{key, containerPage}));
                }
            }
            Object var5_4 = null;
            this.m_lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheGroupContainer(String key, CmsXmlGroupContainer groupContainer, boolean online) {
        try {
            this.m_lock.writeLock().lock();
            if (online) {
                this.m_groupContainersOnline.put(key, groupContainer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_SET_ONLINE_2", new Object[]{key, groupContainer}));
                }
            } else {
                this.m_groupContainersOffline.put(key, groupContainer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_CACHE_SET_OFFLINE_2", new Object[]{key, groupContainer}));
                }
            }
            Object var5_4 = null;
            this.m_lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncacheContainerPage(CmsUUID structureId, boolean online) {
        try {
            this.m_lock.writeLock().lock();
            if (online) {
                this.m_containerPagesOnline.remove(this.getCacheKey(structureId, true));
                this.m_containerPagesOnline.remove(this.getCacheKey(structureId, false));
            } else {
                this.m_containerPagesOffline.remove(this.getCacheKey(structureId, true));
                this.m_containerPagesOffline.remove(this.getCacheKey(structureId, false));
            }
            Object var4_3 = null;
            this.m_lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncacheGroupContainer(CmsUUID structureId, boolean online) {
        try {
            this.m_lock.writeLock().lock();
            if (online) {
                this.m_groupContainersOnline.remove(this.getCacheKey(structureId, true));
                this.m_groupContainersOnline.remove(this.getCacheKey(structureId, false));
            } else {
                this.m_groupContainersOffline.remove(this.getCacheKey(structureId, true));
                this.m_groupContainersOffline.remove(this.getCacheKey(structureId, false));
            }
            Object var4_3 = null;
            this.m_lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush(boolean online) {
        try {
            this.m_lock.writeLock().lock();
            this.flushContainerPages(online);
            this.flushGroupContainers(online);
            Object var3_2 = null;
            this.m_lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void uncacheResource(CmsResource resource) {
        try {
            this.m_lock.writeLock().lock();
            if (resource == null) {
                LOG.warn((Object)Messages.get().container("LOG_WARN_UNCACHE_NULL_0"));
                Object var3_2 = null;
                this.m_lock.writeLock().unlock();
                return;
            }
            if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
                this.removeCachedContent(resource, this.m_containerPagesOffline);
            } else {
                this.removeCachedContent(resource, this.m_groupContainersOffline);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.m_lock.writeLock().unlock();
            throw throwable;
        }
        Object var3_3 = null;
        this.m_lock.writeLock().unlock();
    }

    private void initialize(CmsMemoryMonitor memMonitor, CmsADECacheSettings cacheSettings) {
        Map lruMapCntPage = CmsCollectionsGenericWrapper.createLRUMap(cacheSettings.getContainerPageOfflineSize());
        this.m_containerPagesOffline = Collections.synchronizedMap(lruMapCntPage);
        memMonitor.register(CmsADECache.class.getName() + ".containerPagesOffline", lruMapCntPage);
        lruMapCntPage = CmsCollectionsGenericWrapper.createLRUMap(cacheSettings.getContainerPageOnlineSize());
        this.m_containerPagesOnline = Collections.synchronizedMap(lruMapCntPage);
        memMonitor.register(CmsADECache.class.getName() + ".containerPagesOnline", lruMapCntPage);
        Map lruMapGroupContainer = CmsCollectionsGenericWrapper.createLRUMap(cacheSettings.getGroupContainerOfflineSize());
        this.m_groupContainersOffline = Collections.synchronizedMap(lruMapGroupContainer);
        memMonitor.register(CmsADECache.class.getName() + ".groupContainersOffline", lruMapGroupContainer);
        lruMapGroupContainer = CmsCollectionsGenericWrapper.createLRUMap(cacheSettings.getGroupContainerOnlineSize());
        this.m_groupContainersOnline = Collections.synchronizedMap(lruMapGroupContainer);
        memMonitor.register(CmsADECache.class.getName() + ".groupContainersOnline", lruMapGroupContainer);
    }

    private <CONTENT extends CmsXmlContent> void removeCachedContent(CmsResource resource, Map<String, CONTENT> cache) {
        Iterator<Map.Entry<String, CONTENT>> iterator = cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CONTENT> entry = iterator.next();
            CmsXmlContent content = (CmsXmlContent)entry.getValue();
            CmsFile contentFile = content.getFile();
            if (!contentFile.getStructureId().equals(resource.getStructureId()) && !contentFile.getResourceId().equals(resource.getResourceId())) continue;
            iterator.remove();
        }
    }
}

