/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.list.NodeCachingLinkedList;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.xml.containerpage.CmsContainerElementBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsADESessionCache {
    public static final String SESSION_ATTR_ADE_CACHE = "__OCMS_ADE_CACHE__";
    private Map<String, CmsContainerElementBean> m_containerElements;
    private boolean m_isShowEditorHelp;
    private List<CmsContainerElementBean> m_recentLists;
    private boolean m_toolbarVisible;

    public CmsADESessionCache(CmsObject cms) {
        HashMap lruMapCntElem = new HashMap();
        this.m_containerElements = Collections.synchronizedMap(lruMapCntElem);
        int maxElems = 10;
        maxElems = OpenCms.getADEManager().getRecentListMaxSize(cms.getRequestContext().getCurrentUser());
        List adeRecentList = CmsCollectionsGenericWrapper.list(new NodeCachingLinkedList(maxElems));
        this.m_recentLists = Collections.synchronizedList(adeRecentList);
        this.m_isShowEditorHelp = true;
    }

    public CmsContainerElementBean getCacheContainerElement(String key) {
        return this.m_containerElements.get(key);
    }

    public List<CmsContainerElementBean> getRecentList() {
        return this.m_recentLists;
    }

    public boolean isShowEditorHelp() {
        return this.m_isShowEditorHelp;
    }

    public boolean isToolbarVisible() {
        return this.m_toolbarVisible;
    }

    public void setCacheContainerElement(String key, CmsContainerElementBean containerElement) {
        this.m_containerElements.put(key, containerElement);
    }

    public void setCacheRecentList(List<CmsContainerElementBean> list) {
        this.m_recentLists.clear();
        this.m_recentLists.addAll(list);
        for (CmsContainerElementBean element : this.m_recentLists) {
            this.setCacheContainerElement(element.editorHash(), element);
        }
    }

    public void setShowEditorHelp(boolean isShowEditorHelp) {
        this.m_isShowEditorHelp = isShowEditorHelp;
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        this.m_toolbarVisible = toolbarVisible;
    }
}

