/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.content.CmsXmlContentProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsDynamicFunctionBean {
    public static final String FORMATTER_PATH = "/system/modules/org.opencms.ade.containerpage/formatters/function.jsp";
    private CmsResource m_functionFormatter;
    private Format m_mainFormat;
    private List<Format> m_otherFormats;
    private CmsResource m_resource;
    private Map<String, CmsXmlContentProperty> m_settingConfig;

    public CmsDynamicFunctionBean(Format mainFormat, List<Format> otherFormats, Map<String, CmsXmlContentProperty> settingConfig, CmsResource resource, CmsResource functionFormatter) {
        this.m_mainFormat = mainFormat;
        this.m_otherFormats = otherFormats;
        this.m_settingConfig = settingConfig;
        for (Format format : otherFormats) {
            format.setDefaultParameters(mainFormat.getParameters());
        }
        this.m_resource = resource;
        this.m_functionFormatter = functionFormatter;
    }

    public Format getFormatForContainer(CmsObject cms, String type, int width) {
        IdentityHashMap<CmsFormatterBean, Format> formatsByFormatter = new IdentityHashMap<CmsFormatterBean, Format>();
        CmsFormatterBean mainFormatter = this.createFormatterBean(this.m_mainFormat, true);
        formatsByFormatter.put(mainFormatter, this.m_mainFormat);
        ArrayList<CmsFormatterBean> formatters = new ArrayList<CmsFormatterBean>();
        for (Format format : this.m_otherFormats) {
            CmsFormatterBean formatter = this.createFormatterBean(format, false);
            formatsByFormatter.put(formatter, format);
            formatters.add(formatter);
        }
        formatters.add(0, mainFormatter);
        CmsFormatterConfiguration formatterConfiguration = CmsFormatterConfiguration.create(cms, formatters);
        CmsFormatterBean matchingFormatter = formatterConfiguration.getFormatter(type, width);
        if (matchingFormatter == null) {
            return null;
        }
        return (Format)formatsByFormatter.get(matchingFormatter);
    }

    public CmsFormatterConfiguration getFormatterConfiguration(CmsObject cms) {
        CmsFormatterBean mainFormatter = this.createFormatterBean(this.m_mainFormat, true);
        ArrayList<CmsFormatterBean> formatters = new ArrayList<CmsFormatterBean>();
        for (Format format : this.m_otherFormats) {
            formatters.add(this.createFormatterBean(format, false));
        }
        formatters.add(0, mainFormatter);
        return CmsFormatterConfiguration.create(cms, formatters);
    }

    public CmsResource getFunctionFormatter() {
        return this.m_functionFormatter;
    }

    public Format getMainFormat() {
        return this.m_mainFormat;
    }

    public Map<String, CmsXmlContentProperty> getSettings() {
        return this.m_settingConfig;
    }

    protected CmsFormatterBean createFormatterBean(Format format, boolean isPreview) {
        if (format.hasNoContainerSettings()) {
            return new CmsFormatterBean(FORMATTER_PATH, this.m_functionFormatter.getStructureId(), this.m_resource.getRootPath(), isPreview);
        }
        CmsFormatterBean result = new CmsFormatterBean(format.getType(), FORMATTER_PATH, format.getMinWidth(), format.getMaxWidth(), "" + isPreview, "false", this.m_resource.getRootPath());
        result.setJspStructureId(this.m_functionFormatter.getStructureId());
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Format {
        private CmsUUID m_jspStructureId;
        private String m_maxWidth;
        private String m_minWidth;
        private boolean m_noContainerSettings;
        private Map<String, String> m_parameters = new HashMap<String, String>();
        private String m_type;

        public Format(CmsUUID structureId, String type, String minWidth, String maxWidth, Map<String, String> parameters) {
            this.m_jspStructureId = structureId;
            this.m_type = type;
            this.m_minWidth = minWidth;
            this.m_maxWidth = maxWidth;
            this.m_parameters = parameters;
        }

        public CmsUUID getJspStructureId() {
            return this.m_jspStructureId;
        }

        public String getMaxWidth() {
            return this.m_maxWidth;
        }

        public String getMinWidth() {
            return this.m_minWidth;
        }

        public Map<String, String> getParameters() {
            return this.m_parameters;
        }

        public String getType() {
            return this.m_type;
        }

        public boolean hasNoContainerSettings() {
            return this.m_noContainerSettings;
        }

        protected void setDefaultParameters(Map<String, String> parameters) {
            if (this.m_parameters.isEmpty()) {
                this.m_parameters = parameters;
            }
        }

        protected void setNoContainerSettings(boolean noContainerSettings) {
            this.m_noContainerSettings = true;
        }
    }
}

