/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsDynamicFunctionBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentRootLocation;
import org.opencms.xml.content.I_CmsXmlContentLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsDynamicFunctionParser {
    public static final String FORMATTER_PATH = "/system/modules/org.opencms.ade.containerpage/formatters/function.jsp";
    public static final String N_CONTAINER_SETTINGS = "ContainerSettings";
    public static final String TYPE_FUNCTION = "function";

    public CmsDynamicFunctionBean parseFunctionBean(CmsObject cms, CmsResource res) throws CmsException {
        CmsFile file = cms.readFile(res);
        CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
        return this.parseFunctionBean(cms, xmlContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsDynamicFunctionBean parseFunctionBean(CmsObject cms, CmsXmlContent content) throws CmsException {
        Locale locale = this.getLocaleToUse(cms, content);
        String oldSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            CmsDynamicFunctionBean functionBean;
            cms.getRequestContext().setSiteRoot("");
            CmsResource functionFormatter = this.getFunctionFormatter(cms);
            CmsXmlContentRootLocation root = new CmsXmlContentRootLocation(content, locale);
            CmsDynamicFunctionBean cmsDynamicFunctionBean = functionBean = this.parseFunctionBean(cms, root, content.getFile(), functionFormatter);
            Object var10_9 = null;
            cms.getRequestContext().setSiteRoot(oldSiteRoot);
            return cmsDynamicFunctionBean;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            cms.getRequestContext().setSiteRoot(oldSiteRoot);
            throw throwable;
        }
    }

    protected List<CmsDynamicFunctionBean.Format> getAdditionalFormats(CmsObject cms, I_CmsXmlContentLocation location, CmsResource functionRes) {
        List<I_CmsXmlContentValueLocation> locations = location.getSubValues("AdditionalFormat");
        ArrayList<CmsDynamicFunctionBean.Format> formats = new ArrayList<CmsDynamicFunctionBean.Format>();
        for (I_CmsXmlContentValueLocation formatLocation : locations) {
            CmsDynamicFunctionBean.Format format = this.parseAdditionalFormat(cms, formatLocation, functionRes);
            formats.add(format);
        }
        return formats;
    }

    protected CmsResource getFunctionFormatter(CmsObject cms) throws CmsException {
        String path;
        CmsVfsMemoryObjectCache cache = CmsVfsMemoryObjectCache.getVfsMemoryObjectCache();
        Object cacheValue = cache.getCachedObject(cms, path = FORMATTER_PATH);
        if (cacheValue == null) {
            CmsResource functionRes = cms.readResource(path);
            cache.putCachedObject(cms, path, functionRes);
            return functionRes;
        }
        return (CmsResource)cacheValue;
    }

    protected Locale getLocaleToUse(CmsObject cms, CmsXmlContent xmlContent) {
        Locale contextLocale = cms.getRequestContext().getLocale();
        if (xmlContent.hasLocale(contextLocale)) {
            return contextLocale;
        }
        Locale defaultLocale = CmsLocaleManager.getDefaultLocale();
        if (xmlContent.hasLocale(defaultLocale)) {
            return defaultLocale;
        }
        if (!xmlContent.getLocales().isEmpty()) {
            return xmlContent.getLocales().get(0);
        }
        return defaultLocale;
    }

    protected CmsDynamicFunctionBean.Format getMainFormat(CmsObject cms, I_CmsXmlContentLocation location, CmsResource functionRes) {
        I_CmsXmlContentValueLocation jspLoc = location.getSubValue("FunctionProvider");
        CmsUUID structureId = jspLoc.asId(cms);
        I_CmsXmlContentValueLocation containerSettings = location.getSubValue(N_CONTAINER_SETTINGS);
        Map<String, String> parameters = this.parseParameters(cms, location, "Parameter");
        if (containerSettings != null) {
            String type = this.getStringValue(cms, containerSettings.getSubValue("Type"), "");
            String minWidth = this.getStringValue(cms, containerSettings.getSubValue("MinWidth"), "");
            String maxWidth = this.getStringValue(cms, containerSettings.getSubValue("MaxWidth"), "");
            CmsDynamicFunctionBean.Format result = new CmsDynamicFunctionBean.Format(structureId, type, minWidth, maxWidth, parameters);
            return result;
        }
        CmsDynamicFunctionBean.Format result = new CmsDynamicFunctionBean.Format(structureId, "", "", "", parameters);
        result.setNoContainerSettings(true);
        return result;
    }

    protected String getString(CmsObject cms, I_CmsXmlContentValueLocation location) {
        if (location == null) {
            return null;
        }
        return location.asString(cms);
    }

    protected String getStringValue(CmsObject cms, I_CmsXmlContentValueLocation location, String defaultValue) {
        if (location == null) {
            return defaultValue;
        }
        return location.asString(cms);
    }

    protected CmsDynamicFunctionBean.Format parseAdditionalFormat(CmsObject cms, I_CmsXmlContentValueLocation location, CmsResource functionRes) {
        I_CmsXmlContentValueLocation jspLoc = location.getSubValue("FunctionProvider");
        CmsUUID structureId = jspLoc.asId(cms);
        I_CmsXmlContentValueLocation minWidthLoc = location.getSubValue("MinWidth");
        String minWidth = this.getStringValue(cms, minWidthLoc, "");
        I_CmsXmlContentValueLocation maxWidthLoc = location.getSubValue("MaxWidth");
        String maxWidth = this.getStringValue(cms, maxWidthLoc, "");
        I_CmsXmlContentValueLocation typeLoc = location.getSubValue("Type");
        String type = this.getStringValue(cms, typeLoc, "");
        Map<String, String> parameters = this.parseParameters(cms, location, "Parameter");
        return new CmsDynamicFunctionBean.Format(structureId, type, minWidth, maxWidth, parameters);
    }

    protected CmsDynamicFunctionBean parseFunctionBean(CmsObject cms, I_CmsXmlContentLocation location, CmsResource functionRes, CmsResource functionFormatter) {
        CmsDynamicFunctionBean.Format mainFormat = this.getMainFormat(cms, location, functionRes);
        List<CmsDynamicFunctionBean.Format> otherFormats = this.getAdditionalFormats(cms, location, functionRes);
        Map<String, CmsXmlContentProperty> definedSettings = this.parseSettings(cms, location, functionRes);
        CmsDynamicFunctionBean result = new CmsDynamicFunctionBean(mainFormat, otherFormats, definedSettings, functionRes, functionFormatter);
        return result;
    }

    protected CmsPair<String, String> parseParameter(CmsObject cms, I_CmsXmlContentValueLocation valueLocation) {
        String key = valueLocation.getSubValue("Key").asString(cms);
        String value = valueLocation.getSubValue("Value").asString(cms);
        return CmsPair.create(key, value);
    }

    protected Map<String, String> parseParameters(CmsObject cms, I_CmsXmlContentLocation location, String name) {
        List<I_CmsXmlContentValueLocation> locations = location.getSubValues(name);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (I_CmsXmlContentValueLocation paramLocation : locations) {
            CmsPair<String, String> param = this.parseParameter(cms, paramLocation);
            result.put(param.getFirst(), param.getSecond());
        }
        return result;
    }

    protected CmsXmlContentProperty parseProperty(CmsObject cms, I_CmsXmlContentLocation field) {
        String type;
        String name = this.getString(cms, field.getSubValue("PropertyName"));
        String widget = this.getString(cms, field.getSubValue("Widget"));
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(widget)) {
            widget = "string";
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(type = this.getString(cms, field.getSubValue("Type")))) {
            type = "string";
        }
        String widgetConfig = this.getString(cms, field.getSubValue("WidgetConfig"));
        String ruleRegex = this.getString(cms, field.getSubValue("RuleRegex"));
        String ruleType = this.getString(cms, field.getSubValue("RuleType"));
        String default1 = this.getString(cms, field.getSubValue("Default"));
        String error = this.getString(cms, field.getSubValue("Error"));
        String niceName = this.getString(cms, field.getSubValue("DisplayName"));
        String description = this.getString(cms, field.getSubValue("Description"));
        CmsXmlContentProperty prop = new CmsXmlContentProperty(name, type, widget, widgetConfig, ruleRegex, ruleType, default1, niceName, description, error, "true");
        return prop;
    }

    protected Map<String, CmsXmlContentProperty> parseSettings(CmsObject cms, I_CmsXmlContentLocation location, CmsResource functionResource) {
        LinkedHashMap<String, CmsXmlContentProperty> settingConfigs = new LinkedHashMap<String, CmsXmlContentProperty>();
        List<I_CmsXmlContentValueLocation> locations = location.getSubValues("SettingConfig");
        for (I_CmsXmlContentValueLocation settingLoc : locations) {
            CmsXmlContentProperty settingConfigBean = this.parseProperty(cms, settingLoc);
            settingConfigs.put(settingConfigBean.getName(), settingConfigBean);
        }
        return settingConfigs;
    }
}

