/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsFormatterBean {
    public static final String PREVIEW_TYPE = "_PREVIEW_";
    public static final int PREVIEW_WIDTH = 640;
    public static final String WILDCARD_TYPE = "*";
    private String m_containerType;
    private boolean m_isPreviewFormatter;
    private boolean m_isTypeFormatter;
    private String m_jspRootPath;
    private CmsUUID m_jspStructureId;
    private String m_location;
    private boolean m_matchAll;
    private int m_maxWidth;
    private int m_minWidth;
    private boolean m_search;

    public CmsFormatterBean(String containerType, String jspRootPath, CmsUUID jspStructureId, int minWidth, int maxWidth, boolean preview, boolean searchContent, String location) {
        this.m_jspRootPath = jspRootPath;
        this.m_jspStructureId = jspStructureId;
        this.m_containerType = containerType;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_containerType)) {
            this.m_containerType = WILDCARD_TYPE;
        }
        this.m_isTypeFormatter = !WILDCARD_TYPE.equals(this.m_containerType);
        this.m_minWidth = minWidth;
        this.m_maxWidth = maxWidth;
        this.m_isPreviewFormatter = preview;
        this.m_search = searchContent;
        this.m_location = location;
    }

    public CmsFormatterBean(String containerType, String jspRootPath, String minWidthStr, String maxWidthStr, String preview, String searchContent, String location) {
        this.m_jspRootPath = jspRootPath;
        this.m_containerType = containerType;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_containerType)) {
            this.m_containerType = WILDCARD_TYPE;
        }
        this.m_minWidth = -1;
        this.m_maxWidth = Integer.MAX_VALUE;
        this.m_isTypeFormatter = true;
        if (WILDCARD_TYPE.equals(this.m_containerType)) {
            this.m_isTypeFormatter = false;
            try {
                this.m_minWidth = Integer.parseInt(minWidthStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                this.m_maxWidth = Integer.parseInt(maxWidthStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.m_isPreviewFormatter = Boolean.valueOf(preview);
        this.m_search = CmsStringUtil.isEmptyOrWhitespaceOnly(searchContent) ? true : Boolean.valueOf(searchContent);
        this.m_location = location;
    }

    CmsFormatterBean(String jspRootPath, CmsUUID jspStructureId, String location, boolean preview) {
        this(WILDCARD_TYPE, jspRootPath, jspStructureId, -1, Integer.MAX_VALUE, preview, false, location);
        this.m_matchAll = true;
    }

    public static boolean isPreviewType(String containerType) {
        return PREVIEW_TYPE.equals(containerType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsFormatterBean) {
            CmsFormatterBean other = (CmsFormatterBean)obj;
            if (other.m_isTypeFormatter == this.m_isTypeFormatter) {
                if (this.m_isTypeFormatter) {
                    return CmsStringUtil.isEqual(this.m_containerType, other.m_containerType);
                }
                return this.m_minWidth == other.m_minWidth && this.m_maxWidth == other.m_maxWidth;
            }
        }
        return false;
    }

    public String getContainerType() {
        return this.m_containerType;
    }

    public String getJspRootPath() {
        return this.m_jspRootPath;
    }

    public CmsUUID getJspStructureId() {
        return this.m_jspStructureId;
    }

    public String getLocation() {
        return this.m_location;
    }

    public int getMaxWidth() {
        return this.m_maxWidth;
    }

    public int getMinWidth() {
        return this.m_minWidth;
    }

    public int hashCode() {
        return this.m_containerType.hashCode() ^ (this.m_minWidth * 33 ^ this.m_maxWidth);
    }

    public boolean isMatchAll() {
        return this.m_matchAll;
    }

    public boolean isPreviewFormatter() {
        return this.m_isPreviewFormatter;
    }

    public boolean isSearchContent() {
        return this.m_search;
    }

    public boolean isTypeFormatter() {
        return this.m_isTypeFormatter;
    }

    void setJspStructureId(CmsUUID jspStructureId) {
        this.m_jspStructureId = jspStructureId;
    }
}

