/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsFormatterConfiguration {
    public static final CmsFormatterConfiguration EMPTY_CONFIGURATION = new CmsFormatterConfiguration(null, null);
    public static final Log LOG = CmsLog.getLog(CmsFormatterConfiguration.class);
    private static CmsObject m_adminCms;
    private List<CmsFormatterBean> m_allFormatters;
    private boolean m_previewCalculated;
    private CmsFormatterBean m_previewFormatter;
    private Map<CmsUUID, Boolean> m_searchContent;
    private Map<String, CmsFormatterBean> m_typeFormatters;
    private List<CmsFormatterBean> m_widthFormatters;

    private CmsFormatterConfiguration(CmsObject cms, List<CmsFormatterBean> formatters) {
        this.m_allFormatters = formatters == null ? Collections.emptyList() : new ArrayList<CmsFormatterBean>(formatters);
        this.m_widthFormatters = new ArrayList<CmsFormatterBean>(this.m_allFormatters.size());
        this.m_typeFormatters = new HashMap<String, CmsFormatterBean>(this.m_allFormatters.size());
        this.m_searchContent = new HashMap<CmsUUID, Boolean>();
        this.init(cms, m_adminCms);
    }

    public static CmsFormatterConfiguration create(CmsObject cms, List<CmsFormatterBean> formatters) {
        if (formatters != null && formatters.size() > 0 && cms != null) {
            return new CmsFormatterConfiguration(cms, formatters);
        }
        return EMPTY_CONFIGURATION;
    }

    public static void initialize(CmsObject cms) throws CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ADMINISTRATOR);
        try {
            m_adminCms = OpenCms.initCmsObject(cms);
            m_adminCms.getRequestContext().setSiteRoot("");
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    public List<CmsFormatterBean> getAllFormatters() {
        return new ArrayList<CmsFormatterBean>(this.m_allFormatters);
    }

    public CmsFormatterBean getFormatter(String containerType, int containerWidth) {
        if (this == EMPTY_CONFIGURATION) {
            return null;
        }
        if (CmsFormatterBean.isPreviewType(containerType)) {
            return this.getPreviewFormatter();
        }
        CmsFormatterBean result = this.m_typeFormatters.get(containerType);
        if (result == null && containerWidth > 0) {
            for (CmsFormatterBean f : this.m_widthFormatters) {
                if (f.getMinWidth() > containerWidth || containerWidth > f.getMaxWidth() || result != null && result.getMinWidth() >= f.getMinWidth()) continue;
                result = f;
            }
        }
        if (result == null) {
            for (CmsFormatterBean f : this.m_widthFormatters) {
                if (!f.isMatchAll()) continue;
                result = f;
            }
        }
        return result;
    }

    public CmsFormatterBean getPreviewFormatter() {
        if (!this.m_previewCalculated) {
            CmsFormatterBean result = null;
            if (this != EMPTY_CONFIGURATION && (result = this.m_typeFormatters.get("_PREVIEW_")) == null) {
                result = this.getFormatter("*", 640);
                if (result == null && !this.m_widthFormatters.isEmpty()) {
                    for (CmsFormatterBean f : this.m_widthFormatters) {
                        if (f.getMinWidth() < 640 || 640 > f.getMaxWidth() || result != null && result.getMinWidth() >= f.getMinWidth()) continue;
                        result = f;
                    }
                }
                if (result == null && !this.m_typeFormatters.isEmpty()) {
                    result = this.m_typeFormatters.values().iterator().next();
                }
            }
            this.m_previewCalculated = true;
            this.m_previewFormatter = result;
        }
        return this.m_previewFormatter;
    }

    public boolean hasFormatter(String containerType, int containerWidth) {
        return this.getFormatter(containerType, containerWidth) != null;
    }

    public boolean hasFormatters() {
        if (EMPTY_CONFIGURATION == this) {
            return false;
        }
        return this.m_typeFormatters.size() > 0 || this.m_widthFormatters.size() > 0;
    }

    public boolean isSearchContent(CmsUUID formatterStructureId) {
        if (EMPTY_CONFIGURATION == this) {
            return false;
        }
        Boolean result = this.m_searchContent.get(formatterStructureId);
        if (result == null) {
            for (CmsFormatterBean formatter : this.m_allFormatters) {
                if (!formatter.getJspStructureId().equals(formatterStructureId)) continue;
                result = formatter.isSearchContent();
                break;
            }
            if (result == null) {
                result = Boolean.FALSE;
            }
            this.m_searchContent.put(formatterStructureId, result);
        }
        return result;
    }

    private void init(CmsObject userCms, CmsObject adminCms) {
        for (CmsFormatterBean formatter : this.m_allFormatters) {
            Object key;
            if (formatter.getJspStructureId() == null) {
                CmsResource res = null;
                try {
                    CmsObject cmsCopy = OpenCms.initCmsObject(adminCms);
                    cmsCopy.getRequestContext().setCurrentProject(userCms.getRequestContext().getCurrentProject());
                    cmsCopy.getRequestContext().setSiteRoot("");
                    res = cmsCopy.readResource(formatter.getJspRootPath());
                }
                catch (CmsException e) {
                    // empty catch block
                }
                if (res == null || !CmsResourceTypeJsp.isJsp(res)) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_FORMATTER_JSP_DONT_EXIST_1", formatter.getJspRootPath()));
                } else {
                    formatter.setJspStructureId(res.getStructureId());
                }
            }
            if (formatter.getJspStructureId() == null) continue;
            String oldUri = null;
            if (formatter.isTypeFormatter()) {
                String type = formatter.getContainerType();
                key = type;
                CmsFormatterBean oldFormatter = this.m_typeFormatters.get(type);
                if (oldFormatter != null) {
                    oldUri = oldFormatter.getJspRootPath();
                }
                this.m_typeFormatters.put(type, formatter);
            } else {
                Integer minWidth = formatter.getMinWidth();
                key = minWidth;
                int old = this.m_widthFormatters.lastIndexOf(formatter);
                if (old >= 0) {
                    oldUri = this.m_widthFormatters.remove(old).getJspRootPath();
                }
                this.m_widthFormatters.add(formatter);
            }
            if (formatter.isPreviewFormatter()) {
                this.m_previewFormatter = formatter;
            }
            if (oldUri == null) continue;
            LOG.warn((Object)Messages.get().getBundle().key("LOG_CONTENT_DEFINITION_DUPLICATE_FORMATTER_4", new Object[]{key, oldUri, formatter.getJspRootPath(), formatter.getLocation()}));
        }
        this.m_allFormatters = Collections.unmodifiableList(this.m_allFormatters);
        this.m_typeFormatters = Collections.unmodifiableMap(this.m_typeFormatters);
        this.m_widthFormatters = Collections.unmodifiableList(this.m_widthFormatters);
    }
}

