/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.content.I_CmsXmlContentValueVisitor;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.I_CmsXmlContentValue;

class CmsXmlContentMappingVisitor
implements I_CmsXmlContentValueVisitor {
    private static final Log LOG = CmsLog.getLog(CmsXmlContentMappingVisitor.class);
    CmsObject m_cms;
    CmsXmlContent m_content;
    I_CmsXmlContentHandler m_handler;

    public CmsXmlContentMappingVisitor(CmsObject cms, CmsXmlContent content) {
        this.m_cms = cms;
        this.m_content = content;
        this.m_handler = content.getHandler();
    }

    public void visit(I_CmsXmlContentValue value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_VISIT_1", value.getPath()));
        }
        try {
            this.m_handler.resolveMapping(this.m_cms, this.m_content, value);
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_RESOLVE_MAPPING_1", value.getPath()), (Throwable)e);
        }
    }
}

