/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.staticexport.CmsLinkProcessor;
import org.opencms.staticexport.CmsLinkTable;
import org.opencms.xml.A_CmsXmlDocument;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.page.CmsXmlPageFactory;
import org.opencms.xml.page.Messages;
import org.opencms.xml.types.CmsXmlHtmlValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsXmlPage
extends A_CmsXmlDocument {
    public static final String ATTRIBUTE_ENABLED = "enabled";
    public static final String ATTRIBUTE_LANGUAGE = "language";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String NODE_CONTENT = "content";
    public static final String NODE_ELEMENTS = "elements";
    public static final String NODE_LINK = "link";
    public static final String NODE_LINKS = "links";
    public static final String NODE_PAGE = "page";
    public static final String NODE_PAGES = "pages";
    public static final String PROPERTY_ALLOW_RELATIVE = "allowRelativeLinks";
    public static final String XMLPAGE_XSD_SYSTEM_ID = "http://www.opencms.org/dtd/6.0/xmlpage.xsd";
    private static final Log LOG = CmsLog.getLog(CmsXmlPage.class);
    private static CmsXmlContentDefinition m_xmlPageContentDefinition;
    private static final String NODE_ELEMENT = "element";
    private boolean m_allowRelativeLinks;

    public CmsXmlPage(Document document, String encoding) {
        this.initDocument(document, encoding, this.getContentDefinition());
    }

    public CmsXmlPage(Locale locale, String encoding) {
        this.initDocument(CmsXmlPageFactory.createDocument(locale), encoding, this.getContentDefinition());
    }

    @Override
    public void addLocale(CmsObject cms, Locale locale) throws CmsXmlException {
        if (this.hasLocale(locale)) {
            throw new CmsXmlException(Messages.get().container("ERR_XML_PAGE_LOCALE_EXISTS_1", locale));
        }
        this.getContentDefinition().createLocale(cms, this, this.m_document.getRootElement(), locale);
        this.initDocument(this.m_document, this.m_encoding, this.getContentDefinition());
    }

    public void addValue(String name, Locale locale) throws CmsIllegalArgumentException {
        Element element;
        if (name.indexOf(91) >= 0) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_XML_PAGE_CONTAINS_INDEX_1", name));
        }
        if (this.hasValue(name, locale)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_XML_PAGE_LANG_ELEM_EXISTS_2", name, locale));
        }
        Element pages = this.m_document.getRootElement();
        String localeStr = locale.toString();
        Element page = null;
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(pages, NODE_PAGE);
        while (i.hasNext()) {
            Element nextPage = i.next();
            String language = nextPage.attributeValue(ATTRIBUTE_LANGUAGE);
            if (!localeStr.equals(language)) continue;
            page = nextPage;
            break;
        }
        if (page != null) {
            element = page.addElement(NODE_ELEMENT).addAttribute(ATTRIBUTE_NAME, name);
        } else {
            element = pages.addElement(NODE_PAGE).addAttribute(ATTRIBUTE_LANGUAGE, localeStr);
            element = element.addElement(NODE_ELEMENT).addAttribute(ATTRIBUTE_NAME, name);
        }
        element.addElement(NODE_LINKS);
        element.addElement(NODE_CONTENT);
        CmsXmlHtmlValue value = new CmsXmlHtmlValue(this, element, locale);
        this.addBookmark(CmsXmlUtils.createXpathElement(name, 1), locale, true, value);
    }

    public boolean getAllowRelativeLinks() {
        return this.m_allowRelativeLinks;
    }

    @Override
    public CmsXmlContentDefinition getContentDefinition() throws CmsRuntimeException {
        if (m_xmlPageContentDefinition == null) {
            CmsXmlEntityResolver resolver = new CmsXmlEntityResolver(null);
            try {
                InputSource source = resolver.resolveEntity(null, XMLPAGE_XSD_SYSTEM_ID);
                m_xmlPageContentDefinition = CmsXmlContentDefinition.unmarshal(source, XMLPAGE_XSD_SYSTEM_ID, (EntityResolver)resolver);
            }
            catch (CmsXmlException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_XML_PAGE_UNMARSHAL_CONTENDDEF_0"), (Throwable)e);
            }
        }
        return m_xmlPageContentDefinition;
    }

    @Override
    public I_CmsXmlContentHandler getHandler() {
        return this.getContentDefinition().getContentHandler();
    }

    @Override
    public CmsLinkProcessor getLinkProcessor(CmsObject cms, CmsLinkTable linkTable) {
        String relativeRoot = null;
        if (!this.m_allowRelativeLinks && this.m_file != null) {
            relativeRoot = CmsResource.getParentFolder(cms.getSitePath(this.m_file));
        }
        return new CmsLinkProcessor(cms, linkTable, this.getEncoding(), relativeRoot);
    }

    public CmsLinkTable getLinkTable(String name, Locale locale) {
        CmsXmlHtmlValue value = (CmsXmlHtmlValue)this.getValue(name, locale);
        if (value != null) {
            return value.getLinkTable();
        }
        return new CmsLinkTable();
    }

    @Override
    public List<String> getNames(Locale locale) {
        Set sn = (Set)this.m_elementNames.get(locale);
        if (sn != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String path : sn) {
                result.add(CmsXmlUtils.removeXpathIndex(path));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled(String name, Locale locale) {
        CmsXmlHtmlValue value = (CmsXmlHtmlValue)this.getValue(name, locale);
        if (value != null) {
            Element element = value.getElement();
            Attribute enabled = element.attribute(ATTRIBUTE_ENABLED);
            return enabled == null || Boolean.valueOf(enabled.getValue()) != false;
        }
        return false;
    }

    public void removeValue(String name, Locale locale) {
        I_CmsXmlContentValue value = this.removeBookmark(CmsXmlUtils.createXpath(name, 1), locale);
        if (value != null) {
            Element element = value.getElement();
            element.detach();
        }
    }

    public void renameValue(String oldValue, String newValue, Locale locale) throws CmsIllegalArgumentException {
        CmsXmlHtmlValue oldXmlHtmlValue = (CmsXmlHtmlValue)this.getValue(oldValue, locale);
        if (oldXmlHtmlValue == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_XML_PAGE_NO_ELEM_FOR_LANG_2", oldValue, locale));
        }
        if (this.hasValue(newValue, locale)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_XML_PAGE_LANG_ELEM_EXISTS_2", newValue, locale));
        }
        if (newValue.indexOf(91) >= 0) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_XML_PAGE_CONTAINS_INDEX_1", newValue));
        }
        Element element = oldXmlHtmlValue.getElement();
        element.addAttribute(ATTRIBUTE_NAME, newValue);
        this.initDocument(this.m_document, this.m_encoding, this.getContentDefinition());
    }

    public void setEnabled(String name, Locale locale, boolean isEnabled) {
        CmsXmlHtmlValue value = (CmsXmlHtmlValue)this.getValue(name, locale);
        Element element = value.getElement();
        Attribute enabled = element.attribute(ATTRIBUTE_ENABLED);
        if (enabled == null) {
            if (!isEnabled) {
                element.addAttribute(ATTRIBUTE_ENABLED, Boolean.toString(isEnabled));
            }
        } else if (isEnabled) {
            element.remove(enabled);
        } else {
            enabled.setValue(Boolean.toString(isEnabled));
        }
    }

    public void setStringValue(CmsObject cms, String name, Locale locale, String content) throws CmsXmlException {
        CmsXmlHtmlValue value = (CmsXmlHtmlValue)this.getValue(name, locale);
        if (value == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XML_PAGE_INVALID_ELEM_SELECT_2", locale, name));
        }
        value.setStringValue(cms, content);
    }

    @Override
    public CmsXmlContentErrorHandler validate(CmsObject cms) {
        return new CmsXmlContentErrorHandler();
    }

    @Override
    protected void initDocument(Document document, String encoding, CmsXmlContentDefinition definition) {
        this.m_encoding = CmsEncoder.lookupEncoding(encoding, encoding);
        this.m_document = document;
        this.m_elementLocales = new HashMap();
        this.m_elementNames = new HashMap();
        this.m_locales = new HashSet();
        if (!NODE_PAGES.equals(this.m_document.getRootElement().getName())) {
            this.convertOldDocument();
        }
        this.clearBookmarks();
        Element pages = this.m_document.getRootElement();
        try {
            Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(pages, NODE_PAGE);
            while (i.hasNext()) {
                Element page = i.next();
                Locale locale = CmsLocaleManager.getLocale(page.attributeValue(ATTRIBUTE_LANGUAGE));
                Iterator<Element> j = CmsXmlGenericWrapper.elementIterator(page, NODE_ELEMENT);
                while (j.hasNext()) {
                    Element element = j.next();
                    String name = element.attributeValue(ATTRIBUTE_NAME);
                    String elementEnabled = element.attributeValue(ATTRIBUTE_ENABLED);
                    boolean enabled = elementEnabled == null ? true : Boolean.valueOf(elementEnabled);
                    CmsXmlHtmlValue value = new CmsXmlHtmlValue(this, element, locale);
                    value.setContentDefinition(definition);
                    this.addBookmark(CmsXmlUtils.createXpathElement(name, 1), locale, enabled, value);
                }
                this.addLocale(locale);
            }
        }
        catch (NullPointerException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_XML_PAGE_INIT_BOOKMARKS_0"), (Throwable)e);
        }
    }

    protected void setAllowRelativeLinks(boolean value) {
        this.m_allowRelativeLinks = value;
    }

    protected void setFile(CmsFile file) {
        this.m_file = file;
    }

    private void convertOldDocument() {
        Document newDocument = DocumentHelper.createDocument();
        Element root = newDocument.addElement(NODE_PAGES);
        root.add(I_CmsXmlSchemaType.XSI_NAMESPACE);
        root.addAttribute(I_CmsXmlSchemaType.XSI_NAMESPACE_ATTRIBUTE_NO_SCHEMA_LOCATION, XMLPAGE_XSD_SYSTEM_ID);
        HashMap<String, Element> pages = new HashMap<String, Element>();
        if (this.m_document.getRootElement() != null && this.m_document.getRootElement().element(NODE_ELEMENTS) != null) {
            Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(this.m_document.getRootElement().element(NODE_ELEMENTS), NODE_ELEMENT);
            while (i.hasNext()) {
                Element elem = i.next();
                try {
                    Element content;
                    Element links;
                    String elementName = elem.attributeValue(ATTRIBUTE_NAME);
                    String elementLang = elem.attributeValue(ATTRIBUTE_LANGUAGE);
                    String elementEnabled = elem.attributeValue(ATTRIBUTE_ENABLED);
                    boolean enabled = elementEnabled == null ? true : Boolean.valueOf(elementEnabled);
                    Element page = (Element)pages.get(elementLang);
                    if (page == null) {
                        page = root.addElement(NODE_PAGE).addAttribute(ATTRIBUTE_LANGUAGE, elementLang);
                        pages.put(elementLang, page);
                    }
                    Element newElement = page.addElement(NODE_ELEMENT).addAttribute(ATTRIBUTE_NAME, elementName);
                    if (!enabled) {
                        newElement.addAttribute(ATTRIBUTE_ENABLED, String.valueOf(enabled));
                    }
                    if ((links = elem.element(NODE_LINKS)) != null) {
                        newElement.add(links.createCopy());
                    }
                    if ((content = elem.element(NODE_CONTENT)) == null) continue;
                    newElement.add(content.createCopy());
                }
                catch (NullPointerException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_XML_PAGE_CONVERT_CONTENT_0"), (Throwable)e);
                }
            }
        }
        this.m_document = newDocument;
    }
}

