/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlValueTextBase;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlBooleanValue
extends A_CmsXmlValueTextBase {
    public static final String TYPE_NAME = "OpenCmsBoolean";
    public static final String TYPE_RULE = "true|false|1|0";
    private static final Pattern TYPE_PATTERN = Pattern.compile("true|false|1|0");
    private boolean m_boolean;

    public CmsXmlBooleanValue() {
    }

    public CmsXmlBooleanValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
        this.m_boolean = CmsXmlBooleanValue.getBooleanValue(this.m_stringValue);
    }

    public CmsXmlBooleanValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    public static boolean getBooleanValue(CmsObject cms, I_CmsWidgetParameter value) {
        boolean result = value instanceof CmsXmlBooleanValue ? ((CmsXmlBooleanValue)value).getBooleanValue() : CmsXmlBooleanValue.getBooleanValue(value.getStringValue(cms));
        return result;
    }

    private static boolean getBooleanValue(String value) {
        if ("1".equals(value)) {
            return true;
        }
        return Boolean.valueOf(value);
    }

    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlBooleanValue(document, element, locale, this);
    }

    public boolean getBooleanValue() {
        return this.m_boolean;
    }

    public String getDefault(Locale locale) {
        if (this.m_defaultValue != null) {
            return this.m_defaultValue;
        }
        return CmsStringUtil.FALSE;
    }

    public String getSchemaDefinition() {
        return "<xsd:simpleType name=\"OpenCmsBoolean\"><xsd:restriction base=\"xsd:boolean\" /></xsd:simpleType>";
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isSearchable() {
        return false;
    }

    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlBooleanValue(name, minOccurs, maxOccurs);
    }

    public void setStringValue(CmsObject cms, String value) throws CmsIllegalArgumentException {
        this.m_boolean = CmsXmlBooleanValue.getBooleanValue(value);
        super.setStringValue(cms, String.valueOf(this.m_boolean));
    }

    public boolean validateValue(String value) {
        return TYPE_PATTERN.matcher(value).matches();
    }
}

