/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.util.CmsUUID;

public class CmsCurrentPageProject
implements I_CmsVirtualProject {
    public static final CmsUUID ID = CmsUUID.getConstantUUID("currentpage");
    public static final CmsCurrentPageProject INSTANCE = new CmsCurrentPageProject();
    static final Log LOG = CmsLog.getLog(CmsCurrentPageProject.class);

    @Override
    public Context createContext(CmsObject cms, Map<String, String> params) {
        return new Context(cms, params);
    }

    @Override
    public CmsUUID getProjectId() {
        return ID;
    }

    public class Context
    implements I_CmsVirtualProject.I_Context {
        protected Map<String, String> m_params;
        private CmsObject m_cms;

        public Context(CmsObject cms, Map<String, String> params) {
            this.m_cms = cms;
            this.m_params = params;
        }

        @Override
        public CmsProjectBean getProjectBean() {
            String pageId = this.m_params.get("containerpage");
            String elementId = this.m_params.get("content");
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
            String title = Messages.get().getBundle(locale).key("GUI_CURRENTPAGE_PROJECT_0");
            if (pageId == null && elementId == null) {
                return null;
            }
            CmsUUID structureIdForTitle = pageId != null ? new CmsUUID(pageId) : new CmsUUID(elementId);
            CmsProjectBean bean = new CmsProjectBean(ID, 0, title, title);
            bean.setRank(100);
            bean.setDefaultGroupName("");
            try {
                CmsResource titleResource = this.m_cms.readResource(structureIdForTitle, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsProperty titleProp = this.m_cms.readPropertyObject(titleResource, "Title", true);
                String rawName = titleProp.isNullProperty() ? this.m_cms.getSitePath(titleResource) : titleProp.getValue();
                bean.setDefaultGroupName(Messages.get().getBundle(locale).key("GUI_PAGE_1", rawName));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return bean;
        }

        @Override
        public List<CmsResource> getResources() {
            String containerpageId = this.m_params.get("containerpage");
            String elementId = this.m_params.get("content");
            String detailId = this.m_params.get("detail");
            ArrayList<CmsUUID> startIds = new ArrayList<CmsUUID>();
            for (String id : new String[]{containerpageId, elementId, detailId}) {
                if (!CmsUUID.isValidUUID(id)) continue;
                startIds.add(new CmsUUID(id));
            }
            return this.collectResources(startIds);
        }

        @Override
        public void preSort(List<CmsPublishResource> publishResources) {
            Collections.sort(publishResources, new Comparator<CmsPublishResource>(){

                @Override
                public int compare(CmsPublishResource first, CmsPublishResource second) {
                    return ComparisonChain.start().compareTrueFirst(this.isNotPage(first), this.isNotPage(second)).compare(second.getSortDate(), first.getSortDate()).result();
                }

                private boolean isNotPage(CmsPublishResource res) {
                    String idStr = "" + res.getId();
                    String page = Context.this.m_params.get("containerpage");
                    return Objects.equal((Object)idStr, (Object)page);
                }
            });
        }

        private List<CmsResource> collectResources(Collection<CmsUUID> startIds) {
            HashSet<CmsUUID> followedRelations = new HashSet<CmsUUID>();
            LinkedList<CmsUUID> toFollow = new LinkedList<CmsUUID>();
            HashSet<CmsResource> result = new HashSet<CmsResource>();
            toFollow.addAll(startIds);
            while (toFollow.size() > 0) {
                CmsUUID currentId = (CmsUUID)toFollow.removeFirst();
                LOG.info((Object)("Visiting: " + currentId));
                if (followedRelations.contains(currentId)) continue;
                followedRelations.add(currentId);
                if (currentId.isNullUUID()) continue;
                try {
                    CmsResource currentResource = this.m_cms.readResource(currentId, CmsResourceFilter.ALL);
                    LOG.info((Object)("adding resource with root path: " + currentResource.getRootPath()));
                    result.add(currentResource);
                    List<CmsRelation> relations = this.m_cms.readRelations(CmsRelationFilter.relationsFromStructureId(currentId));
                    for (CmsRelation relation : relations) {
                        LOG.info((Object)("got relation to " + relation.getTargetPath() + " (" + relation.getTargetId() + ")"));
                        if (relation.getType().isStrong()) {
                            LOG.info((Object)"(strong relation)");
                            toFollow.add(relation.getTargetId());
                            continue;
                        }
                        LOG.info((Object)"(weak relation)");
                        try {
                            CmsResource weakResource = relation.getTarget(this.m_cms, CmsResourceFilter.ALL);
                            for (String typeName : new String[]{CmsResourceTypePlain.getStaticTypeName(), CmsResourceTypeImage.getStaticTypeName(), CmsResourceTypePointer.getStaticTypeName(), CmsResourceTypeBinary.getStaticTypeName()}) {
                                if (!OpenCms.getResourceManager().matchResourceType(typeName, weakResource.getTypeId())) continue;
                                LOG.info((Object)("Of document type -> adding " + weakResource.getRootPath()));
                                result.add(weakResource);
                            }
                        }
                        catch (CmsException e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    HashSet<CmsResource> changedParentFolders = new HashSet<CmsResource>();
                    for (CmsResource res : result) {
                        if (!res.isFile()) continue;
                        try {
                            CmsResource parentFolder = this.m_cms.readParentFolder(res.getStructureId());
                            if (parentFolder.getState().isUnchanged()) continue;
                            changedParentFolders.add(parentFolder);
                        }
                        catch (CmsPermissionViolationException e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    result.addAll(changedParentFolders);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return this.filterChanged(result);
        }

        private List<CmsResource> filterChanged(Collection<CmsResource> resources) {
            ArrayList<CmsResource> result = new ArrayList<CmsResource>();
            for (CmsResource res : resources) {
                if (res.getState().isUnchanged()) continue;
                result.add(res);
            }
            return result;
        }
    }
}

