/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsCurrentPageProject;
import org.opencms.ade.publish.CmsDefaultPublishGroupHelper;
import org.opencms.ade.publish.CmsRealProjectVirtualWrapper;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishGroup;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.ade.publish.shared.CmsPublishResourceInfo;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.gwt.CmsVfsService;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishManager;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationPublishValidator;
import org.opencms.relations.CmsRelationValidatorInfoEntry;
import org.opencms.report.CmsHtmlReport;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsPublish {
    protected static final int GROUP_DAYS_NUMBER = 3;
    protected static final int GROUP_SESSIONS_GAP = 28800000;
    protected static final int GROUP_SESSIONS_NUMBER = 2;
    private static final Log LOG = CmsLog.getLog(CmsPublish.class);
    private static Map<CmsUUID, I_CmsVirtualProject> virtualProjectHandlers = new HashMap<CmsUUID, I_CmsVirtualProject>();
    protected final CmsObject m_cms;
    protected final CmsPublishOptions m_options;
    protected final Locale m_workplaceLocale;
    private ResourcesAndRelated m_resourceList;
    private boolean m_setRemovable;

    public CmsPublish(CmsObject cms) {
        this(cms, new HashMap<String, String>());
    }

    public CmsPublish(CmsObject cms, CmsPublishOptions options) {
        this.m_cms = cms;
        this.m_workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        this.m_options = options;
    }

    public CmsPublish(CmsObject cms, Map<String, String> params) {
        this(cms, new CmsPublishOptions(params));
    }

    public static CmsProjectBean createProjectBeanFromProject(CmsObject cms, CmsProject project) {
        CmsProjectBean manProj = new CmsProjectBean(project.getUuid(), project.getType().getMode(), CmsPublish.wrapProjectName(cms, CmsPublish.getOuAwareName(cms, project.getName())), project.getDescription());
        return manProj;
    }

    public static I_CmsVirtualProject getRealOrVirtualProject(CmsUUID id) {
        I_CmsVirtualProject project = CmsPublish.getVirtualProject(id);
        if (project != null) {
            return project;
        }
        return new CmsRealProjectVirtualWrapper(id);
    }

    public static I_CmsVirtualProject getVirtualProject(CmsUUID id) {
        return virtualProjectHandlers.get(id);
    }

    public static void registerVirtualProject(I_CmsVirtualProject handler) {
        if (virtualProjectHandlers.containsKey(handler.getProjectId())) {
            return;
        }
        virtualProjectHandlers.put(handler.getProjectId(), handler);
    }

    public static String wrapProjectName(CmsObject cms, String name) {
        return Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_NORMAL_PROJECT_1", name);
    }

    protected static String getOuAwareName(CmsObject cms, String name) {
        String ou = CmsOrganizationalUnit.getParentFqn(name);
        if (ou.equals(cms.getRequestContext().getCurrentUser().getOuFqn())) {
            return CmsOrganizationalUnit.getSimpleName(name);
        }
        return "/" + name;
    }

    public List<CmsPublishResource> getBrokenResources(List<CmsResource> pubResources) {
        CmsPublishList publishList;
        ArrayList<CmsPublishResource> resources = new ArrayList<CmsPublishResource>();
        CmsPublishManager publishManager = OpenCms.getPublishManager();
        try {
            publishList = OpenCms.getPublishManager().getPublishListAll(this.m_cms, pubResources, this.m_options.isIncludeSiblings(), true);
            if (this.m_options.isIncludeRelated()) {
                CmsPublishList related = publishManager.getRelatedResourcesToPublish(this.m_cms, publishList);
                publishList = publishManager.mergePublishLists(this.m_cms, publishList, related);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return resources;
        }
        CmsRelationPublishValidator validator = new CmsRelationPublishValidator(this.m_cms, publishList);
        for (String resourceName : validator.keySet()) {
            CmsRelationValidatorInfoEntry infoEntry = validator.getInfoEntry(resourceName);
            try {
                CmsResource resource = this.m_cms.readResource(this.m_cms.getRequestContext().removeSiteRoot(resourceName), CmsResourceFilter.ALL);
                if (resource.getState().isDeleted()) {
                    for (CmsRelation relation : infoEntry.getRelations()) {
                        try {
                            CmsResource theResource = relation.getSource(this.m_cms, CmsResourceFilter.ALL);
                            CmsPublishResourceInfo info = new CmsPublishResourceInfo(Messages.get().getBundle(this.m_workplaceLocale).key("GUI_BROKEN_LINK_ONLINE_0"), CmsPublishResourceInfo.Type.BROKENLINK);
                            ArrayList<CmsPublishResource> relatedList = new ArrayList<CmsPublishResource>();
                            relatedList.add(this.resourceToBean(resource, info, false, null));
                            CmsPublishResource pubRes = this.resourceToBean(theResource, null, false, relatedList);
                            resources.add(pubRes);
                        }
                        catch (CmsException e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    continue;
                }
                try {
                    ArrayList<CmsPublishResource> related = new ArrayList<CmsPublishResource>();
                    for (CmsRelation relation : infoEntry.getRelations()) {
                        CmsPublishResource pubRes;
                        try {
                            CmsResource theResource = relation.getTarget(this.m_cms, CmsResourceFilter.ALL);
                            pubRes = this.resourceToBean(theResource, null, false, null);
                            related.add(pubRes);
                        }
                        catch (CmsException e) {
                            pubRes = this.relationToBean(relation);
                            related.add(pubRes);
                            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    CmsPublishResourceInfo info = new CmsPublishResourceInfo(Messages.get().getBundle(this.m_workplaceLocale).key("GUI_RESOURCE_MISSING_ONLINE_0"), CmsPublishResourceInfo.Type.MISSING);
                    CmsPublishResource pubRes = this.resourceToBean(resource, info, false, related);
                    resources.add(pubRes);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return resources;
    }

    public List<CmsProjectBean> getManageableProjects() {
        List<CmsProject> projects;
        ArrayList<CmsProjectBean> manProjs = new ArrayList<CmsProjectBean>();
        try {
            projects = OpenCms.getOrgUnitManager().getAllManageableProjects(this.m_cms, "", true);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return manProjs;
        }
        for (CmsProject project : projects) {
            CmsProjectBean manProj = CmsPublish.createProjectBeanFromProject(this.m_cms, project);
            manProjs.add(manProj);
        }
        for (I_CmsVirtualProject handler : virtualProjectHandlers.values()) {
            CmsProjectBean projectBean = handler.createContext(this.m_cms, this.m_options.getParameters()).getProjectBean();
            if (projectBean == null) continue;
            manProjs.add(projectBean);
        }
        return manProjs;
    }

    public CmsPublishOptions getOptions() {
        return this.m_options;
    }

    public List<CmsPublishGroup> getPublishGroups() {
        ResourcesAndRelated rawPublishResources = this.getPublishResourcesInternal();
        if (rawPublishResources.getResources().isEmpty()) {
            return new ArrayList<CmsPublishGroup>();
        }
        List<CmsPublishResource> publishResources = this.getPublishResourceBeans(rawPublishResources);
        CmsDefaultPublishGroupHelper groupHelper = new CmsDefaultPublishGroupHelper(this.m_workplaceLocale);
        List<CmsPublishGroup> resultGroups = groupHelper.getGroups(publishResources);
        return resultGroups;
    }

    public List<CmsPublishResource> getPublishResourceBeans() {
        return this.getPublishResourceBeans(this.getPublishResourcesInternal());
    }

    public List<CmsPublishResource> getPublishResourceBeans(ResourcesAndRelated rawPublishResources) {
        Set<CmsResource> published = this.getAlreadyPublishedResources(rawPublishResources);
        HashSet<CmsResource> exclude = new HashSet<CmsResource>(published);
        ResourcesAndRelated permissions = this.getResourcesWithoutPermissions(rawPublishResources, exclude);
        exclude.addAll(permissions.getResources());
        exclude.addAll(permissions.getRelatedResources());
        ResourcesAndRelated locked = this.getBlockingLockedResources(rawPublishResources, exclude);
        exclude.clear();
        exclude.addAll(published);
        exclude.addAll(permissions.getResources());
        exclude.addAll(locked.getResources());
        ResourcesAndRelated pubResources = new ResourcesAndRelated();
        pubResources.getResources().addAll(rawPublishResources.getResources());
        pubResources.getResources().removeAll(exclude);
        pubResources.getRelatedResources().addAll(rawPublishResources.getRelatedResources());
        pubResources.getRelatedResources().removeAll(permissions.getRelatedResources());
        pubResources.getRelatedResources().removeAll(locked.getRelatedResources());
        ArrayList<CmsResource> resourcesWithoutTempfiles = new ArrayList<CmsResource>();
        for (CmsResource res : rawPublishResources.getResources()) {
            if (CmsResource.isTemporaryFileName(res.getRootPath())) continue;
            resourcesWithoutTempfiles.add(res);
        }
        HashSet<CmsResource> allPubRes = new HashSet<CmsResource>(pubResources.getRelatedResources());
        allPubRes.addAll(pubResources.getResources());
        ArrayList<CmsResource> pubList = new ArrayList();
        try {
            pubList = OpenCms.getPublishManager().getUsersPubList(this.m_cms);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        ArrayList<CmsPublishResource> publishResources = new ArrayList<CmsPublishResource>();
        for (CmsResource resource : resourcesWithoutTempfiles) {
            CmsPublishResource pubRes = this.createPublishResource(resource, pubList, allPubRes, published, permissions, locked);
            publishResources.add(pubRes);
        }
        if (!this.m_setRemovable) {
            for (CmsPublishResource res : publishResources) {
                res.setRemovable(false);
            }
        }
        return publishResources;
    }

    public List<CmsResource> getPublishResources() {
        return new ArrayList<CmsResource>(this.getPublishResourcesInternal().getResources());
    }

    public ResourcesAndRelated getPublishResourcesInternal() {
        if (this.m_resourceList != null) {
            return this.m_resourceList;
        }
        this.m_resourceList = new ResourcesAndRelated();
        try {
            List<CmsResource> rawResourceList = this.getRawPublishResources();
            this.m_resourceList.getResources().addAll(rawResourceList);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return this.m_resourceList;
        }
        if (this.m_options.isIncludeSiblings()) {
            this.addSiblings(this.m_resourceList);
        }
        if (this.m_options.isIncludeRelated()) {
            this.addRelated(this.m_resourceList);
        }
        return this.m_resourceList;
    }

    public void publishResources(List<CmsResource> resources) throws CmsException {
        CmsObject cms = this.m_cms;
        CmsHtmlReport report = new CmsHtmlReport(cms.getRequestContext().getLocale(), cms.getRequestContext().getSiteRoot());
        CmsPublishManager publishManager = OpenCms.getPublishManager();
        CmsPublishList publishList = publishManager.getPublishListAll(this.m_cms, resources, this.m_options.isIncludeSiblings(), true);
        if (this.m_options.isIncludeRelated()) {
            CmsPublishList related = publishManager.getRelatedResourcesToPublish(this.m_cms, publishList);
            LOG.info((Object)"merging related resources into publish list.");
            publishList = publishManager.mergePublishLists(this.m_cms, publishList, related);
        }
        OpenCms.getPublishManager().publishProject(this.m_cms, report, publishList);
    }

    public CmsPublishResource relationToBean(CmsRelation relation) {
        return new CmsPublishResource(relation.getTargetId(), relation.getTargetPath(), relation.getTargetPath(), CmsResourceTypePlain.getStaticTypeName(), CmsResourceState.STATE_UNCHANGED, 0L, null, null, false, null, null);
    }

    public void removeResourcesFromPublishList(Collection<CmsUUID> idsToRemove) throws CmsException {
        OpenCms.getPublishManager().removeResourceFromUsersPubList(this.m_cms, idsToRemove);
    }

    protected void addRelated(ResourcesAndRelated resourceList) {
        for (CmsResource resource : resourceList.getResources()) {
            if (resource.getState().isUnchanged()) continue;
            try {
                for (CmsRelation relation : this.m_cms.getRelationsForResource(resource, CmsRelationFilter.TARGETS.filterStrong())) {
                    CmsResource target = null;
                    try {
                        target = relation.getTarget(this.m_cms, CmsResourceFilter.ALL);
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        continue;
                    }
                    if (target.getState().isUnchanged() || resourceList.contains(target)) continue;
                    resourceList.getRelatedResources().add(target);
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected void addSiblings(ResourcesAndRelated resourceList) {
        for (CmsResource resource : new HashSet<CmsResource>(resourceList.getResources())) {
            if (resource.getState().isUnchanged()) continue;
            try {
                resourceList.getResources().addAll(this.m_cms.readSiblings(this.m_cms.getSitePath(resource), CmsResourceFilter.ALL_MODIFIED));
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected CmsPublishResource createPublishResource(CmsResource resource, List<CmsResource> pubList, Set<CmsResource> allPubRes, Set<CmsResource> published, ResourcesAndRelated permissions, ResourcesAndRelated locked) {
        List<CmsPublishResource> related = this.getRelatedResources(resource, allPubRes, published, permissions, locked);
        CmsPublishResourceInfo info = this.getResourceInfo(resource, published, permissions, locked);
        CmsPublishResource pubResource = this.resourceToBean(resource, info, pubList.contains(resource), related);
        return pubResource;
    }

    protected Set<CmsResource> getAlreadyPublishedResources(ResourcesAndRelated publishResources) {
        HashSet<CmsResource> resources = new HashSet<CmsResource>();
        for (CmsResource resource : publishResources.getResources()) {
            if (!resource.getState().isUnchanged()) continue;
            resources.add(resource);
        }
        return resources;
    }

    protected ResourcesAndRelated getBlockingLockedResources(ResourcesAndRelated publishResources, Set<CmsResource> exclude) {
        CmsUser user = this.m_cms.getRequestContext().getCurrentUser();
        CmsLockFilter blockingFilter = CmsLockFilter.FILTER_ALL;
        blockingFilter = blockingFilter.filterNotLockableByUser(user);
        ResourcesAndRelated result = new ResourcesAndRelated();
        HashMap cache1 = Maps.newHashMap();
        for (CmsResource resource : publishResources.getResources()) {
            if (exclude.contains(resource)) continue;
            try {
                result.getResources().addAll(this.m_cms.getLockedResourcesWithCache(resource, blockingFilter, cache1));
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        for (CmsResource resource : publishResources.getRelatedResources()) {
            if (exclude.contains(resource)) continue;
            try {
                result.getRelatedResources().addAll(this.m_cms.getLockedResourcesWithCache(resource, blockingFilter, cache1));
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected List<CmsResource> getRawPublishResources() throws CmsException {
        List<CmsResource> rawResourceList = new ArrayList<CmsResource>();
        if (this.m_options.getProjectId() == null || this.m_options.getProjectId().isNullUUID()) {
            rawResourceList.addAll(OpenCms.getPublishManager().getUsersPubList(this.m_cms));
            this.m_setRemovable = true;
        } else {
            I_CmsVirtualProject projectHandler = null;
            projectHandler = CmsPublish.getRealOrVirtualProject(this.m_options.getProjectId());
            if (projectHandler != null) {
                rawResourceList = projectHandler.createContext(this.m_cms, this.m_options.getParameters()).getResources();
                return rawResourceList;
            }
        }
        return rawResourceList;
    }

    protected List<CmsPublishResource> getRelatedResources(CmsResource resource, Set<CmsResource> resources, Set<CmsResource> published, ResourcesAndRelated permissions, ResourcesAndRelated locked) {
        ArrayList<CmsPublishResource> relatedResources;
        block7: {
            relatedResources = new ArrayList<CmsPublishResource>();
            try {
                for (CmsRelation relation : this.m_cms.getRelationsForResource(resource, CmsRelationFilter.TARGETS.filterStrong())) {
                    CmsPublishResourceInfo info;
                    CmsResource target = null;
                    try {
                        target = relation.getTarget(this.m_cms, CmsResourceFilter.ALL);
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        continue;
                    }
                    if (resources.contains(target)) {
                        info = this.getResourceInfo(resource, published, permissions, locked);
                    } else {
                        if (target.getState().isUnchanged()) continue;
                        info = new CmsPublishResourceInfo(Messages.get().getBundle(this.m_workplaceLocale).key("GUI_RELATED_RESOURCE_CAN_NOT_BE_PUBLISHED_0"), CmsPublishResourceInfo.Type.RELATED);
                    }
                    CmsPublishResource relatedResource = this.resourceToBean(target, info, false, null);
                    relatedResources.add(relatedResource);
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return relatedResources;
    }

    protected CmsPublishResourceInfo getResourceInfo(CmsResource resource, Set<CmsResource> published, ResourcesAndRelated permissions, ResourcesAndRelated locked) {
        String info = null;
        CmsPublishResourceInfo.Type infoType = null;
        try {
            if (published.contains(resource)) {
                String publishUser = CmsPublish.getOuAwareName(this.m_cms, this.m_cms.readUser(resource.getUserLastModified()).getName());
                Date publishDate = new Date(resource.getDateLastModified());
                info = Messages.get().getBundle(this.m_workplaceLocale).key("GUI_RESOURCE_PUBLISHED_BY_2", publishUser, publishDate);
                infoType = CmsPublishResourceInfo.Type.PUBLISHED;
            } else if (permissions.contains(resource)) {
                info = Messages.get().getBundle(this.m_workplaceLocale).key("GUI_RESOURCE_NOT_ENOUGH_PERMISSIONS_0");
                infoType = CmsPublishResourceInfo.Type.PERMISSIONS;
            } else if (locked.contains(resource)) {
                CmsLock lock = this.m_cms.getLock(resource);
                info = Messages.get().getBundle(this.m_workplaceLocale).key("GUI_RESOURCE_LOCKED_BY_2", CmsPublish.getOuAwareName(this.m_cms, this.m_cms.readUser(lock.getUserId()).getName()), CmsPublish.getOuAwareName(this.m_cms, lock.getProject().getName()));
                infoType = CmsPublishResourceInfo.Type.LOCKED;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return infoType == null ? null : new CmsPublishResourceInfo(info, infoType);
    }

    protected String getResourceName(String rootPath, String siteRoot) {
        if (rootPath.startsWith(siteRoot)) {
            rootPath = rootPath.substring(siteRoot.length());
        } else {
            String site;
            String siteName = site = OpenCms.getSiteManager().getSiteRoot(rootPath);
            if (site != null) {
                rootPath = rootPath.substring(site.length());
                siteName = OpenCms.getSiteManager().getSiteForSiteRoot(site).getTitle();
            } else {
                siteName = "/";
            }
            rootPath = org.opencms.workplace.commons.Messages.get().getBundle(this.m_workplaceLocale).key("GUI_PUBLISH_SITE_RELATION_2", new Object[]{siteName, rootPath});
        }
        return rootPath;
    }

    protected ResourcesAndRelated getResourcesWithoutPermissions(ResourcesAndRelated publishResources, Set<CmsResource> exclude) {
        HashSet<CmsUUID> projectIds = new HashSet<CmsUUID>();
        try {
            for (CmsProject project : OpenCms.getOrgUnitManager().getAllManageableProjects(this.m_cms, "", true)) {
                projectIds.add(project.getUuid());
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        ResourcesAndRelated result = new ResourcesAndRelated();
        for (CmsResource resource : publishResources.getResources()) {
            if (exclude.contains(resource)) continue;
            try {
                if (projectIds.contains(resource.getProjectLastModified()) || this.m_cms.hasPermissions(resource, CmsPermissionSet.ACCESS_DIRECT_PUBLISH)) continue;
                result.getResources().add(resource);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        for (CmsResource resource : publishResources.getRelatedResources()) {
            if (exclude.contains(resource)) continue;
            try {
                if (this.m_cms.hasPermissions(resource, CmsPermissionSet.ACCESS_DIRECT_PUBLISH)) continue;
                result.getRelatedResources().add(resource);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected CmsPublishResource resourceToBean(CmsResource resource, CmsPublishResourceInfo info, boolean removable, List<CmsPublishResource> related) {
        CmsResourceUtil resUtil = new CmsResourceUtil(this.m_cms, resource);
        CmsPublishResource pubResource = new CmsPublishResource(resource.getStructureId(), resUtil.getFullPath(), resUtil.getTitle(), resUtil.getResourceTypeName(), resource.getState(), resource.getDateLastModified(), resUtil.getUserLastModified(), CmsVfsService.formatDateTime(this.m_cms, resource.getDateLastModified()), removable, info, related);
        return pubResource;
    }

    static {
        CmsPublish.registerVirtualProject(CmsCurrentPageProject.INSTANCE);
    }

    public class ResourcesAndRelated {
        private Set<CmsResource> m_relatedResources = new HashSet<CmsResource>();
        private Set<CmsResource> m_resources = new HashSet<CmsResource>();

        public boolean contains(CmsResource resource) {
            return this.m_resources.contains(resource) || this.m_relatedResources.contains(resource);
        }

        public Set<CmsResource> getRelatedResources() {
            return this.m_relatedResources;
        }

        public Set<CmsResource> getResources() {
            return this.m_resources;
        }
    }
}

