/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.opencms.ade.publish.A_CmsPublishGroupHelper;
import org.opencms.ade.publish.CmsCurrentPageProject;
import org.opencms.ade.publish.CmsDefaultPublishGroupHelper;
import org.opencms.ade.publish.CmsPublish;
import org.opencms.ade.publish.CmsSinglePublishGroupHelper;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishData;
import org.opencms.ade.publish.shared.CmsPublishGroup;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.ade.publish.shared.CmsPublishResourceInfo;
import org.opencms.ade.publish.shared.CmsWorkflow;
import org.opencms.ade.publish.shared.CmsWorkflowAction;
import org.opencms.ade.publish.shared.CmsWorkflowResponse;
import org.opencms.ade.publish.shared.rpc.I_CmsPublishService;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsPublishService
extends CmsGwtService
implements I_CmsPublishService {
    public static final String PARAM_PUBLISH_PROJECT_ID = "publishProjectId";
    public static final String PARAM_WORKFLOW_ID = "workflowId";
    private static final long serialVersionUID = 3852074177607037076L;
    private static final String SESSION_ATTR_ADE_PUB_OPTS_CACHE = "__OCMS_ADE_PUB_OPTS_CACHE__";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsPublishData prefetch(HttpServletRequest request) throws CmsRpcException {
        CmsPublishService srv = new CmsPublishService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsPublishData result = null;
        try {
            result = srv.getInitData(new HashMap<String, String>());
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    @Override
    public CmsWorkflowResponse executeAction(List<CmsUUID> toPublish, List<CmsUUID> toRemove, CmsWorkflowAction action) throws CmsRpcException {
        CmsWorkflowResponse response = null;
        try {
            CmsObject cms = this.getCmsObject();
            CmsPublishOptions options = this.getCachedOptions();
            CmsPublish pub = new CmsPublish(cms, options);
            List<CmsResource> publishResources = this.idsToResources(cms, toPublish);
            pub.removeResourcesFromPublishList(toRemove);
            response = OpenCms.getWorkflowManager().executeAction(cms, action, options, publishResources);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return response;
    }

    @Override
    public CmsPublishData getInitData(HashMap<String, String> params) throws CmsRpcException {
        CmsPublishData result = null;
        CmsObject cms = this.getCmsObject();
        try {
            Map<String, CmsWorkflow> workflows = OpenCms.getWorkflowManager().getWorkflows(cms);
            if (workflows.isEmpty()) {
                throw new Exception("No workflow available for the current user");
            }
            String workflowId = this.getRequest().getParameter(PARAM_WORKFLOW_ID);
            if (!(!CmsStringUtil.isEmptyOrWhitespaceOnly(workflowId) && workflows.containsKey(workflowId) || !CmsStringUtil.isEmptyOrWhitespaceOnly(workflowId = this.getLastWorklowForUser()) && workflows.containsKey(workflowId))) {
                workflowId = workflows.values().iterator().next().getId();
            }
            this.setLastWorkflowForUser(workflowId);
            String projectParam = this.getRequest().getParameter(PARAM_PUBLISH_PROJECT_ID);
            boolean useCurrentPage = params.containsKey("startWithCurrentPage");
            CmsPublishOptions options = this.getCachedOptions();
            List<CmsProjectBean> projects = this.getProjects(params);
            boolean foundProject = false;
            CmsUUID selectedProject = null;
            if (useCurrentPage) {
                selectedProject = CmsCurrentPageProject.ID;
                foundProject = true;
            } else {
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(projectParam) && CmsUUID.isValidUUID(projectParam)) {
                    selectedProject = new CmsUUID(projectParam);
                    for (CmsProjectBean project : projects) {
                        if (!selectedProject.equals(project.getId())) continue;
                        foundProject = true;
                        break;
                    }
                }
                if (!foundProject) {
                    selectedProject = options.getProjectId();
                    for (CmsProjectBean project : projects) {
                        if (!selectedProject.equals(project.getId())) continue;
                        foundProject = true;
                        break;
                    }
                }
            }
            if (foundProject) {
                options.setProjectId(selectedProject);
            } else {
                options.setProjectId(CmsUUID.getNullUUID());
            }
            options.setParameters(params);
            result = new CmsPublishData(options, projects, this.getResourceGroups(workflows.get(workflowId), options), workflows, workflowId);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    public List<CmsProjectBean> getProjects(Map<String, String> params) throws CmsRpcException {
        List<CmsProjectBean> result = null;
        try {
            result = new CmsPublish(this.getCmsObject(), params).getManageableProjects();
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsPublishGroup> getResourceGroups(CmsWorkflow workflow, CmsPublishOptions options) throws CmsRpcException {
        List results = null;
        CmsObject cms = this.getCmsObject();
        try {
            A_CmsPublishGroupHelper groupHelper;
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            List<CmsPublishResource> publishResources = OpenCms.getWorkflowManager().getWorkflowPublishResources(cms, workflow, options);
            for (CmsPublishResource publishResource : publishResources) {
                this.checkPreview(publishResource);
            }
            I_CmsVirtualProject.I_Context context = null;
            if (options.getProjectId() == null || options.getProjectId().isNullUUID()) {
                groupHelper = new CmsDefaultPublishGroupHelper(locale);
            } else {
                CmsProjectBean projectBean;
                I_CmsVirtualProject virtualProject = CmsPublish.getRealOrVirtualProject(options.getProjectId());
                String title = "";
                if (virtualProject != null && (title = (projectBean = (context = virtualProject.createContext(cms, options.getParameters())).getProjectBean()).getDefaultGroupName()) == null) {
                    title = "";
                }
                groupHelper = new CmsSinglePublishGroupHelper(locale, title);
            }
            if (options.isIncludeRelated()) {
                publishResources = this.eliminateRelatedResourcesFromTopLevel(publishResources);
                for (CmsPublishResource pubRes : publishResources) {
                    Collections.sort(pubRes.getRelated(), new Comparator<CmsPublishResource>(){

                        @Override
                        public int compare(CmsPublishResource first, CmsPublishResource second) {
                            return ComparisonChain.start().compare(second.getSortDate(), first.getSortDate()).result();
                        }
                    });
                }
            } else {
                this.removeRelatedResources(publishResources);
            }
            if (context != null) {
                context.preSort(publishResources);
            }
            results = groupHelper.getGroups(publishResources);
            this.setCachedOptions(options);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return results;
    }

    public CmsPublishOptions getResourceOptions() throws CmsRpcException {
        CmsPublishOptions result = null;
        try {
            result = this.getCachedOptions();
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    private void checkPreview(CmsPublishResource publishResource) {
        CmsObject cms = this.getCmsObject();
        String noPreviewReason = null;
        try {
            CmsResource resource = cms.readResource(publishResource.getId(), CmsResourceFilter.ONLY_VISIBLE);
            noPreviewReason = CmsVfsService.getNoPreviewReason(cms, resource);
        }
        catch (CmsException e) {
            noPreviewReason = e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
        }
        if (noPreviewReason != null) {
            if (publishResource.getInfo() == null) {
                publishResource.setInfo(new CmsPublishResourceInfo(null, null));
            }
            publishResource.getInfo().setNoPreviewReason(noPreviewReason);
        }
    }

    private List<CmsPublishResource> eliminateRelatedResourcesFromTopLevel(List<CmsPublishResource> publishResources) {
        HashSet<CmsUUID> relatedIds = new HashSet<CmsUUID>();
        for (CmsPublishResource res : publishResources) {
            for (CmsPublishResource related : res.getRelated()) {
                relatedIds.add(related.getId());
            }
        }
        ArrayList<CmsPublishResource> result = new ArrayList<CmsPublishResource>();
        for (CmsPublishResource res : publishResources) {
            if (relatedIds.contains(res.getId()) && res.getRelated().size() <= 0) continue;
            result.add(res);
        }
        return result;
    }

    private CmsPublishOptions getCachedOptions() {
        CmsPublishOptions cache = (CmsPublishOptions)this.getRequest().getSession().getAttribute(SESSION_ATTR_ADE_PUB_OPTS_CACHE);
        if (cache == null) {
            cache = new CmsPublishOptions();
            this.getRequest().getSession().setAttribute(SESSION_ATTR_ADE_PUB_OPTS_CACHE, (Object)cache);
        }
        return cache;
    }

    private String getLastWorklowForUser() {
        CmsUser user = this.getCmsObject().getRequestContext().getCurrentUser();
        return (String)user.getAdditionalInfo(PARAM_WORKFLOW_ID);
    }

    private List<CmsResource> idsToResources(CmsObject cms, List<CmsUUID> ids) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        for (CmsUUID id : ids) {
            try {
                CmsResource resource = cms.readResource(id, CmsResourceFilter.ALL);
                result.add(resource);
            }
            catch (CmsException e) {
                this.logError(e);
            }
        }
        return result;
    }

    private void removeRelatedResources(List<CmsPublishResource> publishResources) {
        for (CmsPublishResource resource : publishResources) {
            resource.getRelated().clear();
        }
    }

    private void setCachedOptions(CmsPublishOptions options) {
        this.getRequest().getSession().setAttribute(SESSION_ATTR_ADE_PUB_OPTS_CACHE, (Object)options);
    }

    private void setLastWorkflowForUser(String workflowId) throws CmsException {
        CmsUser user = this.getCmsObject().getRequestContext().getCurrentUser();
        user.setAdditionalInfo(PARAM_WORKFLOW_ID, workflowId);
        this.getCmsObject().writeUser(user);
    }
}

